/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.CombinedSpringModel;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringModelUtilsImpl
extends SpringModelUtils {
    @NotNull
    public CommonSpringModel getSpringModel(@NotNull SpringModelElement modelElement) {
        if (modelElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelElement", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getSpringModel"));
        }
        Project project = modelElement.getManager().getProject();
        SpringModel file = SpringManager.getInstance((Project)project).getSpringModelByFile((PsiFile)DomUtil.getFile((DomElement)modelElement));
        Object object = file != null ? file : SpringModel.UNKNOWN;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getSpringModel"));
        }
        return object;
    }

    @NotNull
    public CommonSpringModel getSpringModel(@Nullable PsiElement element) {
        if (element == null) {
            CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
            if (commonSpringModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getSpringModel"));
            }
            return commonSpringModel;
        }
        if (element instanceof XmlElement) {
            SpringModel modelForFile;
            PsiFile file = element.getContainingFile();
            if (file instanceof XmlFile && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)file)) && (modelForFile = SpringManager.getInstance((Project)element.getProject()).getSpringModelByFile(file)) != null) {
                SpringModel springModel = modelForFile;
                if (springModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getSpringModel"));
                }
                return springModel;
            }
        } else {
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
            if (psiClass != null) {
                CommonSpringModel commonSpringModel = this.getPsiClassSpringModel(psiClass);
                if (commonSpringModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getSpringModel"));
                }
                return commonSpringModel;
            }
        }
        CommonSpringModel commonSpringModel = this.getModuleCombinedSpringModel(element);
        if (commonSpringModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getSpringModel"));
        }
        return commonSpringModel;
    }

    @NotNull
    public CommonSpringModel getPsiClassSpringModel(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getPsiClassSpringModel"));
        }
        if (!psiClass.isValid()) {
            CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
            if (commonSpringModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getPsiClassSpringModel"));
            }
            return commonSpringModel;
        }
        if (SpringTestContextUtil.getInstance().isTestContextConfigurationClass(psiClass)) {
            CommonSpringModel commonSpringModel = SpringTestContextUtil.getInstance().getSpringTestingModel(psiClass);
            if (commonSpringModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getPsiClassSpringModel"));
            }
            return commonSpringModel;
        }
        if (SpringCommonUtils.isConfigurationOrMeta((PsiClass)psiClass)) {
            CommonSpringModel commonSpringModel = this.getAnnoConfigurationSpringModel(psiClass);
            if (commonSpringModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getPsiClassSpringModel"));
            }
            return commonSpringModel;
        }
        VirtualFile virtualFile = psiClass.getContainingFile().getOriginalFile().getVirtualFile();
        if (virtualFile == null || virtualFile.getFileSystem() instanceof JarFileSystem) {
            Project project = psiClass.getProject();
            CombinedSpringModel combinedSpringModel = SpringModelUtilsImpl.getCombinedModelForProject(project);
            if (combinedSpringModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getPsiClassSpringModel"));
            }
            return combinedSpringModel;
        }
        CommonSpringModel commonSpringModel = this.getModuleCombinedSpringModel((PsiElement)psiClass);
        if (commonSpringModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getPsiClassSpringModel"));
        }
        return commonSpringModel;
    }

    @NotNull
    private CommonSpringModel getAnnoConfigurationSpringModel(@NotNull PsiClass psiClass) {
        SpringModelSearchParameters.BeanClass params;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getAnnoConfigurationSpringModel"));
        }
        CommonSpringModel springModel = this.getModuleCombinedSpringModel((PsiElement)psiClass);
        if (SpringModelSearchers.doesBeanExist((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)(params = SpringModelSearchParameters.byClass((PsiClass)psiClass)))) {
            CommonSpringModel commonSpringModel = springModel;
            if (commonSpringModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getAnnoConfigurationSpringModel"));
            }
            return commonSpringModel;
        }
        LocalAnnotationModel model = SpringManager.getInstance((Project)psiClass.getProject()).getLocalSpringModel(psiClass);
        Object object = model != null ? model : SpringModel.UNKNOWN;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getAnnoConfigurationSpringModel"));
        }
        return object;
    }

    @NotNull
    public CommonSpringModel getModuleCombinedSpringModel(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getModuleCombinedSpringModel"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null || module.isDisposed()) {
            CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
            if (commonSpringModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getModuleCombinedSpringModel"));
            }
            return commonSpringModel;
        }
        SpringModel springModel = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        if (springModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getModuleCombinedSpringModel"));
        }
        return springModel;
    }

    @NotNull
    public CommonSpringModel getSpringModelByBean(@Nullable CommonSpringBean springBean) {
        if (springBean == null) {
            CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
            if (commonSpringModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getSpringModelByBean"));
            }
            return commonSpringModel;
        }
        if (springBean instanceof SpringModelElement) {
            CommonSpringModel commonSpringModel = this.getSpringModel((SpringModelElement)springBean);
            if (commonSpringModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getSpringModelByBean"));
            }
            return commonSpringModel;
        }
        Module module = springBean.getModule();
        if (module != null) {
            SpringModel springModel = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
            if (springModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getSpringModelByBean"));
            }
            return springModel;
        }
        CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
        if (commonSpringModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getSpringModelByBean"));
        }
        return commonSpringModel;
    }

    public boolean isTestContext(Module module, PsiFile file) {
        for (PsiClass contextConfigurationAnno : MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)"org.springframework.test.context.ContextConfiguration", (boolean)true)) {
            String qualifiedName = contextConfigurationAnno.getQualifiedName();
            if (StringUtil.isEmptyOrSpaces((String)qualifiedName)) continue;
            List configurations = JamService.getJamService((Project)module.getProject()).getJamClassElements(ContextConfiguration.CONTEXT_CONFIGURATION_JAM_KEY, qualifiedName, GlobalSearchScope.moduleScope((Module)module));
            for (ContextConfiguration configuration : configurations) {
                CommonSpringModel model = SpringTestContextUtil.getInstance().getSpringTestingModel(configuration.getPsiElement());
                if (!model.hasConfigFile(file)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUsedConfigurationFile(@NotNull PsiFile configurationFile, boolean checkTestFiles) {
        if (configurationFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFile", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "isUsedConfigurationFile"));
        }
        Project project = configurationFile.getProject();
        if (DumbService.isDumb((Project)project)) {
            return false;
        }
        VirtualFile virtualFile = configurationFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            return false;
        }
        ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
        if (!moduleFileIndex.isInContent(virtualFile)) {
            return false;
        }
        if (!checkTestFiles && moduleFileIndex.isInTestSourceContent(virtualFile)) {
            return true;
        }
        Ref result = Ref.create((Object)Boolean.FALSE);
        ModuleUtilCore.visitMeAndDependentModules((Module)module, depModule -> {
            if (configurationFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFile", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "lambda$isUsedConfigurationFile$0"));
            }
            boolean found = SpringFileSetService.getInstance().findFileSet(depModule, configurationFile) != null || checkTestFiles && this.isTestContext(depModule, configurationFile);
            result.set((Object)found);
            return !found;
        });
        return (Boolean)result.get();
    }

    @NotNull
    private static CombinedSpringModel getCombinedModelForProject(Project project) {
        LinkedHashSet allCombinedModels = ContainerUtil.newLinkedHashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Set allModels = SpringManager.getInstance((Project)project).getAllModelsWithoutDependencies(module);
            allCombinedModels.addAll(allModels);
        }
        CombinedSpringModelImpl combinedSpringModelImpl = new CombinedSpringModelImpl(allCombinedModels, null);
        if (combinedSpringModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelUtilsImpl", "getCombinedModelForProject"));
        }
        return combinedSpringModelImpl;
    }
}

