/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.custom;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.custom.CustomBeanInfo;
import com.intellij.spring.model.xml.custom.CustomBeanRegistry;
import com.intellij.unscramble.UnscrambleDialog;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ParseCustomBeanIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = SpringBundle.message("parse.custom.bean.intention", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/custom/ParseCustomBeanIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/custom/ParseCustomBeanIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/xml/custom/ParseCustomBeanIntention", "isAvailable"));
        }
        return DomUtil.findDomElement((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), DomSpringBean.class) instanceof CustomBeanWrapper;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/xml/custom/ParseCustomBeanIntention", "invoke"));
        }
        CustomBeanWrapper wrapper = (CustomBeanWrapper)DomUtil.findDomElement((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), CustomBeanWrapper.class);
        assert (wrapper != null);
        ParseCustomBeanIntention.invokeCustomBeanParsers(project, Arrays.asList(wrapper.getXmlTag()));
        UsageTrigger.trigger((String)"spring.ParseCustomBeanIntention");
    }

    public static void invokeCustomBeanParsers(Project project, Collection<XmlTag> tags) {
        String idAttr;
        Ref ref = Ref.create(null);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
            ApplicationManager.getApplication().runReadAction(() -> ref.set((Object)CustomBeanRegistry.getInstance(project).parseBeans(tags)));
        }, SpringBundle.message("parsing.custom.bean", new Object[0]), false, project);
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiManager.getInstance((Project)project).dropPsiCaches();
            SpringModificationTrackersManager.getInstance((Project)project).fireCustomBeanParserChanged();
        });
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        CustomBeanRegistry.ParseResult result = (CustomBeanRegistry.ParseResult)ref.get();
        String message = result.getErrorMessage();
        if (message != null) {
            NotificationGroup.balloonGroup((String)"Spring custom beans").createNotification(message, NotificationType.ERROR).notify(project);
            return;
        }
        String trace = result.getStackTrace();
        if (trace != null) {
            int exitCode;
            String shortTrace = trace;
            int i = 0;
            for (int j = 0; j < 10; ++j) {
                if (i < 0) continue;
                i = trace.indexOf(10, i + 1);
            }
            if (i >= 0) {
                shortTrace = trace.substring(0, i) + "\n\t...";
            }
            if ((exitCode = Messages.showOkCancelDialog((Project)project, (String)shortTrace, (String)SpringBundle.message("parse.custom.bean.error", new Object[0]), (String)CommonBundle.getOkButtonText(), (String)ActionsBundle.message((String)"action.Unscramble.text", (Object[])new Object[0]), (Icon)Messages.getErrorIcon())) != 0) {
                UnscrambleDialog dialog = new UnscrambleDialog(project);
                dialog.setText(trace);
                dialog.show();
            }
            return;
        }
        List<CustomBeanInfo> infos = result.getBeans();
        assert (infos != null);
        String beansText = StringUtil.join(infos, customBeanInfo -> "  id = " + customBeanInfo.beanName + "; class = " + customBeanInfo.beanClassName, (String)"\n");
        if (infos.size() == 1 && tags.size() == 1 && (idAttr = infos.get((int)0).idAttribute) != null) {
            String localName;
            XmlTag tag = tags.iterator().next();
            String ns = tag.getNamespace();
            String inductMessage = SpringBundle.message("parse.these.beans.induct", beansText, ns, localName = tag.getLocalName(), idAttr);
            if (Messages.showOkCancelDialog((Project)project, (String)inductMessage, (String)SpringBundle.message("parse.custom.bean.success", new Object[0]), (String)SpringBundle.message("parse.these.beans.induct.only.this", new Object[0]), (String)CommonBundle.getYesButtonText(), (Icon)Messages.getInformationIcon()) != 0) {
                CustomBeanInfo beanInfo = new CustomBeanInfo(infos.get(0));
                beanInfo.beanName = null;
                CustomBeanRegistry.getInstance(project).addBeanPolicy(ns, localName, beanInfo);
            }
            return;
        }
        String parsedMessage = !infos.isEmpty() ? SpringBundle.message("parse.these.beans", beansText) : (result.hasInfrastructureBeans() ? SpringBundle.message("parse.only.infrastructure.beans", new Object[0]) : SpringBundle.message("parse.no.custom.beans", new Object[0]));
        Messages.showInfoMessage((Project)project, (String)parsedMessage, (String)SpringBundle.message("parse.custom.bean.success", new Object[0]));
    }

    public boolean startInWriteAction() {
        return false;
    }
}

