/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.ws.util.SpringWebServiceJamUtil;
import com.intellij.spring.ws.util.SpringWebServicesUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NamespaceReference
extends PsiReferenceBase<PsiElement> {
    public NamespaceReference(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/ws/converters/NamespaceReference", "<init>"));
        }
        super(element);
    }

    public NamespaceReference(PsiElement element, TextRange textRange) {
        super(element, textRange);
    }

    public PsiElement resolve() {
        VirtualFile file = this.getSchemas().get(this.getValue());
        return file == null ? null : this.getElement().getManager().findFile(file);
    }

    private Map<String, VirtualFile> getSchemas() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module != null) {
            return SpringWebServiceJamUtil.getSchemas(module);
        }
        return Collections.emptyMap();
    }

    @NotNull
    public Object[] getVariants() {
        HashSet variants = new HashSet();
        for (Map.Entry<String, VirtualFile> entry : this.getSchemas().entrySet()) {
            LookupElement lookupElement = SpringWebServicesUtil.createLookupElementFor(entry.getKey(), this.getElement().getManager().findFile(entry.getValue()));
            variants.add(lookupElement);
        }
        Object[] objectArray = variants.toArray(new LookupElement[variants.size()]);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/converters/NamespaceReference", "getVariants"));
        }
        return objectArray;
    }
}

