/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.inspections.configuration;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.ws.SpringWebServicesBundle;
import com.intellij.spring.ws.inspections.configuration.AddEmailTransportSupportFix;
import com.intellij.spring.ws.inspections.configuration.AddEmbeddedHttpTransportSupportFix;
import com.intellij.spring.ws.inspections.configuration.AddJmsTransportSupportFix;
import com.intellij.spring.ws.inspections.configuration.AddMessageDispatcherServletInWebXmlFix;
import com.intellij.spring.ws.util.SpringWebServicesUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringWebServicesConfigurationsInspection
extends SpringBeanInspectionBase {
    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        Module module = domFileElement.getModule();
        if (module == null) {
            return;
        }
        if (DomJavaUtil.findClass((String)"org.springframework.ws.transport.http.MessageDispatcherServlet", domFileElement) == null) {
            return;
        }
        if (SpringWebServicesUtil.isSpringWebServiceBeansDefined(domFileElement)) {
            Collection webFacets = WebFacet.getInstances((Module)module);
            Servlet messageDispatcherServlet = SpringWebServicesUtil.getMessageDispatcherServlet(webFacets);
            if (messageDispatcherServlet != null) {
                this.checkFileNameAndLocation(domFileElement, holder, messageDispatcherServlet);
            } else {
                XmlFile xmlFile = domFileElement.getFile();
                SpringModel springModel = SpringManager.getInstance((Project)xmlFile.getProject()).getSpringModelByFile((PsiFile)xmlFile);
                if (springModel != null && !this.isSpringWebServiceTransportConfigured(domFileElement, springModel)) {
                    holder.createProblem(domFileElement.getRootElement(), HighlightSeverity.ERROR, SpringWebServicesBundle.message("SpringWebServicesConfigurationsInspection.transport.is.not.configured", new Object[0]), this.getLocalFixes(domFileElement, module));
                }
            }
        }
    }

    private LocalQuickFix[] getLocalFixes(@NotNull DomFileElement<Beans> domFileElement, @NotNull Module module) {
        if (domFileElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domFileElement", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "getLocalFixes"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "getLocalFixes"));
        }
        HashSet fixes = new HashSet();
        XmlFile xmlFile = domFileElement.getFile();
        SpringWebServicesConfigurationsInspection.registerMessageDispatcherServletInWebXmlFix((Set<LocalQuickFix>)fixes, xmlFile);
        SpringWebServicesConfigurationsInspection.registerJmsTransportFix((Set<LocalQuickFix>)fixes, xmlFile);
        SpringWebServicesConfigurationsInspection.registerEmailTransportFix((Set<LocalQuickFix>)fixes, xmlFile);
        SpringWebServicesConfigurationsInspection.registerEmbeddedHttpTransportFix((Set<LocalQuickFix>)fixes, xmlFile);
        return fixes.toArray(new LocalQuickFix[fixes.size()]);
    }

    private static void registerEmbeddedHttpTransportFix(@NotNull Set<LocalQuickFix> fixes, @NotNull XmlFile xmlFile) {
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "registerEmbeddedHttpTransportFix"));
        }
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "registerEmbeddedHttpTransportFix"));
        }
        fixes.add(new AddEmbeddedHttpTransportSupportFix(xmlFile));
    }

    private static void registerEmailTransportFix(@NotNull Set<LocalQuickFix> fixes, @NotNull XmlFile xmlFile) {
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "registerEmailTransportFix"));
        }
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "registerEmailTransportFix"));
        }
        fixes.add(new AddEmailTransportSupportFix(xmlFile));
    }

    private static void registerJmsTransportFix(@NotNull Set<LocalQuickFix> fixes, @NotNull XmlFile xmlFile) {
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "registerJmsTransportFix"));
        }
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "registerJmsTransportFix"));
        }
        fixes.add(new AddJmsTransportSupportFix(xmlFile));
    }

    private static void registerMessageDispatcherServletInWebXmlFix(Set<LocalQuickFix> fixes, XmlFile xmlFile) {
        if (xmlFile.getName().endsWith("-servlet.xml") && SpringWebServicesConfigurationsInspection.isFileInWebInfDirectory(xmlFile)) {
            WebApp webApp = SpringWebServicesConfigurationsInspection.getWebApp(xmlFile);
            String servletName = SpringWebServicesConfigurationsInspection.getServletName(xmlFile.getName());
            if (webApp != null && !StringUtil.isEmptyOrSpaces((String)servletName)) {
                fixes.add(new AddMessageDispatcherServletInWebXmlFix(webApp, servletName));
            }
        }
    }

    @Nullable
    private static WebApp getWebApp(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "getWebApp"));
        }
        WebFacet facet = WebUtil.getWebFacet((PsiElement)xmlFile);
        return facet == null ? null : facet.getRoot();
    }

    @Nullable
    private static String getServletName(@NotNull String filename) {
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filename", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "getServletName"));
        }
        int index = filename.indexOf("-servlet.xml");
        return index < 0 ? null : filename.substring(0, index);
    }

    private boolean isSpringWebServiceTransportConfigured(DomFileElement<Beans> domFileElement, @NotNull SpringModel springModel) {
        if (springModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springModel", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "isSpringWebServiceTransportConfigured"));
        }
        if (this.isEmbeddedHttpServerTransportConfigured(domFileElement, springModel)) {
            return true;
        }
        if (this.isWiringUpSpringWebServicesInDispatcherServlet(domFileElement, springModel)) {
            return true;
        }
        if (this.isJmsTransportConfigured(domFileElement, springModel)) {
            return true;
        }
        return this.isEmailTransportConfigured(domFileElement, springModel);
    }

    private boolean isEmbeddedHttpServerTransportConfigured(DomFileElement<Beans> domFileElement, SpringModel springModel) {
        return SpringWebServicesConfigurationsInspection.hasBeansOfType(domFileElement, springModel, "org.springframework.remoting.support.SimpleHttpServerFactoryBean");
    }

    private boolean isEmailTransportConfigured(DomFileElement<Beans> domFileElement, SpringModel springModel) {
        return SpringWebServicesConfigurationsInspection.hasBeansOfType(domFileElement, springModel, "org.springframework.ws.transport.mail.MailMessageReceiver");
    }

    private boolean isJmsTransportConfigured(DomFileElement<Beans> domFileElement, @NotNull SpringModel springModel) {
        if (springModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springModel", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "isJmsTransportConfigured"));
        }
        return SpringWebServicesConfigurationsInspection.hasBeansOfType(domFileElement, springModel, "org.springframework.jms.listener.AbstractJmsListeningContainer");
    }

    private boolean isWiringUpSpringWebServicesInDispatcherServlet(DomFileElement<Beans> domFileElement, @NotNull SpringModel springModel) {
        if (springModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springModel", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "isWiringUpSpringWebServicesInDispatcherServlet"));
        }
        return SpringWebServicesConfigurationsInspection.hasBeansOfType(domFileElement, springModel, "org.springframework.ws.transport.http.WebServiceMessageReceiverHandlerAdapter");
    }

    private static boolean hasBeansOfType(DomFileElement<Beans> domFileElement, SpringModel springModel, String fqn) {
        PsiClass psiClass = DomJavaUtil.findClass((String)fqn, domFileElement);
        return psiClass != null && SpringModelSearchers.doesBeanExist((CommonSpringModel)springModel, (PsiClass)psiClass);
    }

    private void checkFileNameAndLocation(@NotNull DomFileElement<Beans> domFileElement, @NotNull DomElementAnnotationHolder holder, @NotNull Servlet messageDispatcherServlet) {
        if (domFileElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domFileElement", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "checkFileNameAndLocation"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "checkFileNameAndLocation"));
        }
        if (messageDispatcherServlet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageDispatcherServlet", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "checkFileNameAndLocation"));
        }
        if (SpringWebServicesUtil.getContextConfigurationParam(messageDispatcherServlet) != null) {
            return;
        }
        XmlFile xmlFile = domFileElement.getFile();
        String servletName = messageDispatcherServlet.getServletName().getStringValue();
        if (!StringUtil.isEmptyOrSpaces((String)servletName)) {
            String contextFileName = SpringWebServicesUtil.getApplicationContextFileName(servletName);
            if (contextFileName.equals(xmlFile.getName())) {
                if (!SpringWebServicesConfigurationsInspection.isFileInWebInfDirectory(xmlFile)) {
                    holder.createProblem(domFileElement.getRootElement(), HighlightSeverity.ERROR, SpringWebServicesBundle.message("SpringWebServicesConfigurationsInspection.should.be.located.in.web.inf", new Object[0]));
                }
            } else {
                holder.createProblem(domFileElement.getRootElement(), HighlightSeverity.ERROR, SpringWebServicesBundle.message("SpringWebServicesConfigurationsInspection.should.be.configured.with.specific.file.name", SpringWebServicesUtil.getApplicationContextRelativePath(servletName)));
            }
        }
    }

    private static boolean isFileInWebInfDirectory(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "isFileInWebInfDirectory"));
        }
        PsiDirectory psiDirectory = xmlFile.getParent();
        return psiDirectory != null && "WEB-INF".equals(psiDirectory.getName());
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringWebServicesConfigurationsInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/inspections/configuration/SpringWebServicesConfigurationsInspection", "getShortName"));
        }
        return "SpringWebServicesConfigurationsInspection";
    }
}

