/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.inspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.AndroidUtilKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "RenameIdentifierFix", "idea-android"})
public final class IllegalIdentifierInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitElement(@NotNull PsiElement element2) {
                boolean bl;
                block5: {
                    CharSequence $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                    ASTNode aSTNode = element2.getNode();
                    if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)KtTokens.IDENTIFIER)) ^ true) {
                        return;
                    }
                    String text2 = element2.getText();
                    if (!StringsKt.startsWith$default((CharSequence)text2, (char)'`', (boolean)false, (int)2, null) || !StringsKt.endsWith$default((CharSequence)text2, (char)'`', (boolean)false, (int)2, null)) {
                        return;
                    }
                    String unquotedName = KtPsiUtil.unquoteIdentifier(text2);
                    CharSequence charSequence = unquotedName;
                    if (charSequence.length() == 0) {
                        return;
                    }
                    CharSequence charSequence2 = $receiver$iv = (CharSequence)unquotedName;
                    for (int i = 0; i < charSequence2.length(); ++i) {
                        char element$iv = charSequence2.charAt(i);
                        char it = element$iv;
                        if (this.isValidDalvikCharacter(it)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                if (!bl && this.checkAndroidFacet(element2)) {
                    this.$holder.registerProblem(element2, "Identifier not allowed in Android projects", ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[]{new RenameIdentifierFix()});
                }
            }

            public final boolean checkAndroidFacet(@NotNull PsiElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                return AndroidUtilKt.getAndroidFacetForFile(element2) != null || ApplicationManager.getApplication().isUnitTestMode();
            }

            public final boolean isValidDalvikCharacter(char c) {
                char c2 = c;
                char c3 = c2;
                return 'A' <= c3 && c3 <= 'Z' ? true : ('a' <= (c3 = c2) && c3 <= 'z' ? true : ('0' <= (c3 = c2) && c3 <= '9' ? true : (c2 == '$' || c2 == '-' || c2 == '_' ? true : ('\u00a1' <= (c3 = c2) && c3 <= '\u1fff' ? true : ('\u2010' <= (c3 = c2) && c3 <= '\u2027' ? true : ('\u2030' <= (c3 = c2) && c3 <= '\ud7ff' ? true : '\ue000' <= (c3 = c2) && c3 <= '\uffef'))))));
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection$RenameIdentifierFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "startInWriteAction", "", "idea-android"})
    public static final class RenameIdentifierFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return "Rename";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public boolean startInWriteAction() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block5: {
                void elements$iv;
                RenameHandler renameHandler;
                DataContext dataContext;
                PsiElement element2;
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                    Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                    PsiElement psiElement2 = descriptor2.getPsiElement();
                    if (psiElement2 == null) {
                        return;
                    }
                    element2 = psiElement2;
                    PsiFile psiFile = element2.getContainingFile();
                    if (psiFile == null) {
                        return;
                    }
                    PsiFile file2 = psiFile;
                    if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                        return;
                    }
                    FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
                    FileEditor fileEditor = editorManager.getSelectedEditor(file2.getVirtualFile());
                    if (fileEditor == null) {
                        return;
                    }
                    FileEditor fileEditor2 = fileEditor;
                    dataContext = DataManager.getInstance().getDataContext((Component)fileEditor2.getComponent());
                    renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext);
                    Editor editor = editorManager.getSelectedTextEditor();
                    if (editor == null) break block4;
                    RenameHandler renameHandler2 = renameHandler;
                    if (renameHandler2 == null) break block5;
                    renameHandler2.invoke(project, editor, file2, dataContext);
                    break block5;
                }
                RenameHandler renameHandler3 = renameHandler;
                if (renameHandler3 == null) break block5;
                Object[] objectArray = new PsiElement[]{element2.getParent()};
                Project project2 = project;
                RenameHandler renameHandler4 = renameHandler3;
                void var13_13 = elements$iv;
                renameHandler4.invoke(project2, (PsiElement[])var13_13, dataContext);
            }
        }
    }
}

