/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.builder;

import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.builder.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclarationKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"collectClassNames", "", "javaFileStub", "Lcom/intellij/psi/impl/java/stubs/PsiJavaFileStub;", "findDelegate", "Lcom/intellij/psi/PsiClass;", "classFqName", "Lorg/jetbrains/kotlin/name/FqName;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "light-classes"})
public final class LightClassDataHolderKt {
    @NotNull
    public static final PsiClass findDelegate(@NotNull PsiJavaFileStub $receiver, @NotNull KtClassOrObject classOrObject) {
        String $i$a$2$let;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        PsiClass psiClass2 = LightClassUtil.INSTANCE.findClass((StubElement)$receiver, (Function1)new Function1<PsiClassStub<?>, Boolean>(classOrObject){
            final /* synthetic */ KtClassOrObject $classOrObject;

            public final boolean invoke(@NotNull PsiClassStub<?> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return Intrinsics.areEqual((Object)ClsWrapperStubPsiFactory.getOriginalElement((StubElement)it), (Object)this.$classOrObject);
            }
            {
                this.$classOrObject = ktClassOrObject;
                super(1);
            }
        });
        if (psiClass2 != null) {
            PsiClass psiClass3;
            PsiClass it = psiClass3 = psiClass2;
            return it;
        }
        KtClassOrObject outermostClassOrObject = KtLightClassForSourceDeclarationKt.getOutermostClassOrObject(classOrObject);
        try {
            $i$a$2$let = outermostClassOrObject.getContainingFile().getText();
        }
        catch (Exception e) {
            $i$a$2$let = "Can't get text for outermost class";
        }
        String ktFileText = $i$a$2$let;
        String stubFileText = DebugUtil.stubTreeToString((Stub)((Stub)$receiver));
        throw (Throwable)new IllegalStateException("Couldn't get delegate for " + DebugTextUtilKt.getDebugText(classOrObject) + "\nin " + ktFileText + "\nstub: \n" + stubFileText);
    }

    @NotNull
    public static final PsiClass findDelegate(@NotNull PsiJavaFileStub $receiver, @NotNull FqName classFqName) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)classFqName, (String)"classFqName");
        PsiClass psiClass2 = LightClassUtil.INSTANCE.findClass((StubElement)$receiver, (Function1)new Function1<PsiClassStub<?>, Boolean>(classFqName){
            final /* synthetic */ FqName $classFqName;

            public final boolean invoke(@NotNull PsiClassStub<?> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return Intrinsics.areEqual((Object)this.$classFqName.asString(), (Object)it.getQualifiedName());
            }
            {
                this.$classFqName = fqName2;
                super(1);
            }
        });
        if (psiClass2 == null) {
            throw (Throwable)new IllegalStateException("Facade class " + classFqName + " not found; classes in Java file stub: " + LightClassDataHolderKt.collectClassNames($receiver));
        }
        return psiClass2;
    }

    private static final String collectClassNames(PsiJavaFileStub javaFileStub) {
        List names = new ArrayList();
        LightClassUtil.INSTANCE.findClass((StubElement)javaFileStub, (Function1)new Function1<PsiClassStub<?>, Boolean>(names){
            final /* synthetic */ List $names;

            public final boolean invoke(@NotNull PsiClassStub<?> cls) {
                Intrinsics.checkParameterIsNotNull(cls, (String)"cls");
                String string = cls.getQualifiedName();
                if (string == null) {
                    string = "<null>";
                }
                this.$names.add(string);
                return false;
            }
            {
                this.$names = list2;
                super(1);
            }
        });
        return CollectionsKt.joinToString$default((Iterable)names, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null);
    }
}

