/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmRuntimeTypes;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.TypeMapperUtilsKt;
import org.jetbrains.kotlin.codegen.when.SwitchCodegenUtil;
import org.jetbrains.kotlin.codegen.when.WhenByEnumsMapping;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.kotlin.TypeMappingConfiguration;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

class CodegenAnnotatingVisitor
extends KtVisitorVoid {
    private static final TokenSet BINARY_OPERATIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{KtTokens.AUGMENTED_ASSIGNMENTS, TokenSet.create((IElementType[])new IElementType[]{KtTokens.PLUS, KtTokens.MINUS, KtTokens.MUL, KtTokens.DIV, KtTokens.PERC, KtTokens.RANGE, KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ, KtTokens.IDENTIFIER})});
    private final Map<String, Integer> anonymousSubclassesCount;
    private final Stack<ClassDescriptor> classStack;
    private final Stack<String> nameStack;
    private final BindingTrace bindingTrace;
    private final BindingContext bindingContext;
    private final GenerationState.GenerateClassFilter filter;
    private final JvmRuntimeTypes runtimeTypes;
    private final JvmFileClassesProvider fileClassesProvider;
    private final TypeMappingConfiguration<Type> typeMappingConfiguration;
    private final boolean shouldInlineConstVals;

    public CodegenAnnotatingVisitor(@NotNull GenerationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "<init>"));
        }
        this.anonymousSubclassesCount = new HashMap<String, Integer>();
        this.classStack = new Stack();
        this.nameStack = new Stack();
        this.bindingTrace = state.getBindingTrace();
        this.bindingContext = state.getBindingContext();
        this.filter = state.getGenerateDeclaredClassFilter();
        this.runtimeTypes = state.getJvmRuntimeTypes();
        this.fileClassesProvider = state.getFileClassesProvider();
        this.typeMappingConfiguration = state.getTypeMapper().getTypeMappingConfiguration();
        this.shouldInlineConstVals = state.getShouldInlineConstVals();
    }

    @NotNull
    private ClassDescriptor recordClassForCallable(@NotNull KtElement element2, @NotNull CallableDescriptor callableDescriptor, @NotNull Collection<KotlinType> supertypes2, @NotNull String name2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        if (supertypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        ClassDescriptor classDescriptor = this.recordClassForCallable(element2, callableDescriptor, supertypes2, name2, null);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        return classDescriptor;
    }

    @NotNull
    private ClassDescriptor recordClassForFunction(@NotNull KtElement element2, @NotNull FunctionDescriptor functionDescriptor2, @NotNull String name2, @Nullable DeclarationDescriptor customContainer) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForFunction"));
        }
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForFunction"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForFunction"));
        }
        ClassDescriptor classDescriptor = this.recordClassForCallable(element2, functionDescriptor2, this.runtimeTypes.getSupertypesForClosure(functionDescriptor2), name2, customContainer);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForFunction"));
        }
        return classDescriptor;
    }

    @NotNull
    private ClassDescriptor recordClassForCallable(@NotNull KtElement element2, @NotNull CallableDescriptor callableDescriptor, @NotNull Collection<KotlinType> supertypes2, @NotNull String name2, @Nullable DeclarationDescriptor customContainer) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        if (supertypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        String simpleName = name2.substring(name2.lastIndexOf(47) + 1);
        SyntheticClassDescriptorForLambda classDescriptor = new SyntheticClassDescriptorForLambda(customContainer != null ? customContainer : this.correctContainerForLambda(callableDescriptor, element2), Name.special("<closure-" + simpleName + ">"), supertypes2, element2);
        this.bindingTrace.record(CodegenBinding.CLASS_FOR_CALLABLE, callableDescriptor, classDescriptor);
        SyntheticClassDescriptorForLambda syntheticClassDescriptorForLambda = classDescriptor;
        if (syntheticClassDescriptorForLambda == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        return syntheticClassDescriptorForLambda;
    }

    @NotNull
    private DeclarationDescriptor correctContainerForLambda(@NotNull CallableDescriptor descriptor2, @NotNull KtElement function2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "correctContainerForLambda"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "correctContainerForLambda"));
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (container2 instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(container2.getContainingDeclaration())) {
            KtElement element2 = function2;
            while (element2 != null) {
                KtElement child = element2;
                if (this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element2 = element2.getParent()) == container2) {
                    DeclarationDescriptor declarationDescriptor = container2;
                    if (declarationDescriptor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "correctContainerForLambda"));
                    }
                    return declarationDescriptor;
                }
                if (!(element2 instanceof KtObjectDeclaration) || !(element2.getParent() instanceof KtObjectLiteralExpression) || !(child instanceof KtSuperTypeList)) continue;
                container2 = container2.getContainingDeclaration().getContainingDeclaration();
            }
        }
        DeclarationDescriptor declarationDescriptor = container2;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "correctContainerForLambda"));
        }
        return declarationDescriptor;
    }

    @NotNull
    private String inventAnonymousClassName() {
        String top = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        Integer cnt = this.anonymousSubclassesCount.get(top);
        if (cnt == null) {
            cnt = 0;
        }
        this.anonymousSubclassesCount.put(top, cnt + 1);
        String string = top + "$" + (cnt + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "inventAnonymousClassName"));
        }
        return string;
    }

    @Override
    public void visitKtElement(@NotNull KtElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitKtElement"));
        }
        super.visitKtElement(element2);
        element2.acceptChildren(this);
    }

    @Override
    public void visitScript(@NotNull KtScript script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitScript"));
        }
        this.classStack.push((Object)this.bindingContext.get(BindingContext.SCRIPT, script));
        this.nameStack.push((Object)AsmUtil.internalNameByFqNameWithoutInnerClasses(script.getFqName()));
        script.acceptChildren(this);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitKtFile(@NotNull KtFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitKtFile"));
        }
        this.nameStack.push((Object)AsmUtil.internalNameByFqNameWithoutInnerClasses(file2.getPackageFqName()));
        file2.acceptChildren(this);
        this.nameStack.pop();
    }

    @Override
    public void visitEnumEntry(@NotNull KtEnumEntry enumEntry) {
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitEnumEntry"));
        }
        if (enumEntry.getDeclarations().isEmpty()) {
            for (KtSuperTypeListEntry specifier : enumEntry.getSuperTypeListEntries()) {
                specifier.accept(this);
            }
            return;
        }
        ClassDescriptor descriptor2 = this.bindingContext.get(BindingContext.CLASS, enumEntry);
        if (descriptor2 == null) {
            return;
        }
        this.bindingTrace.record(CodegenBinding.ENUM_ENTRY_CLASS_NEED_SUBCLASS, descriptor2);
        super.visitEnumEntry(enumEntry);
    }

    @Override
    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration2) {
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitObjectDeclaration"));
        }
        if (!this.filter.shouldAnnotateClass(declaration2)) {
            return;
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, declaration2);
        if (classDescriptor == null) {
            return;
        }
        String name2 = this.getName(classDescriptor);
        this.recordClosure(classDescriptor, name2);
        this.classStack.push((Object)classDescriptor);
        this.nameStack.push((Object)name2);
        super.visitObjectDeclaration(declaration2);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitClass(@NotNull KtClass klass2) {
        if (klass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitClass"));
        }
        if (!this.filter.shouldAnnotateClass(klass2)) {
            return;
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, klass2);
        if (classDescriptor == null) {
            return;
        }
        String name2 = this.getName(classDescriptor);
        this.recordClosure(classDescriptor, name2);
        this.classStack.push((Object)classDescriptor);
        this.nameStack.push((Object)name2);
        super.visitClass(klass2);
        this.nameStack.pop();
        this.classStack.pop();
    }

    private String getName(ClassDescriptor classDescriptor) {
        String base = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        Name descriptorName = SpecialNames.safeIdentifier(classDescriptor.getName());
        if (DescriptorUtils.isTopLevelDeclaration(classDescriptor)) {
            return base.isEmpty() ? descriptorName.asString() : base + '/' + descriptorName;
        }
        return (String)this.typeMappingConfiguration.getInnerClassNameFactory().invoke((Object)base, (Object)descriptorName.asString());
    }

    @Override
    public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitObjectLiteralExpression"));
        }
        KtObjectDeclaration object = expression2.getObjectDeclaration();
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, object);
        if (classDescriptor == null) {
            super.visitObjectLiteralExpression(expression2);
            return;
        }
        String name2 = this.inventAnonymousClassName();
        this.recordClosure(classDescriptor, name2);
        KtSuperTypeList delegationSpecifierList = object.getSuperTypeList();
        if (delegationSpecifierList != null) {
            delegationSpecifierList.accept(this);
        }
        this.classStack.push((Object)classDescriptor);
        this.nameStack.push((Object)CodegenBinding.getAsmType(this.bindingContext, classDescriptor).getInternalName());
        KtClassBody body2 = object.getBody();
        if (body2 != null) {
            super.visitClassBody(body2);
        }
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression2) {
        if (lambdaExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitLambdaExpression"));
        }
        KtFunctionLiteral functionLiteral = lambdaExpression2.getFunctionLiteral();
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionLiteral);
        if (functionDescriptor2 == null) {
            return;
        }
        String name2 = this.inventAnonymousClassName();
        Collection<KotlinType> supertypes2 = this.runtimeTypes.getSupertypesForClosure(functionDescriptor2);
        ClassDescriptor classDescriptor = this.recordClassForCallable(functionLiteral, functionDescriptor2, supertypes2, name2);
        MutableClosure closure = this.recordClosure(classDescriptor, name2);
        this.classStack.push((Object)classDescriptor);
        this.nameStack.push((Object)name2);
        if (CoroutineUtilKt.isSuspendLambda(functionDescriptor2)) {
            closure.setSuspend(true);
            closure.setSuspendLambda();
        }
        super.visitLambdaExpression(lambdaExpression2);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2) {
        Collection<KotlinType> supertypes2;
        CallableDescriptor callableDescriptor;
        KotlinType receiverType2;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitCallableReferenceExpression"));
        }
        ResolvedCall<? extends CallableDescriptor> referencedFunction = CallUtilKt.getResolvedCall(expression2.getCallableReference(), this.bindingContext);
        if (referencedFunction == null) {
            return;
        }
        CallableDescriptor target = referencedFunction.getResultingDescriptor();
        KtExpression receiverExpression = expression2.getReceiverExpression();
        KotlinType kotlinType = receiverType2 = receiverExpression != null ? this.bindingContext.getType(receiverExpression) : null;
        if (target instanceof FunctionDescriptor) {
            callableDescriptor = this.bindingContext.get(BindingContext.FUNCTION, expression2);
            if (callableDescriptor == null) {
                return;
            }
            supertypes2 = this.runtimeTypes.getSupertypesForFunctionReference((FunctionDescriptor)target, receiverType2 != null);
        } else if (target instanceof PropertyDescriptor) {
            callableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, expression2);
            if (callableDescriptor == null) {
                return;
            }
            supertypes2 = Collections.singleton(this.runtimeTypes.getSupertypeForPropertyReference((PropertyDescriptor)target, ReflectionTypes.Companion.isNumberedKMutablePropertyType(callableDescriptor.getReturnType()), receiverType2 != null));
        } else {
            return;
        }
        String name2 = this.inventAnonymousClassName();
        ClassDescriptor classDescriptor = this.recordClassForCallable(expression2, callableDescriptor, supertypes2, name2);
        MutableClosure closure = this.recordClosure(classDescriptor, name2);
        if (receiverType2 != null) {
            closure.setCaptureReceiverType(receiverType2);
        }
        super.visitCallableReferenceExpression(expression2);
    }

    @NotNull
    private MutableClosure recordClosure(@NotNull ClassDescriptor classDescriptor, @NotNull String name2) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClosure"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClosure"));
        }
        MutableClosure mutableClosure = CodegenBinding.recordClosure(this.bindingTrace, classDescriptor, CodegenAnnotatingVisitor.peekFromStack(this.classStack), Type.getObjectType((String)name2));
        if (mutableClosure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClosure"));
        }
        return mutableClosure;
    }

    private void recordLocalVariablePropertyMetadata(LocalVariableDescriptor variableDescriptor) {
        KotlinType delegateType = JvmCodegenUtil.getPropertyDelegateType(variableDescriptor, this.bindingContext);
        if (delegateType == null) {
            return;
        }
        LocalVariableDescriptor metadataVariableDescriptor = new LocalVariableDescriptor(variableDescriptor.getContainingDeclaration(), Annotations.Companion.getEMPTY(), Name.identifier(variableDescriptor.getName().asString() + "$metadata"), ReflectionTypes.Companion.createKPropertyStarType(DescriptorUtilsKt.getModule(variableDescriptor)), false, false, SourceElement.NO_SOURCE);
        this.bindingTrace.record(CodegenBinding.LOCAL_VARIABLE_PROPERTY_METADATA, variableDescriptor, metadataVariableDescriptor);
    }

    @Override
    public void visitProperty(@NotNull KtProperty property2) {
        String nameForClassOrPackageMember;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitProperty"));
        }
        DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2);
        if (descriptor2 == null) {
            return;
        }
        if (descriptor2 instanceof LocalVariableDescriptor) {
            this.recordLocalVariablePropertyMetadata((LocalVariableDescriptor)descriptor2);
        }
        if ((nameForClassOrPackageMember = this.getNameForClassOrPackageMember(descriptor2)) != null) {
            this.nameStack.push((Object)nameForClassOrPackageMember);
        } else {
            this.nameStack.push((Object)(CodegenAnnotatingVisitor.peekFromStack(this.nameStack) + '$' + SpecialNames.safeIdentifier(property2.getNameAsSafeName()).asString()));
        }
        KtPropertyDelegate delegate2 = property2.getDelegate();
        if (delegate2 != null && descriptor2 instanceof VariableDescriptorWithAccessors) {
            VariableDescriptorWithAccessors variableDescriptor = (VariableDescriptorWithAccessors)descriptor2;
            String name2 = this.inventAnonymousClassName();
            KotlinType supertype = this.runtimeTypes.getSupertypeForPropertyReference(variableDescriptor, variableDescriptor.isVar(), false);
            ClassDescriptor classDescriptor = this.recordClassForCallable(delegate2, variableDescriptor, Collections.singleton(supertype), name2);
            this.recordClosure(classDescriptor, name2);
            Type containerType = this.getMetadataOwner(property2);
            List<VariableDescriptorWithAccessors> descriptors2 = this.bindingTrace.get(CodegenBinding.DELEGATED_PROPERTIES, containerType);
            if (descriptors2 == null) {
                descriptors2 = new ArrayList<VariableDescriptorWithAccessors>(1);
                this.bindingTrace.record(CodegenBinding.DELEGATED_PROPERTIES, containerType, descriptors2);
            }
            descriptors2.add(variableDescriptor);
            this.bindingTrace.record(CodegenBinding.DELEGATED_PROPERTY_METADATA_OWNER, variableDescriptor, containerType);
        }
        super.visitProperty(property2);
        this.nameStack.pop();
    }

    @NotNull
    private Type getMetadataOwner(@NotNull KtProperty property2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getMetadataOwner"));
        }
        for (int i = this.classStack.size() - 1; i >= 0; --i) {
            ClassDescriptor descriptor2 = (ClassDescriptor)this.classStack.get(i);
            if (descriptor2 instanceof SyntheticClassDescriptorForLambda) continue;
            ClassId classId = DescriptorUtilsKt.getClassId(descriptor2);
            if (classId == null) {
                Type type2 = CodegenBinding.getAsmType(this.bindingContext, descriptor2);
                if (type2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getMetadataOwner"));
                }
                return type2;
            }
            Type type3 = AsmUtil.asmTypeByClassId(DescriptorUtils.isInterface(descriptor2) ? classId.createNestedClassId(Name.identifier("DefaultImpls")) : classId);
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getMetadataOwner"));
            }
            return type3;
        }
        Type type4 = Type.getObjectType((String)FileClasses.getFileClassInternalName(this.fileClassesProvider, property2.getContainingKtFile()));
        if (type4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getMetadataOwner"));
        }
        return type4;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitNamedFunction"));
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2);
        if (functionDescriptor2 == null) {
            return;
        }
        String nameForClassOrPackageMember = this.getNameForClassOrPackageMember(functionDescriptor2);
        if (functionDescriptor2 instanceof SimpleFunctionDescriptor && functionDescriptor2.isSuspend()) {
            SimpleFunctionDescriptor jvmSuspendFunctionView = CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView((SimpleFunctionDescriptor)functionDescriptor2);
            for (Pair parameterDescriptorPair : CollectionsKt.zip(functionDescriptor2.getValueParameters(), jvmSuspendFunctionView.getValueParameters())) {
                this.bindingTrace.record(CodegenBinding.PARAMETER_SYNONYM, parameterDescriptorPair.getFirst(), parameterDescriptorPair.getSecond());
            }
            this.bindingTrace.record(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, functionDescriptor2, jvmSuspendFunctionView);
            if (nameForClassOrPackageMember != null) {
                this.nameStack.push((Object)nameForClassOrPackageMember);
            }
            String name2 = this.inventAnonymousClassName();
            ClassDescriptor classDescriptor = this.recordClassForFunction(function2, functionDescriptor2, name2, functionDescriptor2);
            MutableClosure closure = this.recordClosure(classDescriptor, name2);
            closure.setSuspend(true);
            super.visitNamedFunction(function2);
            if (nameForClassOrPackageMember != null) {
                this.nameStack.pop();
            }
            return;
        }
        if (nameForClassOrPackageMember != null) {
            this.nameStack.push((Object)nameForClassOrPackageMember);
            super.visitNamedFunction(function2);
            this.nameStack.pop();
        } else {
            String name3 = this.inventAnonymousClassName();
            ClassDescriptor classDescriptor = this.recordClassForFunction(function2, functionDescriptor2, name3, null);
            this.recordClosure(classDescriptor, name3);
            this.classStack.push((Object)classDescriptor);
            this.nameStack.push((Object)name3);
            super.visitNamedFunction(function2);
            this.nameStack.pop();
            this.classStack.pop();
        }
    }

    @Nullable
    private String getNameForClassOrPackageMember(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getNameForClassOrPackageMember"));
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        String peek = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        String name2 = SpecialNames.safeIdentifier(descriptor2.getName()).asString();
        if (containingDeclaration instanceof ClassDescriptor) {
            return peek + '$' + name2;
        }
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            KtFile containingFile = DescriptorToSourceUtils.getContainingFile(descriptor2);
            assert (containingFile != null) : "File not found for " + descriptor2;
            return FileClasses.getFileClassInternalName(this.fileClassesProvider, containingFile) + '$' + name2;
        }
        return null;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitCallExpression"));
        }
        super.visitCallExpression(expression2);
        this.checkSamCall(expression2);
    }

    private void checkSamCall(@NotNull KtCallElement expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "checkSamCall"));
        }
        ResolvedCall<? extends CallableDescriptor> call2 = CallUtilKt.getResolvedCall(expression2, this.bindingContext);
        if (call2 == null) {
            return;
        }
        CallableDescriptor descriptor2 = call2.getResultingDescriptor();
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return;
        }
        this.recordSamConstructorIfNeeded(expression2, call2);
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)descriptor2);
        if (original == null) {
            return;
        }
        List<ResolvedValueArgument> valueArguments2 = call2.getValueArgumentsByIndex();
        if (valueArguments2 == null) {
            return;
        }
        for (ValueParameterDescriptor valueParameter : original.getValueParameters()) {
            SamType samType = SamType.create(TypeMapperUtilsKt.removeExternalProjections(valueParameter.getType()));
            if (samType == null) continue;
            ResolvedValueArgument resolvedValueArgument = valueArguments2.get(valueParameter.getIndex());
            assert (resolvedValueArgument instanceof ExpressionValueArgument) : resolvedValueArgument;
            ValueArgument valueArgument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument();
            assert (valueArgument != null);
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            assert (argumentExpression != null) : valueArgument.asElement().getText();
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, argumentExpression, samType);
        }
    }

    @Override
    public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call2) {
        if (call2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitSuperTypeCallEntry"));
        }
        super.visitSuperTypeCallEntry(call2);
        this.checkSamCall(call2);
    }

    private void recordSamConstructorIfNeeded(@NotNull KtCallElement expression2, @NotNull ResolvedCall<?> call2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordSamConstructorIfNeeded"));
        }
        if (call2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordSamConstructorIfNeeded"));
        }
        Object callableDescriptor = call2.getResultingDescriptor();
        if (!(callableDescriptor.getOriginal() instanceof SamConstructorDescriptor)) {
            return;
        }
        List<ResolvedValueArgument> valueArguments2 = call2.getValueArgumentsByIndex();
        if (valueArguments2 == null || valueArguments2.size() != 1) {
            return;
        }
        ResolvedValueArgument valueArgument = valueArguments2.get(0);
        if (!(valueArgument instanceof ExpressionValueArgument)) {
            return;
        }
        ValueArgument argument2 = ((ExpressionValueArgument)valueArgument).getValueArgument();
        if (argument2 == null) {
            return;
        }
        KtExpression argumentExpression = argument2.getArgumentExpression();
        this.bindingTrace.record(CodegenBinding.SAM_CONSTRUCTOR_TO_ARGUMENT, expression2, argumentExpression);
        SamType samType = SamType.create(callableDescriptor.getReturnType());
        this.bindingTrace.record(CodegenBinding.SAM_VALUE, argumentExpression, samType);
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitBinaryExpression"));
        }
        super.visitBinaryExpression(expression2);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getOperationReference());
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor);
        if (original == null) {
            return;
        }
        SamType samType = SamType.create(original.getValueParameters().get(0).getType());
        if (samType == null) {
            return;
        }
        IElementType token = expression2.getOperationToken();
        if (BINARY_OPERATIONS.contains(token)) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression2.getRight(), samType);
        } else if (token == KtTokens.IN_KEYWORD || token == KtTokens.NOT_IN) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression2.getLeft(), samType);
        }
    }

    @Override
    public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitArrayAccessExpression"));
        }
        super.visitArrayAccessExpression(expression2);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        boolean isSetter = operationDescriptor.getName().asString().equals("set");
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor);
        if (original == null) {
            return;
        }
        List<KtExpression> indexExpressions = expression2.getIndexExpressions();
        List<ValueParameterDescriptor> parameters2 = original.getValueParameters();
        for (ValueParameterDescriptor valueParameter : parameters2) {
            SamType samType = SamType.create(valueParameter.getType());
            if (samType == null) continue;
            if (isSetter && valueParameter.getIndex() == parameters2.size() - 1) {
                PsiElement parent2 = expression2.getParent();
                if (!(parent2 instanceof KtBinaryExpression) || ((KtBinaryExpression)parent2).getOperationToken() != KtTokens.EQ) continue;
                KtExpression right = ((KtBinaryExpression)parent2).getRight();
                this.bindingTrace.record(CodegenBinding.SAM_VALUE, right, samType);
                continue;
            }
            KtExpression indexExpression = indexExpressions.get(valueParameter.getIndex());
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, indexExpression, samType);
        }
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitWhenExpression"));
        }
        super.visitWhenExpression(expression2);
        if (!this.isWhenWithEnums(expression2)) {
            return;
        }
        String currentClassName = this.getCurrentTopLevelClassOrPackagePartInternalName(expression2.getContainingKtFile());
        if (this.bindingContext.get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName) == null) {
            this.bindingTrace.record(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName, new ArrayList(1));
        }
        List<WhenByEnumsMapping> mappings = this.bindingContext.get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName);
        assert (mappings != null) : "guaranteed by contract";
        int fieldNumber = mappings.size();
        assert (expression2.getSubjectExpression() != null) : "subject expression should be not null in a valid when by enums";
        KotlinType type2 = WhenChecker.whenSubjectType(expression2, this.bindingContext);
        assert (type2 != null) : "should not be null in a valid when by enums";
        ClassDescriptor classDescriptor = (ClassDescriptor)type2.getConstructor().getDeclarationDescriptor();
        assert (classDescriptor != null) : "because it's enum";
        WhenByEnumsMapping mapping2 = new WhenByEnumsMapping(classDescriptor, currentClassName, fieldNumber);
        for (ConstantValue<?> constant : SwitchCodegenUtil.getAllConstants(expression2, this.bindingContext, this.shouldInlineConstVals)) {
            if (constant instanceof NullValue) continue;
            assert (constant instanceof EnumValue) : "expression in when should be EnumValue";
            mapping2.putFirstTime((EnumValue)constant, mapping2.size() + 1);
        }
        mappings.add(mapping2);
        this.bindingTrace.record(CodegenBinding.MAPPING_FOR_WHEN_BY_ENUM, expression2, mapping2);
    }

    private boolean isWhenWithEnums(@NotNull KtWhenExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "isWhenWithEnums"));
        }
        return WhenChecker.isWhenByEnum(expression2, this.bindingContext) && SwitchCodegenUtil.checkAllItemsAreConstantsSatisfying(expression2, this.bindingContext, this.shouldInlineConstVals, constant -> constant instanceof EnumValue || constant instanceof NullValue);
    }

    @NotNull
    private String getCurrentTopLevelClassOrPackagePartInternalName(@NotNull KtFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getCurrentTopLevelClassOrPackagePartInternalName"));
        }
        ListIterator iterator2 = this.classStack.listIterator(this.classStack.size());
        while (iterator2.hasPrevious()) {
            ClassDescriptor previous = (ClassDescriptor)iterator2.previous();
            if (!DescriptorUtils.isTopLevelOrInnerClass(previous)) continue;
            String string = CodegenBinding.getAsmType(this.bindingContext, previous).getInternalName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getCurrentTopLevelClassOrPackagePartInternalName"));
            }
            return string;
        }
        String string = FileClasses.getFacadeClassInternalName(this.fileClassesProvider, file2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getCurrentTopLevelClassOrPackagePartInternalName"));
        }
        return string;
    }

    private static <T> T peekFromStack(@NotNull Stack<T> stack) {
        if (stack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "peekFromStack"));
        }
        return (T)(stack.empty() ? null : stack.peek());
    }
}

