/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorWithInitializerImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.DescriptorSubstitutor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.SmartSet;

public class PropertyDescriptorImpl
extends VariableDescriptorWithInitializerImpl
implements PropertyDescriptor {
    private final Modality modality;
    private Visibility visibility;
    private Collection<? extends PropertyDescriptor> overriddenProperties;
    private final PropertyDescriptor original;
    private final CallableMemberDescriptor.Kind kind;
    private final boolean lateInit;
    private final boolean isConst;
    private final boolean isHeader;
    private final boolean isImpl;
    private final boolean isExternal;
    private final boolean isDelegated;
    private ReceiverParameterDescriptor dispatchReceiverParameter;
    private ReceiverParameterDescriptor extensionReceiverParameter;
    private List<TypeParameterDescriptor> typeParameters;
    private PropertyGetterDescriptorImpl getter;
    private PropertySetterDescriptor setter;
    private boolean setterProjectedOut;

    protected PropertyDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @Nullable PropertyDescriptor original, @NotNull Annotations annotations2, @NotNull Modality modality, @NotNull Visibility visibility, boolean isVar, @NotNull Name name2, @NotNull CallableMemberDescriptor.Kind kind2, @NotNull SourceElement source, boolean lateInit, boolean isConst, boolean isHeader, boolean isImpl, boolean isExternal, boolean isDelegated) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "<init>"));
        }
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "<init>"));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "<init>"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, annotations2, name2, null, isVar, source);
        this.overriddenProperties = null;
        this.modality = modality;
        this.visibility = visibility;
        this.original = original == null ? this : original;
        this.kind = kind2;
        this.lateInit = lateInit;
        this.isConst = isConst;
        this.isHeader = isHeader;
        this.isImpl = isImpl;
        this.isExternal = isExternal;
        this.isDelegated = isDelegated;
    }

    @NotNull
    public static PropertyDescriptorImpl create(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Modality modality, @NotNull Visibility visibility, boolean isVar, @NotNull Name name2, @NotNull CallableMemberDescriptor.Kind kind2, @NotNull SourceElement source, boolean lateInit, boolean isConst, boolean isHeader, boolean isImpl, boolean isExternal, boolean isDelegated) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        PropertyDescriptorImpl propertyDescriptorImpl = new PropertyDescriptorImpl(containingDeclaration, null, annotations2, modality, visibility, isVar, name2, kind2, source, lateInit, isConst, isHeader, isImpl, isExternal, isDelegated);
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        return propertyDescriptorImpl;
    }

    public void setType(@NotNull KotlinType outType, @ReadOnly @NotNull List<? extends TypeParameterDescriptor> typeParameters, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter, @Nullable KotlinType receiverType2) {
        if (outType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outType", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "setType"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "setType"));
        }
        ReceiverParameterDescriptor extensionReceiverParameter = DescriptorFactory.createExtensionReceiverParameterForCallable(this, receiverType2);
        this.setType(outType, typeParameters, dispatchReceiverParameter, extensionReceiverParameter);
    }

    public void setType(@NotNull KotlinType outType, @ReadOnly @NotNull List<? extends TypeParameterDescriptor> typeParameters, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter, @Nullable ReceiverParameterDescriptor extensionReceiverParameter) {
        if (outType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outType", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "setType"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "setType"));
        }
        this.setOutType(outType);
        this.typeParameters = new ArrayList<TypeParameterDescriptor>(typeParameters);
        this.extensionReceiverParameter = extensionReceiverParameter;
        this.dispatchReceiverParameter = dispatchReceiverParameter;
    }

    public void initialize(@Nullable PropertyGetterDescriptorImpl getter, @Nullable PropertySetterDescriptor setter) {
        this.getter = getter;
        this.setter = setter;
    }

    public void setSetterProjectedOut(boolean setterProjectedOut) {
        this.setterProjectedOut = setterProjectedOut;
    }

    public void setVisibility(@NotNull Visibility visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "setVisibility"));
        }
        this.visibility = visibility;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getTypeParameters() {
        List<TypeParameterDescriptor> list2 = this.typeParameters;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getTypeParameters"));
        }
        return list2;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getExtensionReceiverParameter() {
        return this.extensionReceiverParameter;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getDispatchReceiverParameter() {
        return this.dispatchReceiverParameter;
    }

    @Override
    @NotNull
    public KotlinType getReturnType() {
        KotlinType kotlinType = this.getType();
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getReturnType"));
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    @Nullable
    public PropertyGetterDescriptorImpl getGetter() {
        return this.getter;
    }

    @Override
    @Nullable
    public PropertySetterDescriptor getSetter() {
        return this.setter;
    }

    @Override
    public boolean isSetterProjectedOut() {
        return this.setterProjectedOut;
    }

    @Override
    public boolean isLateInit() {
        return this.lateInit;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    @Override
    public boolean isDelegated() {
        return this.isDelegated;
    }

    @Override
    @NotNull
    public List<PropertyAccessorDescriptor> getAccessors() {
        ArrayList<PropertyAccessorDescriptor> result2 = new ArrayList<PropertyAccessorDescriptor>(2);
        if (this.getter != null) {
            result2.add(this.getter);
        }
        if (this.setter != null) {
            result2.add(this.setter);
        }
        ArrayList<PropertyAccessorDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getAccessors"));
        }
        return arrayList;
    }

    @Override
    public PropertyDescriptor substitute(@NotNull TypeSubstitutor originalSubstitutor) {
        if (originalSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalSubstitutor", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "substitute"));
        }
        if (originalSubstitutor.isEmpty()) {
            return this;
        }
        return this.newCopyBuilder().setSubstitution(originalSubstitutor.getSubstitution()).setOriginal(this.getOriginal()).build();
    }

    @NotNull
    public CopyConfiguration newCopyBuilder() {
        CopyConfiguration copyConfiguration = new CopyConfiguration();
        if (copyConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "newCopyBuilder"));
        }
        return copyConfiguration;
    }

    @Nullable
    protected PropertyDescriptor doSubstitute(@NotNull CopyConfiguration copyConfiguration) {
        PropertySetterDescriptorImpl newSetter;
        PropertyGetterDescriptorImpl newGetter;
        KotlinType substitutedReceiverType;
        ReceiverParameterDescriptor substitutedDispatchReceiver;
        KotlinType originalOutType;
        if (copyConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyConfiguration", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "doSubstitute"));
        }
        PropertyDescriptorImpl substitutedDescriptor = this.createSubstitutedCopy(copyConfiguration.owner, copyConfiguration.modality, copyConfiguration.visibility, copyConfiguration.original, copyConfiguration.kind);
        List originalTypeParameters = copyConfiguration.newTypeParameters == null ? this.getTypeParameters() : copyConfiguration.newTypeParameters;
        ArrayList<TypeParameterDescriptor> substitutedTypeParameters = new ArrayList<TypeParameterDescriptor>(originalTypeParameters.size());
        TypeSubstitutor substitutor3 = DescriptorSubstitutor.substituteTypeParameters(originalTypeParameters, copyConfiguration.substitution, substitutedDescriptor, substitutedTypeParameters);
        KotlinType outType = substitutor3.substitute(originalOutType = this.getType(), Variance.OUT_VARIANCE);
        if (outType == null) {
            return null;
        }
        ReceiverParameterDescriptor dispatchReceiver = copyConfiguration.dispatchReceiverParameter;
        if (dispatchReceiver != null) {
            substitutedDispatchReceiver = dispatchReceiver.substitute(substitutor3);
            if (substitutedDispatchReceiver == null) {
                return null;
            }
        } else {
            substitutedDispatchReceiver = null;
        }
        if (this.extensionReceiverParameter != null) {
            substitutedReceiverType = substitutor3.substitute(this.extensionReceiverParameter.getType(), Variance.IN_VARIANCE);
            if (substitutedReceiverType == null) {
                return null;
            }
        } else {
            substitutedReceiverType = null;
        }
        substitutedDescriptor.setType(outType, substitutedTypeParameters, substitutedDispatchReceiver, substitutedReceiverType);
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl = this.getter == null ? null : (newGetter = new PropertyGetterDescriptorImpl(substitutedDescriptor, this.getter.getAnnotations(), copyConfiguration.modality, PropertyDescriptorImpl.normalizeVisibility(this.getter.getVisibility(), copyConfiguration.kind), this.getter.isDefault(), this.getter.isExternal(), this.getter.isInline(), copyConfiguration.kind, copyConfiguration.original == null ? null : copyConfiguration.original.getGetter(), SourceElement.NO_SOURCE));
        if (newGetter != null) {
            KotlinType returnType2 = this.getter.getReturnType();
            newGetter.setInitialSignatureDescriptor(PropertyDescriptorImpl.getSubstitutedInitialSignatureDescriptor(substitutor3, this.getter));
            newGetter.initialize(returnType2 != null ? substitutor3.substitute(returnType2, Variance.OUT_VARIANCE) : null);
        }
        PropertySetterDescriptorImpl propertySetterDescriptorImpl = this.setter == null ? null : (newSetter = new PropertySetterDescriptorImpl(substitutedDescriptor, this.setter.getAnnotations(), copyConfiguration.modality, PropertyDescriptorImpl.normalizeVisibility(this.setter.getVisibility(), copyConfiguration.kind), this.setter.isDefault(), this.setter.isExternal(), this.setter.isInline(), copyConfiguration.kind, copyConfiguration.original == null ? null : copyConfiguration.original.getSetter(), SourceElement.NO_SOURCE));
        if (newSetter != null) {
            List<ValueParameterDescriptor> substitutedValueParameters = FunctionDescriptorImpl.getSubstitutedValueParameters(newSetter, this.setter.getValueParameters(), substitutor3, false, false, null);
            if (substitutedValueParameters == null) {
                substitutedDescriptor.setSetterProjectedOut(true);
                substitutedValueParameters = Collections.singletonList(PropertySetterDescriptorImpl.createSetterParameter(newSetter, DescriptorUtilsKt.getBuiltIns(copyConfiguration.owner).getNothingType()));
            }
            if (substitutedValueParameters.size() != 1) {
                throw new IllegalStateException();
            }
            newSetter.setInitialSignatureDescriptor(PropertyDescriptorImpl.getSubstitutedInitialSignatureDescriptor(substitutor3, this.setter));
            newSetter.initialize(substitutedValueParameters.get(0));
        }
        substitutedDescriptor.initialize(newGetter, newSetter);
        if (copyConfiguration.copyOverrides) {
            SmartSet overridden = SmartSet.create();
            for (PropertyDescriptor propertyDescriptor : this.getOverriddenDescriptors()) {
                overridden.add(propertyDescriptor.substitute(substitutor3));
            }
            substitutedDescriptor.setOverriddenDescriptors(overridden);
        }
        if (this.isConst() && this.compileTimeInitializer != null) {
            substitutedDescriptor.setCompileTimeInitializer(this.compileTimeInitializer);
        }
        return substitutedDescriptor;
    }

    private static Visibility normalizeVisibility(Visibility prev2, CallableMemberDescriptor.Kind kind2) {
        if (kind2 == CallableMemberDescriptor.Kind.FAKE_OVERRIDE && Visibilities.isPrivate(prev2.normalize())) {
            return Visibilities.INVISIBLE_FAKE;
        }
        return prev2;
    }

    private static FunctionDescriptor getSubstitutedInitialSignatureDescriptor(@NotNull TypeSubstitutor substitutor3, @NotNull PropertyAccessorDescriptor accessorDescriptor) {
        if (substitutor3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getSubstitutedInitialSignatureDescriptor"));
        }
        if (accessorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessorDescriptor", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getSubstitutedInitialSignatureDescriptor"));
        }
        return accessorDescriptor.getInitialSignatureDescriptor() != null ? accessorDescriptor.getInitialSignatureDescriptor().substitute(substitutor3) : null;
    }

    @NotNull
    protected PropertyDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @NotNull Modality newModality, @NotNull Visibility newVisibility, @Nullable PropertyDescriptor original, @NotNull CallableMemberDescriptor.Kind kind2) {
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "createSubstitutedCopy"));
        }
        if (newModality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newModality", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "createSubstitutedCopy"));
        }
        if (newVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newVisibility", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "createSubstitutedCopy"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "createSubstitutedCopy"));
        }
        PropertyDescriptorImpl propertyDescriptorImpl = new PropertyDescriptorImpl(newOwner, original, this.getAnnotations(), newModality, newVisibility, this.isVar(), this.getName(), kind2, SourceElement.NO_SOURCE, this.isLateInit(), this.isConst(), this.isHeader(), this.isImpl(), this.isExternal(), this.isDelegated());
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "createSubstitutedCopy"));
        }
        return propertyDescriptorImpl;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data) {
        return visitor2.visitPropertyDescriptor(this, data);
    }

    @Override
    @NotNull
    public PropertyDescriptor getOriginal() {
        PropertyDescriptor propertyDescriptor = this.original == this ? this : this.original.getOriginal();
        if (propertyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getOriginal"));
        }
        return propertyDescriptor;
    }

    @Override
    @NotNull
    public CallableMemberDescriptor.Kind getKind() {
        CallableMemberDescriptor.Kind kind2 = this.kind;
        if (kind2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getKind"));
        }
        return kind2;
    }

    @Override
    public boolean isHeader() {
        return this.isHeader;
    }

    @Override
    public boolean isImpl() {
        return this.isImpl;
    }

    @Override
    public void setOverriddenDescriptors(@NotNull Collection<? extends CallableMemberDescriptor> overriddenDescriptors) {
        if (overriddenDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenDescriptors", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "setOverriddenDescriptors"));
        }
        this.overriddenProperties = overriddenDescriptors;
    }

    @Override
    @NotNull
    public Collection<? extends PropertyDescriptor> getOverriddenDescriptors() {
        Collection<Object> collection = this.overriddenProperties != null ? this.overriddenProperties : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getOverriddenDescriptors"));
        }
        return collection;
    }

    @Override
    @NotNull
    public PropertyDescriptor copy(DeclarationDescriptor newOwner, Modality modality, Visibility visibility, CallableMemberDescriptor.Kind kind2, boolean copyOverrides) {
        PropertyDescriptor propertyDescriptor = this.newCopyBuilder().setOwner(newOwner).setOriginal(null).setModality(modality).setVisibility(visibility).setKind(kind2).setCopyOverrides(copyOverrides).build();
        if (propertyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "copy"));
        }
        return propertyDescriptor;
    }

    public class CopyConfiguration
    implements CallableMemberDescriptor.CopyBuilder<PropertyDescriptor> {
        private DeclarationDescriptor owner;
        private Modality modality;
        private Visibility visibility;
        private PropertyDescriptor original;
        private CallableMemberDescriptor.Kind kind;
        private TypeSubstitution substitution;
        private boolean copyOverrides;
        private ReceiverParameterDescriptor dispatchReceiverParameter;
        private List<TypeParameterDescriptor> newTypeParameters;

        public CopyConfiguration() {
            this.owner = PropertyDescriptorImpl.this.getContainingDeclaration();
            this.modality = PropertyDescriptorImpl.this.getModality();
            this.visibility = PropertyDescriptorImpl.this.getVisibility();
            this.original = null;
            this.kind = PropertyDescriptorImpl.this.getKind();
            this.substitution = TypeSubstitution.EMPTY;
            this.copyOverrides = true;
            this.dispatchReceiverParameter = PropertyDescriptorImpl.this.dispatchReceiverParameter;
            this.newTypeParameters = null;
        }

        @NotNull
        public CopyConfiguration setOwner(@NotNull DeclarationDescriptor owner) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl$CopyConfiguration", "setOwner"));
            }
            this.owner = owner;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl$CopyConfiguration", "setOwner"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setOriginal(@Nullable PropertyDescriptor original) {
            this.original = original;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl$CopyConfiguration", "setOriginal"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setModality(@NotNull Modality modality) {
            if (modality == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl$CopyConfiguration", "setModality"));
            }
            this.modality = modality;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl$CopyConfiguration", "setModality"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setVisibility(@NotNull Visibility visibility) {
            if (visibility == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl$CopyConfiguration", "setVisibility"));
            }
            this.visibility = visibility;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl$CopyConfiguration", "setVisibility"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setKind(@NotNull CallableMemberDescriptor.Kind kind2) {
            if (kind2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl$CopyConfiguration", "setKind"));
            }
            this.kind = kind2;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl$CopyConfiguration", "setKind"));
            }
            return copyConfiguration;
        }

        @Override
        @NotNull
        public CallableMemberDescriptor.CopyBuilder<PropertyDescriptor> setTypeParameters(@NotNull List<TypeParameterDescriptor> typeParameters) {
            if (typeParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl$CopyConfiguration", "setTypeParameters"));
            }
            this.newTypeParameters = typeParameters;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl$CopyConfiguration", "setTypeParameters"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setDispatchReceiverParameter(@Nullable ReceiverParameterDescriptor dispatchReceiverParameter) {
            this.dispatchReceiverParameter = dispatchReceiverParameter;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl$CopyConfiguration", "setDispatchReceiverParameter"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setSubstitution(@NotNull TypeSubstitution substitution2) {
            if (substitution2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl$CopyConfiguration", "setSubstitution"));
            }
            this.substitution = substitution2;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl$CopyConfiguration", "setSubstitution"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setCopyOverrides(boolean copyOverrides) {
            this.copyOverrides = copyOverrides;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl$CopyConfiguration", "setCopyOverrides"));
            }
            return copyConfiguration;
        }

        @Override
        @Nullable
        public PropertyDescriptor build() {
            return PropertyDescriptorImpl.this.doSubstitute(this);
        }
    }
}

