/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.SmartTypeRenderer;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.types.KotlinType;

public class TabledDescriptorRenderer {
    protected final List<TableOrTextRenderer> renderers = Lists.newArrayList();

    public TabledDescriptorRenderer text(@NotNull TextRenderer textRenderer) {
        if (textRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRenderer", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer", "text"));
        }
        this.renderers.add(textRenderer);
        return this;
    }

    public TabledDescriptorRenderer table(@NotNull TableRenderer tableRenderer) {
        if (tableRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableRenderer", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer", "table"));
        }
        this.renderers.add(tableRenderer);
        return this;
    }

    public static TextRenderer newText() {
        return new TextRenderer();
    }

    public static TableRenderer newTable() {
        return new TableRenderer();
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        for (TableOrTextRenderer tableOrTextRenderer : this.renderers) {
            if (tableOrTextRenderer instanceof TableRenderer) {
                this.renderTable((TableRenderer)tableOrTextRenderer, result2);
                continue;
            }
            this.renderText((TextRenderer)tableOrTextRenderer, result2);
        }
        return result2.toString();
    }

    @NotNull
    public DiagnosticParameterRenderer<KotlinType> getTypeRenderer() {
        SmartTypeRenderer smartTypeRenderer = Renderers.RENDER_TYPE;
        if (smartTypeRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer", "getTypeRenderer"));
        }
        return smartTypeRenderer;
    }

    protected void renderText(TextRenderer textRenderer, StringBuilder result2) {
        for (TextRenderer.TextElement element2 : textRenderer.elements) {
            result2.append(element2.text);
        }
    }

    protected void renderTable(TableRenderer table, StringBuilder result2) {
        if (table.rows.isEmpty()) {
            return;
        }
        RenderingContext context = TabledDescriptorRenderer.computeRenderingContext(table);
        for (TableRenderer.TableRow row : table.rows) {
            if (row instanceof TextRenderer) {
                this.renderText((TextRenderer)row, result2);
            }
            if (row instanceof TableRenderer.DescriptorRow) {
                result2.append(Renderers.COMPACT.render(((TableRenderer.DescriptorRow)row).descriptor, context));
            }
            if (row instanceof TableRenderer.FunctionArgumentsRow) {
                TableRenderer.FunctionArgumentsRow functionArgumentsRow = (TableRenderer.FunctionArgumentsRow)row;
                this.renderFunctionArguments(functionArgumentsRow.receiverType, functionArgumentsRow.argumentTypes, result2, context);
            }
            result2.append("\n");
        }
    }

    private void renderFunctionArguments(@Nullable KotlinType receiverType2, @NotNull List<KotlinType> argumentTypes2, StringBuilder result2, @NotNull RenderingContext context) {
        boolean hasReceiver;
        if (argumentTypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer", "renderFunctionArguments"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer", "renderFunctionArguments"));
        }
        boolean bl = hasReceiver = receiverType2 != null;
        if (hasReceiver) {
            result2.append("receiver: ");
            result2.append(this.getTypeRenderer().render(receiverType2, context));
            result2.append("  arguments: ");
        }
        if (argumentTypes2.isEmpty()) {
            result2.append("()");
            return;
        }
        result2.append("(");
        Iterator<KotlinType> iterator2 = argumentTypes2.iterator();
        while (iterator2.hasNext()) {
            KotlinType argumentType = iterator2.next();
            if (argumentType == null) {
                result2.append("<unknown>");
            } else {
                String renderedArgument = this.getTypeRenderer().render(argumentType, context);
                result2.append(renderedArgument);
            }
            if (!iterator2.hasNext()) continue;
            result2.append(",");
        }
        result2.append(")");
    }

    public static TabledDescriptorRenderer create() {
        return new TabledDescriptorRenderer();
    }

    @NotNull
    protected static RenderingContext computeRenderingContext(@NotNull TableRenderer table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer", "computeRenderingContext"));
        }
        ArrayList<Annotated> toRender = new ArrayList<Annotated>();
        for (TableRenderer.TableRow row : table.rows) {
            if (row instanceof TableRenderer.DescriptorRow) {
                toRender.add(((TableRenderer.DescriptorRow)row).descriptor);
                continue;
            }
            if (row instanceof TableRenderer.FunctionArgumentsRow) {
                toRender.add(((TableRenderer.FunctionArgumentsRow)row).receiverType);
                toRender.addAll(((TableRenderer.FunctionArgumentsRow)row).argumentTypes);
                continue;
            }
            if (!(row instanceof TextRenderer)) {
                throw new AssertionError((Object)("Unknown row of type " + row.getClass()));
            }
        }
        RenderingContext.Impl impl = new RenderingContext.Impl(toRender);
        if (impl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer", "computeRenderingContext"));
        }
        return impl;
    }

    public static enum TextElementType {
        STRONG,
        ERROR,
        DEFAULT;

    }

    public static class TextRenderer
    implements TableOrTextRenderer,
    TableRenderer.TableRow {
        public final List<TextElement> elements = Lists.newArrayList();

        public TextRenderer normal(@NotNull Object text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TextRenderer", "normal"));
            }
            this.elements.add(new TextElement(TextElementType.DEFAULT, text2.toString()));
            return this;
        }

        public TextRenderer error(@NotNull Object text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TextRenderer", "error"));
            }
            this.elements.add(new TextElement(TextElementType.ERROR, text2.toString()));
            return this;
        }

        public TextRenderer strong(@NotNull Object text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TextRenderer", "strong"));
            }
            this.elements.add(new TextElement(TextElementType.STRONG, text2.toString()));
            return this;
        }

        public static class TextElement {
            public TextElementType type;
            public String text;

            public TextElement(@NotNull TextElementType type2, @NotNull String text2) {
                if (type2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TextRenderer$TextElement", "<init>"));
                }
                if (text2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TextRenderer$TextElement", "<init>"));
                }
                this.type = type2;
                this.text = text2;
            }
        }
    }

    public static class TableRenderer
    implements TableOrTextRenderer {
        public final List<TableRow> rows = Lists.newArrayList();

        public TableRenderer descriptor(CallableDescriptor descriptor2) {
            this.rows.add(new DescriptorRow(descriptor2));
            return this;
        }

        public TableRenderer functionArgumentTypeList(@Nullable KotlinType receiverType2, @NotNull List<KotlinType> argumentTypes2) {
            if (argumentTypes2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TableRenderer", "functionArgumentTypeList"));
            }
            return this.functionArgumentTypeList(receiverType2, argumentTypes2, position2 -> false);
        }

        public TableRenderer functionArgumentTypeList(@Nullable KotlinType receiverType2, @NotNull List<KotlinType> argumentTypes2, @NotNull Predicate<ConstraintPosition> isErrorPosition) {
            if (argumentTypes2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TableRenderer", "functionArgumentTypeList"));
            }
            if (isErrorPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isErrorPosition", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TableRenderer", "functionArgumentTypeList"));
            }
            this.rows.add(new FunctionArgumentsRow(receiverType2, argumentTypes2, isErrorPosition));
            return this;
        }

        public TableRenderer text(@NotNull String text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TableRenderer", "text"));
            }
            this.rows.add(TabledDescriptorRenderer.newText().normal(text2));
            return this;
        }

        public TableRenderer text(@NotNull TextRenderer textRenderer) {
            if (textRenderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRenderer", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TableRenderer", "text"));
            }
            this.rows.add(textRenderer);
            return this;
        }

        public static class FunctionArgumentsRow
        implements TableRow {
            public final KotlinType receiverType;
            public final List<KotlinType> argumentTypes;
            public final Predicate<ConstraintPosition> isErrorPosition;

            public FunctionArgumentsRow(KotlinType receiverType2, List<KotlinType> argumentTypes2, Predicate<ConstraintPosition> isErrorPosition) {
                this.receiverType = receiverType2;
                this.argumentTypes = argumentTypes2;
                this.isErrorPosition = isErrorPosition;
            }
        }

        public static class DescriptorRow
        implements TableRow {
            public final CallableDescriptor descriptor;

            public DescriptorRow(CallableDescriptor descriptor2) {
                this.descriptor = descriptor2;
            }
        }

        public static interface TableRow {
        }
    }

    public static interface TableOrTextRenderer {
    }
}

