/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleProductionSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleTestSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.SdkInfo;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a%\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u0012*\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015\u001a\f\u0010\u0016\u001a\u00020\u000b*\u00020\u0007H\u0000\u001a\f\u0010\u0017\u001a\u00020\u000b*\u00020\u0018H\u0000\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\t\u001a\n\u0010\u001b\u001a\u00020\u001c*\u00020\t\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001d"}, d2={"OriginCapability", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor$Capability;", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleOrigin;", "getOriginCapability", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor$Capability;", "ideaModelDependencies", "", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaModuleInfo;", "module", "Lcom/intellij/openapi/module/Module;", "productionOnly", "", "orderEntryToModuleInfo", "project", "Lcom/intellij/openapi/project/Project;", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "cached", "T", "provider", "Lcom/intellij/psi/util/CachedValueProvider;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/util/CachedValueProvider;)Ljava/lang/Object;", "isLibraryClasses", "isTests", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleSourceInfo;", "productionSourceInfo", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleProductionSourceInfo;", "testSourceInfo", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleTestSourceInfo;", "idea-analysis"})
public final class IdeaModuleInfosKt {
    @NotNull
    private static final ModuleDescriptor.Capability<ModuleOrigin> OriginCapability = new ModuleDescriptor.Capability("MODULE_ORIGIN");

    private static final List<IdeaModuleInfo> orderEntryToModuleInfo(Project project, OrderEntry orderEntry, boolean productionOnly) {
        List list2;
        Function1<Module, List<? extends ModuleSourceInfo>> toInfos$ = new Function1<Module, List<? extends ModuleSourceInfo>>(productionOnly){
            final /* synthetic */ boolean $productionOnly;

            @NotNull
            public final List<ModuleSourceInfo> invoke(@NotNull Module $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                return this.$productionOnly ? CollectionsKt.listOf((Object)IdeaModuleInfosKt.productionSourceInfo($receiver)) : CollectionsKt.listOf((Object[])new ModuleSourceInfo[]{IdeaModuleInfosKt.testSourceInfo($receiver), IdeaModuleInfosKt.productionSourceInfo($receiver)});
            }
            {
                this.$productionOnly = bl;
                super(1);
            }
        };
        if (!orderEntry.isValid()) {
            return CollectionsKt.emptyList();
        }
        OrderEntry orderEntry2 = orderEntry;
        if (orderEntry2 instanceof ModuleSourceOrderEntry) {
            list2 = toInfos$.invoke(orderEntry.getOwnerModule());
        } else if (orderEntry2 instanceof ModuleOrderEntry) {
            Module module = ((ModuleOrderEntry)orderEntry).getModule();
            List list3 = module != null ? toInfos$.invoke(module) : null;
            list2 = list3;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
        } else if (orderEntry2 instanceof LibraryOrderEntry) {
            Library library2;
            Library library3 = ((LibraryOrderEntry)orderEntry).getLibrary();
            if (library3 == null) {
                return CollectionsKt.emptyList();
            }
            Library library4 = library2 = library3;
            Intrinsics.checkExpressionValueIsNotNull((Object)library4, (String)"library");
            list2 = CollectionsKt.listOfNotNull((Object)new LibraryInfo(project, library4));
        } else if (orderEntry2 instanceof JdkOrderEntry) {
            Sdk sdk = ((JdkOrderEntry)orderEntry).getJdk();
            if (sdk == null) {
                return CollectionsKt.emptyList();
            }
            Sdk sdk2 = sdk;
            list2 = CollectionsKt.listOfNotNull((Object)new SdkInfo(project, sdk2));
        } else {
            throw (Throwable)new IllegalStateException("Unexpected order entry " + orderEntry);
        }
        return list2;
    }

    private static final <T> T cached(@NotNull Module $receiver, CachedValueProvider<T> provider2) {
        return (T)CachedValuesManager.getManager((Project)$receiver.getProject()).getCachedValue((UserDataHolder)$receiver, provider2);
    }

    private static final List<IdeaModuleInfo> ideaModelDependencies(Module module, boolean productionOnly) {
        LinkedHashSet result2 = new LinkedHashSet();
        OrderEnumerator dependencyEnumerator = ModuleRootManager.getInstance((Module)module).orderEntries().compileOnly().recursively().exportedOnly();
        if (productionOnly) {
            dependencyEnumerator.productionOnly();
        }
        dependencyEnumerator.forEach((Processor)new Processor<OrderEntry>(result2, module, productionOnly){
            final /* synthetic */ LinkedHashSet $result;
            final /* synthetic */ Module $module;
            final /* synthetic */ boolean $productionOnly;

            public final boolean process(OrderEntry orderEntry) {
                Project project = this.$module.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                OrderEntry orderEntry2 = orderEntry;
                if (orderEntry2 == null) {
                    Intrinsics.throwNpe();
                }
                this.$result.addAll(IdeaModuleInfosKt.access$orderEntryToModuleInfo(project, orderEntry2, this.$productionOnly));
                return true;
            }
            {
                this.$result = linkedHashSet;
                this.$module = module;
                this.$productionOnly = bl;
            }
        });
        return CollectionsKt.toList((Iterable)result2);
    }

    public static final boolean isTests(@NotNull ModuleSourceInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof ModuleTestSourceInfo;
    }

    @NotNull
    public static final ModuleProductionSourceInfo productionSourceInfo(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new ModuleProductionSourceInfo($receiver);
    }

    @NotNull
    public static final ModuleTestSourceInfo testSourceInfo(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new ModuleTestSourceInfo($receiver);
    }

    public static final boolean isLibraryClasses(@NotNull IdeaModuleInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof SdkInfo || $receiver instanceof LibraryInfo;
    }

    @NotNull
    public static final ModuleDescriptor.Capability<ModuleOrigin> getOriginCapability() {
        return OriginCapability;
    }

    public static final /* synthetic */ Object access$cached(@NotNull Module $receiver, @NotNull CachedValueProvider provider2) {
        return IdeaModuleInfosKt.cached($receiver, provider2);
    }

    @NotNull
    public static final /* synthetic */ List access$ideaModelDependencies(@NotNull Module module, boolean productionOnly) {
        return IdeaModuleInfosKt.ideaModelDependencies(module, productionOnly);
    }

    @NotNull
    public static final /* synthetic */ List access$orderEntryToModuleInfo(@NotNull Project project, @NotNull OrderEntry orderEntry, boolean productionOnly) {
        return IdeaModuleInfosKt.orderEntryToModuleInfo(project, orderEntry, productionOnly);
    }
}

