/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Queue;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleIndex;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleTestSourceInfo;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001*\u00020\t\u00a8\u0006\n"}, d2={"getDependents", "", "Lcom/intellij/openapi/module/Module;", "module", "getModuleIndex", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleIndex;", "project", "Lcom/intellij/openapi/project/Project;", "getDependentModules", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleSourceInfo;", "idea-analysis"})
public final class ModuleDependentsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<ModuleSourceInfo> getDependentModules(@NotNull ModuleSourceInfo $receiver) {
        void var3_5;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Set<Module> dependents2 = ModuleDependentsKt.getDependents($receiver.getModule());
        if (IdeaModuleInfosKt.isTests($receiver)) {
            void $receiver$iv;
            Iterable iterable = dependents2;
            Collection destination$iv = new HashSet();
            for (Object item$iv : $receiver$iv) {
                void p1;
                Module module = (Module)item$iv;
                Collection collection = destination$iv;
                ModuleTestSourceInfo moduleTestSourceInfo = IdeaModuleInfosKt.testSourceInfo((Module)p1);
                collection.add(moduleTestSourceInfo);
            }
            return (Set)destination$iv;
        }
        Iterable $receiver$iv = dependents2;
        Collection destination$iv = new HashSet();
        for (Object element$iv : $receiver$iv) {
            Module it = (Module)element$iv;
            Iterable list$iv = CollectionsKt.listOf((Object[])new ModuleSourceInfo[]{IdeaModuleInfosKt.productionSourceInfo(it), IdeaModuleInfosKt.testSourceInfo(it)});
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var3_5;
    }

    private static final Set<Module> getDependents(Module module) {
        THashSet result2 = new THashSet();
        result2.add((Object)module);
        THashSet processedExporting = new THashSet();
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        ModuleIndex index2 = ModuleDependentsKt.getModuleIndex(project);
        Queue walkingQueue = new Queue(10);
        walkingQueue.addLast((Object)module);
        while (!walkingQueue.isEmpty()) {
            Module current;
            Module module2 = current = (Module)walkingQueue.pullFirst();
            if (module2 == null) {
                Intrinsics.throwNpe();
            }
            processedExporting.add((Object)module2);
            result2.addAll(index2.getPlainUsages().get((Object)current));
            for (Module dependent : index2.getExportingUsages().get((Object)current)) {
                result2.add((Object)dependent);
                if (!processedExporting.add((Object)dependent)) continue;
                walkingQueue.addLast((Object)dependent);
            }
        }
        return (Set)result2;
    }

    private static final ModuleIndex getModuleIndex(Project project) {
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, (CachedValueProvider)new CachedValueProvider<ModuleIndex>(project){
            final /* synthetic */ Project $project;

            @NotNull
            public final CachedValueProvider.Result<ModuleIndex> compute() {
                ModuleIndex index2 = new ModuleIndex();
                Module[] moduleArray = ModuleManager.getInstance((Project)this.$project).getModules();
                for (int i = 0; i < moduleArray.length; ++i) {
                    Module module = moduleArray[i];
                    OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module).getOrderEntries();
                    for (int j = 0; j < orderEntryArray.length; ++j) {
                        Module referenced;
                        OrderEntry orderEntry = orderEntryArray[j];
                        if (!(orderEntry instanceof ModuleOrderEntry) || (referenced = ((ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                        MultiMap<Module, Module> map2 = ((ModuleOrderEntry)orderEntry).isExported() ? index2.getExportingUsages() : index2.getPlainUsages();
                        map2.putValue((Object)referenced, (Object)module);
                    }
                }
                return new CachedValueProvider.Result((Object)index2, new Object[]{ProjectRootModificationTracker.getInstance((Project)this.$project)});
            }
            {
                this.$project = project;
            }
        });
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (ModuleIndex)object;
    }
}

