/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.configuration.GradleKotlinFrameworkSupportProvider;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/GradleKotlinJavaFrameworkSupportProvider;", "Lorg/jetbrains/kotlin/idea/configuration/GradleKotlinFrameworkSupportProvider;", "()V", "addSupport", "", "module", "Lcom/intellij/openapi/module/Module;", "rootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "modifiableModelsProvider", "Lcom/intellij/openapi/roots/ModifiableModelsProvider;", "buildScriptData", "Lorg/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder;", "getPluginDefinition", "", "getRuntimeLibrary", "idea"})
public final class GradleKotlinJavaFrameworkSupportProvider
extends GradleKotlinFrameworkSupportProvider {
    @Override
    @NotNull
    protected String getPluginDefinition() {
        return KotlinWithGradleConfigurator.Companion.getGroovyApplyPluginDirective(KotlinGradleModuleConfigurator.Companion.getKOTLIN());
    }

    @Override
    @NotNull
    protected String getRuntimeLibrary(@NotNull ModifiableRootModel rootModel) {
        Intrinsics.checkParameterIsNotNull((Object)rootModel, (String)"rootModel");
        return KotlinWithGradleConfigurator.Companion.getGroovyDependencySnippet(KotlinRuntimeLibraryUtilKt.getStdlibArtifactId(rootModel.getSdk(), KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion()));
    }

    @Override
    public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider, @NotNull BuildScriptDataBuilder buildScriptData) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)rootModel, (String)"rootModel");
        Intrinsics.checkParameterIsNotNull((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        Intrinsics.checkParameterIsNotNull((Object)buildScriptData, (String)"buildScriptData");
        super.addSupport(module, rootModel, modifiableModelsProvider, buildScriptData);
        JvmTarget jvmTarget = KotlinRuntimeLibraryUtilKt.getDefaultJvmTarget(rootModel.getSdk(), KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion());
        if (jvmTarget != null) {
            buildScriptData.addOther("compileKotlin {\n    kotlinOptions.jvmTarget = \"1.8\"\n}\n\n");
            buildScriptData.addOther("compileTestKotlin {\n    kotlinOptions.jvmTarget = \"1.8\"\n}\n");
        }
    }

    public GradleKotlinJavaFrameworkSupportProvider() {
        Icon icon = KotlinIcons.SMALL_LOGO;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"KotlinIcons.SMALL_LOGO");
        super("KOTLIN", "Kotlin (Java)", icon);
    }
}

