/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinSourcePositionProvider;", "Lcom/intellij/debugger/engine/SourcePositionProvider;", "()V", "computeSourcePosition", "Lcom/intellij/debugger/SourcePosition;", "descriptor", "Lcom/intellij/debugger/ui/tree/FieldDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "nearest", "", "Lcom/intellij/debugger/ui/tree/LocalVariableDescriptor;", "Lcom/intellij/debugger/ui/tree/NodeDescriptor;", "findClassByType", "Lcom/intellij/psi/PsiElement;", "type", "Lcom/sun/jdi/ReferenceType;", "getLastSourcePosition", "idea"})
public final class KotlinSourcePositionProvider
extends SourcePositionProvider {
    @Nullable
    protected SourcePosition computeSourcePosition(@NotNull NodeDescriptor descriptor2, @NotNull Project project, @NotNull DebuggerContextImpl context, boolean nearest) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (context.getFrameProxy() == null) {
            return null;
        }
        if (descriptor2 instanceof FieldDescriptor) {
            return this.computeSourcePosition((FieldDescriptor)descriptor2, project, context, nearest);
        }
        if (descriptor2 instanceof LocalVariableDescriptor) {
            return this.computeSourcePosition((LocalVariableDescriptor)descriptor2, project, context, nearest);
        }
        return null;
    }

    private final SourcePosition computeSourcePosition(LocalVariableDescriptor descriptor2, Project project, DebuggerContextImpl context, boolean nearest) {
        PsiElement psiElement2 = PositionUtil.getContextElement((StackFrameContext)((StackFrameContext)context));
        if (psiElement2 == null) {
            return null;
        }
        PsiElement place = psiElement2;
        if (!(place.getContainingFile() instanceof KtFile)) {
            return null;
        }
        PsiElement psiElement3 = KotlinCodeFragmentFactory.Companion.getContextElement(place);
        if (psiElement3 == null) {
            return null;
        }
        PsiElement contextElement = psiElement3;
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        String string = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.name");
        KtExpressionCodeFragment codeFragment = ktPsiFactory.createExpressionCodeFragment(string, contextElement);
        KtExpression expression2 = codeFragment.getContentElement();
        if (expression2 instanceof KtSimpleNameExpression) {
            SourceElement sourceElement;
            VariableDescriptor declarationDescriptor;
            BindingContext bindingContext2 = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
            VariableDescriptor variableDescriptor = declarationDescriptor = BindingContextUtils.extractVariableDescriptorFromReference(bindingContext2, expression2);
            SourceElement sourceElement2 = sourceElement = variableDescriptor != null ? variableDescriptor.getSource() : null;
            if (sourceElement instanceof KotlinSourceElement) {
                PsiElement psiElement4 = KotlinSourceElementKt.getPsi(sourceElement);
                if (psiElement4 == null) {
                    return null;
                }
                PsiElement element2 = psiElement4;
                if (nearest) {
                    return DebuggerContextUtil.findNearest((DebuggerContextImpl)context, (PsiElement)element2, (PsiFile)element2.getContainingFile());
                }
                return SourcePosition.createFromOffset((PsiFile)element2.getContainingFile(), (int)element2.getTextOffset());
            }
        }
        return null;
    }

    private final SourcePosition computeSourcePosition(FieldDescriptor descriptor2, Project project, DebuggerContextImpl context, boolean nearest) {
        Object v4;
        KtClassOrObject myClass;
        block6: {
            ReferenceType type2;
            String fieldName = descriptor2.getField().name();
            if (Intrinsics.areEqual((Object)fieldName, (Object)"this$0") || Intrinsics.areEqual((Object)fieldName, (Object)"receiver$0")) {
                return null;
            }
            ReferenceType referenceType = type2 = descriptor2.getField().declaringType();
            Intrinsics.checkExpressionValueIsNotNull((Object)referenceType, (String)"type");
            PsiElement psiElement2 = this.findClassByType(project, referenceType, context);
            Object object = psiElement2 != null ? psiElement2.getNavigationElement() : null;
            if (!(object instanceof KtClassOrObject)) {
                object = null;
            }
            KtClassOrObject ktClassOrObject = (KtClassOrObject)object;
            if (ktClassOrObject == null) {
                return null;
            }
            myClass = ktClassOrObject;
            Iterable $receiver$iv = myClass.getDeclarations();
            for (Object element$iv : $receiver$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                if (!Intrinsics.areEqual((Object)fieldName, (Object)it.getName())) continue;
                v4 = element$iv;
                break block6;
            }
            v4 = null;
        }
        KtDeclaration ktDeclaration = v4;
        if (ktDeclaration == null) {
            return null;
        }
        KtDeclaration field2 = ktDeclaration;
        if (nearest) {
            return DebuggerContextUtil.findNearest((DebuggerContextImpl)context, (PsiElement)field2, (PsiFile)myClass.getContainingFile());
        }
        return SourcePosition.createFromOffset((PsiFile)field2.getContainingFile(), (int)field2.getTextOffset());
    }

    private final PsiElement findClassByType(Project project, ReferenceType type2, DebuggerContextImpl context) {
        PsiElement element2;
        DebuggerSession session = context.getDebuggerSession();
        DebuggerSession debuggerSession = session;
        if (debuggerSession == null || (debuggerSession = debuggerSession.getSearchScope()) == null) {
            debuggerSession = GlobalSearchScope.allScope((Project)project);
        }
        DebuggerSession scope2 = debuggerSession;
        String className2 = JvmClassName.byInternalName(type2.name()).getFqNameForClassNameWithoutDollars().asString();
        PsiClass myClass = JavaPsiFacade.getInstance((Project)project).findClass(className2, (GlobalSearchScope)scope2);
        if (myClass != null) {
            return (PsiElement)myClass;
        }
        SourcePosition position2 = this.getLastSourcePosition(type2, context);
        if (position2 != null && (element2 = position2.getElementAt()) != null) {
            PsiElement $receiver$iv = element2;
            return PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClassOrObject.class, (boolean)true);
        }
        return null;
    }

    private final SourcePosition getLastSourcePosition(ReferenceType type2, DebuggerContextImpl context) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (debugProcess != null) {
            try {
                List<Location> locations = type2.allLineLocations();
                if (!locations.isEmpty()) {
                    Location lastLocation = locations.get(locations.size() - 1);
                    return debugProcess.getPositionManager().getSourcePosition(lastLocation);
                }
            }
            catch (AbsentInformationException absentInformationException) {
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                // empty catch block
            }
        }
        return null;
    }
}

