/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.classLoading;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.CompilingEvaluatorUtils;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassLoaderHandler;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ.\u0010\u000f\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/OrdinaryClassLoadingAdapter;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter;", "()V", "defineClass", "", "name", "", "bytes", "", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "defineClasses", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "isApplicable", "", "hasAdditionalClasses", "hasLoops", "loadClasses", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoaderHandler;", "ClassBytes", "Companion", "idea"})
public final class OrdinaryClassLoadingAdapter
implements ClassLoadingAdapter {
    private static final List<ClassBytes> LAMBDA_SUPERCLASSES;
    public static final Companion Companion;

    @Override
    public boolean isApplicable(@NotNull EvaluationContextImpl context, boolean hasAdditionalClasses, boolean hasLoops) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (hasAdditionalClasses || hasLoops) && context.getClassLoader() != null && !NoStrataPositionManagerHelperKt.isDexDebug((DebugProcess)context.getDebugProcess());
    }

    @Override
    @NotNull
    public ClassLoaderHandler loadClasses(@NotNull EvaluationContextImpl context, @NotNull Collection<ClassToLoad> classes2) {
        ClassLoaderReference classLoaderReference;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
        DebugProcessImpl process2 = context.getDebugProcess();
        try {
            classLoaderReference = ClassLoadingUtils.getClassLoader((EvaluationContext)((EvaluationContext)context), (DebugProcess)((DebugProcess)process2));
        }
        catch (Exception e) {
            throw (Throwable)new EvaluateException("Error creating evaluation class loader: " + e, (Throwable)e);
        }
        ClassLoaderReference classLoader = classLoaderReference;
        String version = process2.getVirtualMachineProxy().version();
        JavaSdkVersion sdkVersion = JdkVersionUtil.getVersion((String)version);
        if (!SystemInfo.isJavaVersionAtLeast((String)sdkVersion.getDescription())) {
            throw (Throwable)new EvaluateException("Unable to compile for target level " + sdkVersion.getDescription() + ". " + "Need to run IDEA on java version at least " + sdkVersion.getDescription() + ", " + "currently running on " + SystemInfo.JAVA_RUNTIME_VERSION);
        }
        try {
            DebugProcessImpl debugProcessImpl = process2;
            Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"process");
            ClassLoaderReference classLoaderReference2 = classLoader;
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoaderReference2, (String)"classLoader");
            this.defineClasses(classes2, context, debugProcessImpl, classLoaderReference2);
        }
        catch (Exception e) {
            throw (Throwable)new EvaluateException("Error during classes definition " + e, (Throwable)e);
        }
        return new ClassLoaderHandler(classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private final void defineClasses(Collection<ClassToLoad> classes2, EvaluationContextImpl context, DebugProcessImpl process2, ClassLoaderReference classLoader) {
        Collection collection;
        if (classes2.size() == 1) {
            collection = classes2;
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)OrdinaryClassLoadingAdapter.Companion.getLAMBDA_SUPERCLASSES();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ClassBytes classBytes = (ClassBytes)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                ClassToLoad classToLoad = new ClassToLoad(it.getName(), StringsKt.replace$default((String)it.getName(), (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class", it.getBytes());
                collection2.add(classToLoad);
            }
            List lambdaSuperclasses = (List)destination$iv$iv;
            collection = CollectionsKt.plus((Collection)lambdaSuperclasses, (Iterable)classes2);
        }
        Collection classesToLoad = collection;
        for (ClassToLoad classToLoad : classesToLoad) {
            String className2 = classToLoad.component1();
            byte[] bytes2 = classToLoad.component3();
            byte[] patchedBytes = CompilingEvaluatorUtils.changeSuperToMagicAccessor(bytes2);
            Intrinsics.checkExpressionValueIsNotNull((Object)patchedBytes, (String)"patchedBytes");
            this.defineClass(className2, patchedBytes, context, process2, classLoader);
        }
    }

    public final void defineClass(@NotNull String name2, @NotNull byte[] bytes2, @NotNull EvaluationContextImpl context, @NotNull DebugProcessImpl process2, @NotNull ClassLoaderReference classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)bytes2, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        try {
            VirtualMachineProxyImpl vm = process2.getVirtualMachineProxy();
            ReferenceType referenceType = classLoader.referenceType();
            if (referenceType == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
            }
            ClassType classLoaderType = (ClassType)referenceType;
            Method defineMethod = classLoaderType.concreteMethodByName("defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;");
            StringReference nameObj = vm.mirrorOf(name2);
            DebuggerUtilsEx.keep((Value)nameObj, (EvaluationContext)((EvaluationContext)context));
            process2.invokeMethod((EvaluationContext)context, (ObjectReference)classLoader, defineMethod, CollectionsKt.listOf((Object[])new Value[]{nameObj, this.mirrorOfByteArray(bytes2, context, process2), vm.mirrorOf(0), vm.mirrorOf(bytes2.length)}));
        }
        catch (Exception e) {
            throw (Throwable)new EvaluateException("Error during class " + name2 + " definition: " + e, (Throwable)e);
        }
    }

    static {
        Companion = new Companion(null);
        LAMBDA_SUPERCLASSES = CollectionsKt.listOf((Object)new ClassBytes("kotlin.jvm.internal.Lambda"));
    }

    @Override
    @NotNull
    public ArrayReference mirrorOfByteArray(@NotNull byte[] bytes2, @NotNull EvaluationContextImpl context, @NotNull DebugProcessImpl process2) {
        Intrinsics.checkParameterIsNotNull((Object)bytes2, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        return ClassLoadingAdapter.DefaultImpls.mirrorOfByteArray(this, bytes2, context, process2);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/OrdinaryClassLoadingAdapter$ClassBytes;", "", "name", "", "(Ljava/lang/String;)V", "bytes", "", "getBytes", "()[B", "bytes$delegate", "Lkotlin/Lazy;", "getName", "()Ljava/lang/String;", "idea"})
    private static final class ClassBytes {
        @NotNull
        private final Lazy bytes$delegate;
        @NotNull
        private final String name;
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        @NotNull
        public final byte[] getBytes() {
            Lazy lazy = this.bytes$delegate;
            ClassBytes classBytes = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (byte[])lazy.getValue();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public ClassBytes(@NotNull String name2) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            this.name = name2;
            this.bytes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>(this){
                final /* synthetic */ ClassBytes this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final byte[] invoke() {
                    Closeable closeable;
                    byte[] byArray;
                    InputStream inputStream = this.this$0.getClass().getClassLoader().getResourceAsStream(StringsKt.replace$default((String)this.this$0.getName(), (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class");
                    if (inputStream == null) {
                        throw (Throwable)new EvaluateException("Couldn't find " + this.this$0.getName() + " class in current class loader");
                    }
                    InputStream inputStream2 = inputStream;
                    Closeable closeable2 = inputStream2;
                    boolean bl = false;
                    try {
                        InputStream it = (InputStream)closeable2;
                        byArray = ByteStreamsKt.readBytes$default((InputStream)it, (int)0, (int)1, null);
                        closeable = closeable2;
                    }
                    catch (Exception exception) {
                        try {
                            bl = true;
                            try {
                                Closeable closeable3 = closeable2;
                                if (closeable3 != null) {
                                    closeable3.close();
                                }
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            throw (Throwable)exception;
                        }
                        catch (Throwable throwable) {
                            if (!bl) {
                                Closeable closeable4 = closeable2;
                                if (closeable4 != null) {
                                    closeable4.close();
                                }
                            }
                            throw throwable;
                        }
                    }
                    if (closeable != null) {
                        closeable.close();
                    }
                    return byArray;
                }
                {
                    this.this$0 = classBytes;
                    super(0);
                }
            }));
        }

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ClassBytes.class), "bytes", "getBytes()[B"))};
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/OrdinaryClassLoadingAdapter$Companion;", "", "()V", "LAMBDA_SUPERCLASSES", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/OrdinaryClassLoadingAdapter$ClassBytes;", "getLAMBDA_SUPERCLASSES", "()Ljava/util/List;", "idea"})
    private static final class Companion {
        private final List<ClassBytes> getLAMBDA_SUPERCLASSES() {
            return LAMBDA_SUPERCLASSES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

