/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.filter;

import com.intellij.debugger.engine.SyntheticTypeComponentProvider;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqNameUnsafe;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u000f\u0010\u0010\u001a\u00020\b*\u0004\u0018\u00010\u0011H\u0082\u0010J\f\u0010\u0012\u001a\u00020\b*\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/filter/KotlinSyntheticTypeComponentProvider;", "Lcom/intellij/debugger/engine/SyntheticTypeComponentProvider;", "()V", "LOAD_INSTRUCTIONS", "Lkotlin/ranges/IntRange;", "LOAD_INSTRUCTIONS_WITH_INDEX", "RETURN_INSTRUCTIONS", "hasInterfaceWithImplementation", "", "method", "Lcom/sun/jdi/Method;", "hasOnlyInvokeStatic", "m", "isSynthetic", "typeComponent", "Lcom/sun/jdi/TypeComponent;", "isCallableReferenceSyntheticClass", "Lcom/sun/jdi/ReferenceType;", "isDelegateToDefaultInterfaceImpl", "idea"})
public final class KotlinSyntheticTypeComponentProvider
implements SyntheticTypeComponentProvider {
    private final IntRange LOAD_INSTRUCTIONS_WITH_INDEX;
    private final IntRange LOAD_INSTRUCTIONS;
    private final IntRange RETURN_INSTRUCTIONS;

    public boolean isSynthetic(@Nullable TypeComponent typeComponent) {
        if (!(typeComponent instanceof Method)) {
            return false;
        }
        ReferenceType containingType = typeComponent.declaringType();
        String typeName = containingType.name();
        if (!FqNameUnsafe.isValid(typeName)) {
            return false;
        }
        if (this.isCallableReferenceSyntheticClass(containingType)) {
            return true;
        }
        try {
            boolean bl;
            block12: {
                boolean bl2;
                Location it;
                Iterable $receiver$iv;
                block11: {
                    if (this.isDelegateToDefaultInterfaceImpl((Method)typeComponent)) {
                        return true;
                    }
                    if (((Method)typeComponent).location().lineNumber() != 1) {
                        return false;
                    }
                    $receiver$iv = ((Method)typeComponent).allLineLocations();
                    for (Object element$iv : $receiver$iv) {
                        it = (Location)element$iv;
                        if (!(it.lineNumber() != 1)) continue;
                        bl2 = true;
                        break block11;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    return false;
                }
                $receiver$iv = typeComponent.declaringType().allLineLocations();
                for (Object element$iv : $receiver$iv) {
                    it = (Location)element$iv;
                    if (!(it.lineNumber() != 1)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
            return !bl;
        }
        catch (AbsentInformationException e) {
            return false;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    private final boolean isCallableReferenceSyntheticClass(@Nullable ReferenceType $receiver) {
        while (true) {
            ClassType superClass;
            if (!($receiver instanceof ClassType)) {
                return false;
            }
            if (((ClassType)$receiver).superclass() == null) {
                return false;
            }
            String superClassName = superClass.name();
            if (Intrinsics.areEqual((Object)superClassName, (Object)PropertyReference.class.getName()) || Intrinsics.areEqual((Object)superClassName, (Object)FunctionReference.class.getName())) {
                return true;
            }
            if (!StringsKt.startsWith$default((String)superClassName, (String)"kotlin.jvm.internal.", (boolean)false, (int)2, null)) break;
            $receiver = superClass;
        }
        return false;
    }

    private final boolean isDelegateToDefaultInterfaceImpl(@NotNull Method $receiver) {
        if ($receiver.allLineLocations().size() != 1) {
            return false;
        }
        if (!$receiver.virtualMachine().canGetBytecodes()) {
            return false;
        }
        if (!this.hasOnlyInvokeStatic($receiver)) {
            return false;
        }
        return this.hasInterfaceWithImplementation($receiver);
    }

    private final boolean hasOnlyInvokeStatic(Method m) {
        byte[] bytecodes = m.bytecodes();
        int i = 0;
        boolean isALoad0BeforeStaticCall = false;
        while (i < bytecodes.length) {
            byte nextInstr;
            byte instr = bytecodes[i];
            if (instr == (byte)42) {
                ++i;
                isALoad0BeforeStaticCall = true;
                continue;
            }
            if (RangesKt.intRangeContains((ClosedRange)((ClosedRange)this.LOAD_INSTRUCTIONS_WITH_INDEX), (byte)instr) || RangesKt.intRangeContains((ClosedRange)((ClosedRange)this.LOAD_INSTRUCTIONS), (byte)instr)) {
                ++i;
                if (RangesKt.intRangeContains((ClosedRange)((ClosedRange)this.LOAD_INSTRUCTIONS_WITH_INDEX), (byte)instr)) {
                    ++i;
                }
                if ((nextInstr = bytecodes[i]) != (byte)18) continue;
                i += 2;
                isALoad0BeforeStaticCall = false;
                continue;
            }
            if (instr == (byte)184) {
                if (!isALoad0BeforeStaticCall || (i += 3) != bytecodes.length - 1) continue;
                nextInstr = bytecodes[i];
                return RangesKt.intRangeContains((ClosedRange)((ClosedRange)this.RETURN_INSTRUCTIONS), (byte)nextInstr);
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasInterfaceWithImplementation(Method method) {
        boolean bl;
        block4: {
            void $receiver$iv$iv;
            ReferenceType referenceType = method.declaringType();
            if (!(referenceType instanceof ClassType)) {
                referenceType = null;
            }
            ClassType classType = (ClassType)referenceType;
            if (classType == null) {
                return false;
            }
            ClassType declaringType = classType;
            List<InterfaceType> interfaces = declaringType.allInterfaces();
            VirtualMachine vm = declaringType.virtualMachine();
            Iterable $receiver$iv = interfaces;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                InterfaceType it = (InterfaceType)element$iv$iv;
                Iterable list$iv$iv = vm.classesByName(it.name() + "$DefaultImpls");
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List traitImpls = (List)destination$iv$iv;
            $receiver$iv = traitImpls;
            for (Object element$iv : $receiver$iv) {
                ReferenceType it = (ReferenceType)element$iv;
                if (!(!it.methodsByName(method.name()).isEmpty())) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    public KotlinSyntheticTypeComponentProvider() {
        byte by = (byte)21;
        this.LOAD_INSTRUCTIONS_WITH_INDEX = new IntRange((int)by, (int)((byte)25));
        by = (byte)26;
        this.LOAD_INSTRUCTIONS = new IntRange((int)by, (int)((byte)45));
        by = (byte)172;
        this.RETURN_INSTRUCTIONS = new IntRange((int)by, (int)((byte)177));
    }
}

