/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.psi.PsiElement;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.DescriptorUtilsKt;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinBasicStepMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinBasicStepMethodFilter$WhenMappings;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinBasicStepMethodFilterKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinBasicStepMethodFilter;", "Lcom/intellij/debugger/engine/NamedMethodFilter;", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "myCallingExpressionLines", "Lcom/intellij/util/Range;", "", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;Lcom/intellij/util/Range;)V", "myTargetMethodName", "", "getCallingExpressionLines", "getMethodName", "locationMatches", "", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "idea"})
public final class KotlinBasicStepMethodFilter
implements NamedMethodFilter {
    private final String myTargetMethodName;
    private final CallableMemberDescriptor targetDescriptor;
    private final Range<Integer> myCallingExpressionLines;

    @NotNull
    public Range<Integer> getCallingExpressionLines() {
        return this.myCallingExpressionLines;
    }

    @NotNull
    public String getMethodName() {
        return this.myTargetMethodName;
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location2) {
        boolean bl;
        block16: {
            boolean bl2;
            Iterable $receiver$iv;
            Collection baseDescriptors;
            DeclarationDescriptor currentDescriptor2;
            block14: {
                Collection collection;
                Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
                Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
                Method method = location2.method();
                if (Intrinsics.areEqual((Object)this.myTargetMethodName, (Object)method.name()) ^ true) {
                    return false;
                }
                CompoundPositionManager positionManager = process2.getPositionManager();
                DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)ApplicationUtilsKt.runReadAction((Function0)new Function0<DeclarationDescriptor>(positionManager, location2, method){
                    final /* synthetic */ CompoundPositionManager $positionManager;
                    final /* synthetic */ Location $location;
                    final /* synthetic */ Method $method;

                    @Nullable
                    public final DeclarationDescriptor invoke() {
                        DeclarationDescriptor declarationDescriptor;
                        KtDeclaration declaration2;
                        PsiElement elementAt;
                        SourcePosition sourcePosition = this.$positionManager.getSourcePosition(this.$location);
                        PsiElement psiElement2 = elementAt = sourcePosition != null ? sourcePosition.getElementAt() : null;
                        KtDeclaration ktDeclaration = declaration2 = psiElement2 != null ? (KtDeclaration)PsiUtilsKt.getParentOfTypesAndPredicate(psiElement2, false, new Class[]{KtDeclaration.class}, locationMatches.currentDescriptor.declaration.1.INSTANCE) : null;
                        if (declaration2 instanceof KtClass && Intrinsics.areEqual((Object)this.$method.name(), (Object)"<init>")) {
                            DeclarationDescriptor declarationDescriptor2 = ResolutionUtils.resolveToDescriptor$default(declaration2, null, 1, null);
                            if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                                declarationDescriptor2 = null;
                            }
                            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor2;
                            declarationDescriptor = classDescriptor != null ? classDescriptor.getUnsubstitutedPrimaryConstructor() : null;
                        } else {
                            KtDeclaration ktDeclaration2 = declaration2;
                            declarationDescriptor = ktDeclaration2 != null ? ResolutionUtils.resolveToDescriptor$default(ktDeclaration2, null, 1, null) : null;
                        }
                        return declarationDescriptor;
                    }
                    {
                        this.$positionManager = compoundPositionManager;
                        this.$location = location2;
                        this.$method = method;
                        super(0);
                    }
                });
                if (declarationDescriptor == null) {
                    return false;
                }
                currentDescriptor2 = declarationDescriptor;
                if (!(currentDescriptor2 instanceof CallableMemberDescriptor)) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)((Object)((CallableMemberDescriptor)currentDescriptor2).getKind()), (Object)((Object)CallableMemberDescriptor.Kind.DECLARATION)) ^ true) {
                    return false;
                }
                if (this.targetDescriptor instanceof FunctionInvokeDescriptor) {
                    return true;
                }
                if (KotlinBasicStepMethodFilterKt.access$compareDescriptors(currentDescriptor2, this.targetDescriptor)) {
                    return true;
                }
                switch (KotlinBasicStepMethodFilter$WhenMappings.$EnumSwitchMapping$0[this.targetDescriptor.getKind().ordinal()]) {
                    case 1: 
                    case 2: {
                        collection = DescriptorUtilsKt.getDirectlyOverriddenDeclarations(this.targetDescriptor);
                        break;
                    }
                    case 3: 
                    case 4: {
                        collection = CollectionsKt.listOf((Object)this.targetDescriptor);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                baseDescriptors = collection;
                $receiver$iv = baseDescriptors;
                for (Object element$iv : $receiver$iv) {
                    CallableMemberDescriptor baseOfTarget = (CallableMemberDescriptor)element$iv;
                    if (!KotlinBasicStepMethodFilterKt.access$compareDescriptors(baseOfTarget, currentDescriptor2)) continue;
                    bl2 = true;
                    break block14;
                }
                bl2 = false;
            }
            if (bl2) {
                return true;
            }
            $receiver$iv = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)currentDescriptor2);
            for (Object element$iv : $receiver$iv) {
                boolean bl3;
                block15: {
                    CallableMemberDescriptor baseOfCurrent = (CallableMemberDescriptor)element$iv;
                    Iterable $receiver$iv2 = baseDescriptors;
                    for (Object element$iv2 : $receiver$iv2) {
                        CallableMemberDescriptor baseOfTarget = (CallableMemberDescriptor)element$iv2;
                        CallableMemberDescriptor callableMemberDescriptor = baseOfCurrent;
                        Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"baseOfCurrent");
                        if (!KotlinBasicStepMethodFilterKt.access$compareDescriptors(callableMemberDescriptor, baseOfTarget)) continue;
                        bl3 = true;
                        break block15;
                    }
                    bl3 = false;
                }
                if (!bl3) continue;
                bl = true;
                break block16;
            }
            bl = false;
        }
        return bl;
    }

    public KotlinBasicStepMethodFilter(@NotNull CallableMemberDescriptor targetDescriptor, @NotNull Range<Integer> myCallingExpressionLines) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)targetDescriptor, (String)"targetDescriptor");
        Intrinsics.checkParameterIsNotNull(myCallingExpressionLines, (String)"myCallingExpressionLines");
        this.targetDescriptor = targetDescriptor;
        this.myCallingExpressionLines = myCallingExpressionLines;
        CallableMemberDescriptor callableMemberDescriptor = this.targetDescriptor;
        if (callableMemberDescriptor instanceof ClassDescriptor || callableMemberDescriptor instanceof ConstructorDescriptor) {
            string = "<init>";
        } else if (callableMemberDescriptor instanceof PropertyAccessorDescriptor) {
            String string2 = JvmAbi.getterName(((PropertyAccessorDescriptor)this.targetDescriptor).getCorrespondingProperty().getName().asString());
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"JvmAbi.getterName(target\u2026Property.name.asString())");
        } else {
            String string3 = this.targetDescriptor.getName().asString();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"targetDescriptor.name.asString()");
        }
        this.myTargetMethodName = string;
    }
}

