/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.KotlinJavaModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0016\u0017B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH$J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "libraryJarDescriptors", "", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;)V", "getLibraryJarDescriptors", "()Ljava/util/List;", "getLibraryDescriptor", "Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix$MavenExternalLibraryDescriptor;", "module", "Lcom/intellij/openapi/module/Module;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "MavenExternalLibraryDescriptor", "idea"})
public abstract class AddKotlinLibQuickFix
extends KotlinQuickFixAction<KtElement> {
    @NotNull
    private final List<LibraryJarDescriptor> libraryJarDescriptors;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected abstract MavenExternalLibraryDescriptor getLibraryDescriptor(@NotNull Module var1);

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtElement ktElement = (KtElement)this.getElement();
        if (ktElement == null) {
            return;
        }
        KtElement element2 = ktElement;
        Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(element2.getContainingFile().getVirtualFile());
        if (module != null) {
            if (KotlinPluginUtil.isMavenModule(module)) {
                DependencyScope scope2 = OrderEntryFix.suggestScopeByLocation((Module)module, (PsiElement)((PsiElement)element2));
                JavaProjectModelModificationService.getInstance((Project)project).addDependency(module, (ExternalLibraryDescriptor)this.getLibraryDescriptor(module), scope2);
                return;
            }
            if (KotlinPluginUtil.isGradleModule(module) || KotlinPluginUtil.isAndroidGradleModule(module)) {
                DependencyScope scope3;
                DependencyScope dependencyScope = scope3 = OrderEntryFix.suggestScopeByLocation((Module)module, (PsiElement)((PsiElement)element2));
                Intrinsics.checkExpressionValueIsNotNull((Object)dependencyScope, (String)"scope");
                KotlinWithGradleConfigurator.Companion.addKotlinLibraryToModule(module, dependencyScope, this.getLibraryDescriptor(module));
                return;
            }
        }
        KotlinJavaModuleConfigurator configurator = KotlinJavaModuleConfigurator.Companion.getInstance();
        NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project);
        Iterator iterator2 = KotlinRuntimeLibraryUtilKt.findAllUsedLibraries(project).keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile runtimeJar;
            Library library2;
            Library library3 = library2 = (Library)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)library3, (String)"library");
            if (LibraryJarDescriptor.RUNTIME_JAR.findExistingJar(library3) == null) {
                continue;
            }
            Library.ModifiableModel model = library2.getModifiableModel();
            String libFilesDir = VfsUtilCore.virtualToIoFile((VirtualFile)runtimeJar).getParent();
            for (LibraryJarDescriptor libraryJarDescriptor : this.libraryJarDescriptors) {
                File copied;
                File libFile;
                if (libraryJarDescriptor.findExistingJar(library2) != null || !(libFile = libraryJarDescriptor.getPathInPlugin()).exists()) continue;
                File libIoFile = new File(libFilesDir, libraryJarDescriptor.getJarName());
                if (libIoFile.exists()) {
                    model.addRoot(VfsUtil.getUrlForLibraryRoot((File)libIoFile), libraryJarDescriptor.getOrderRootType());
                    continue;
                }
                String string = libFilesDir;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"libFilesDir");
                if (configurator.copyFileToDir(libFile, string, collector2) == null) {
                    Intrinsics.throwNpe();
                }
                model.addRoot(VfsUtil.getUrlForLibraryRoot((File)copied), libraryJarDescriptor.getOrderRootType());
            }
            model.commit();
        }
        collector2.showNotification();
    }

    @NotNull
    public final List<LibraryJarDescriptor> getLibraryJarDescriptors() {
        return this.libraryJarDescriptors;
    }

    public AddKotlinLibQuickFix(@NotNull KtElement element2, @NotNull List<? extends LibraryJarDescriptor> libraryJarDescriptors) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull(libraryJarDescriptors, (String)"libraryJarDescriptors");
        super((PsiElement)element2);
        this.libraryJarDescriptors = libraryJarDescriptors;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix$MavenExternalLibraryDescriptor;", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "groupId", "", "artifactId", "version", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLibraryClassesRoots", "", "idea"})
    public static final class MavenExternalLibraryDescriptor
    extends ExternalLibraryDescriptor {
        @NotNull
        public List<String> getLibraryClassesRoots() {
            return CollectionsKt.emptyList();
        }

        public MavenExternalLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
            Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
            Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            super(groupId, artifactId, version, version);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix$Companion;", "", "()V", "getKotlinStdlibVersion", "", "module", "Lcom/intellij/openapi/module/Module;", "getMavenKotlinStdlibVersion", "idea"})
    public static final class Companion {
        @NotNull
        public final String getKotlinStdlibVersion(@NotNull Module module) {
            String pluginVersion;
            String gradleVersion;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            if (KotlinPluginUtil.isMavenModule(module)) {
                String mavenVersion = this.getMavenKotlinStdlibVersion(module);
                if (mavenVersion != null) {
                    return mavenVersion;
                }
            } else if ((KotlinPluginUtil.isGradleModule(module) || KotlinPluginUtil.isAndroidGradleModule(module)) && (gradleVersion = KotlinWithGradleConfigurator.Companion.getKotlinStdlibVersion(module)) != null) {
                return gradleVersion;
            }
            if (Intrinsics.areEqual((Object)"@snapshot@", (Object)(pluginVersion = KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion()))) {
                return "1.1-SNAPSHOT";
            }
            return pluginVersion;
        }

        @Nullable
        public final String getMavenKotlinStdlibVersion(@NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Object[] $receiver$iv = LibrariesContainerFactory.createContainer((Module)module).getAllLibraries();
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                Library library2 = (Library)element$iv;
                String libName = library2.getName();
                if (libName == null || !StringsKt.contains$default((CharSequence)libName, (CharSequence)"org.jetbrains.kotlin:kotlin-stdlib", (boolean)false, (int)2, null)) continue;
                return StringsKt.substringAfterLast$default((String)libName, (String)":", null, (int)2, null);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

