/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \t2\u00020\u0001:\u0003\t\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "RemoveFix", "SimplifyFix", "idea"})
public final class ConstantConditionIfInspection
extends AbstractKotlinInspection {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public void visitIfExpression(@NotNull KtIfExpression expression2) {
                LocalQuickFix[] localQuickFixArray;
                void $receiver$iv;
                Object object;
                Collection collection;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitIfExpression(expression2);
                KtExpression ktExpression = expression2.getCondition();
                if (ktExpression == null) {
                    return;
                }
                KtExpression condition2 = ktExpression;
                BindingContext context = ResolutionUtils.analyze(condition2, BodyResolveMode.PARTIAL);
                Boolean bl = org.jetbrains.kotlin.idea.inspections.ConstantConditionIfInspection$Companion.access$constantBooleanValue(ConstantConditionIfInspection.Companion, condition2, context);
                if (bl == null) {
                    return;
                }
                boolean constantValue = bl;
                List fixes2 = new ArrayList<E>();
                if (org.jetbrains.kotlin.idea.inspections.ConstantConditionIfInspection$Companion.access$branch(ConstantConditionIfInspection.Companion, expression2, constantValue) != null) {
                    collection = fixes2;
                    object = new SimplifyFix(constantValue, BindingContextUtilsKt.isUsedAsExpression(expression2, context));
                    collection.add(object);
                }
                if (!constantValue && expression2.getElse() == null) {
                    collection = fixes2;
                    object = new RemoveFix();
                    collection.add(object);
                }
                collection = fixes2;
                String string = "Condition is always '" + constantValue + '\'';
                PsiElement psiElement2 = (PsiElement)condition2;
                ProblemsHolder problemsHolder = this.$holder;
                void thisCollection$iv = $receiver$iv;
                LocalQuickFix[] localQuickFixArray2 = thisCollection$iv.toArray(new LocalQuickFix[thisCollection$iv.size()]);
                if (localQuickFixArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                LocalQuickFix[] localQuickFixArray3 = localQuickFixArray = localQuickFixArray2;
                problemsHolder.registerProblem(psiElement2, string, Arrays.copyOf(localQuickFixArray3, localQuickFixArray3.length));
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection$SimplifyFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "conditionValue", "", "isUsedAsExpression", "(ZZ)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class SimplifyFix
    implements LocalQuickFix {
        private final boolean conditionValue;
        private final boolean isUsedAsExpression;

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return "Simplify expression";
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block17: {
                KtExpression ktExpression;
                PsiElement result$iv;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement2 = descriptor2.getPsiElement();
                boolean strict$iv = true;
                KtIfExpression ktIfExpression = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtIfExpression.class, (boolean)strict$iv);
                if (ktIfExpression == null) {
                    return;
                }
                KtIfExpression ifExpression2 = ktIfExpression;
                Editor editor = IntentionBasedInspectionKt.findExistingEditor((PsiElement)ifExpression2);
                CaretModel caretModel = editor != null ? editor.getCaretModel() : null;
                KtExpression ktExpression2 = Companion.branch(ifExpression2, this.conditionValue);
                if (ktExpression2 == null || (ktExpression2 = IfThenUtilsKt.unwrapBlockOrParenthesis(ktExpression2)) == null) {
                    return;
                }
                KtExpression branch = ktExpression2;
                if (!(branch instanceof KtBlockExpression)) {
                    Object object;
                    PsiElement $receiver$iv2 = (PsiElement)ifExpression2;
                    result$iv = $receiver$iv2.replace((PsiElement)branch);
                    if (result$iv instanceof KtExpression) {
                        object = result$iv;
                    } else {
                        PsiElement psiElement3 = result$iv;
                        if (psiElement3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                        }
                        object = ((KtParenthesizedExpression)psiElement3).getExpression();
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                        }
                    }
                    ktExpression = (KtExpression)object;
                } else if (this.isUsedAsExpression) {
                    Object object;
                    void $receiver$iv3;
                    KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)ifExpression2, false, 2, null);
                    result$iv = (PsiElement)ifExpression2;
                    Object[] objectArray = new Object[1];
                    String string = ((KtBlockExpression)branch).getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"branch.text");
                    objectArray[0] = string;
                    PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default(factory2, "run $0", objectArray, false, 4, null);
                    PsiElement result$iv2 = $receiver$iv3.replace(newElement$iv);
                    if (result$iv2 instanceof KtExpression) {
                        object = result$iv2;
                    } else {
                        PsiElement psiElement4 = result$iv2;
                        if (psiElement4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                        }
                        object = ((KtParenthesizedExpression)psiElement4).getExpression();
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                        }
                    }
                    ktExpression = (KtExpression)object;
                } else {
                    PsiElement firstChild = ((KtBlockExpression)branch).getFirstChild().getNextSibling();
                    if (Intrinsics.areEqual((Object)firstChild, (Object)((KtBlockExpression)branch).getLastChild())) {
                        ifExpression2.delete();
                    } else {
                        PsiElement lastChild = ((KtBlockExpression)branch).getLastChild().getPrevSibling();
                        PsiElement parent2 = ifExpression2.getParent();
                        parent2.addRangeAfter(firstChild, lastChild, (PsiElement)ifExpression2);
                        ifExpression2.delete();
                    }
                    ktExpression = null;
                }
                KtExpression lastExpression = ktExpression;
                CaretModel caretModel2 = caretModel;
                if (caretModel2 == null) break block17;
                KtExpression ktExpression3 = lastExpression;
                if (ktExpression3 == null) {
                    return;
                }
                caretModel2.moveToOffset(PsiUtilsKt.getStartOffset((PsiElement)ktExpression3));
            }
        }

        public SimplifyFix(boolean conditionValue, boolean isUsedAsExpression) {
            this.conditionValue = conditionValue;
            this.isUsedAsExpression = isUsedAsExpression;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection$RemoveFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class RemoveFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return "Delete expression";
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            boolean strict$iv = true;
            KtIfExpression ktIfExpression = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtIfExpression.class, (boolean)strict$iv);
            if (ktIfExpression == null) {
                return;
            }
            KtIfExpression ifExpression2 = ktIfExpression;
            ifExpression2.delete();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001b\u0010\b\u001a\u0004\u0018\u00010\u0007*\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection$Companion;", "", "()V", "branch", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "thenBranch", "", "constantBooleanValue", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingContext;)Ljava/lang/Boolean;", "idea"})
    private static final class Companion {
        private final KtExpression branch(@NotNull KtIfExpression $receiver, boolean thenBranch) {
            return thenBranch ? $receiver.getThen() : $receiver.getElse();
        }

        private final Boolean constantBooleanValue(@NotNull KtExpression $receiver, BindingContext context) {
            ConstantValue<?> constantValue;
            KotlinType kotlinType = CallUtilKt.getType($receiver, context);
            if (kotlinType == null) {
                return null;
            }
            KotlinType type2 = kotlinType;
            CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant($receiver, context);
            ConstantValue<?> constantValue2 = constantValue = compileTimeConstant != null ? compileTimeConstant.toConstantValue(type2) : null;
            Object object = constantValue2 != null ? constantValue2.getValue() : null;
            if (!(object instanceof Boolean)) {
                object = null;
            }
            return (Boolean)object;
        }

        private Companion() {
        }

        @Nullable
        public static final /* synthetic */ Boolean access$constantBooleanValue(Companion $this, @NotNull KtExpression $receiver, @NotNull BindingContext context) {
            return $this.constantBooleanValue($receiver, context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

