/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.SimplifyNegatedBinaryExpressionIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhileExpressionBase;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NullableBooleanElvisInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "ReplaceWithEqualityCheckFix", "idea"})
public final class NullableBooleanElvisInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                if (Intrinsics.areEqual((Object)expression2.getOperationToken(), (Object)((Object)KtTokens.ELVIS)) ^ true) {
                    return;
                }
                KtExpression ktExpression = expression2.getLeft();
                if (ktExpression == null) {
                    return;
                }
                KtExpression lhs = ktExpression;
                KtExpression ktExpression2 = expression2.getRight();
                if (ktExpression2 == null) {
                    return;
                }
                KtExpression rhs = ktExpression2;
                if (!KtPsiUtil.isBooleanConstant(rhs)) {
                    return;
                }
                KotlinType kotlinType = ResolutionUtils.analyze(lhs, BodyResolveMode.PARTIAL).getType(lhs);
                if (kotlinType == null) {
                    return;
                }
                KotlinType lhsType = kotlinType;
                if (TypeUtils.isNullableType(lhsType) && TypeUtilsKt.isBooleanOrNullableBoolean(lhsType)) {
                    KtExpressionImpl parentIfOrWhile = (KtExpressionImpl)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression2), (Class[])new Class[]{KtIfExpression.class, KtWhileExpressionBase.class});
                    KtExpressionImpl ktExpressionImpl = parentIfOrWhile;
                    KtExpression condition2 = ktExpressionImpl instanceof KtIfExpression ? ((KtIfExpression)parentIfOrWhile).getCondition() : (ktExpressionImpl instanceof KtWhileExpressionBase ? ((KtWhileExpressionBase)parentIfOrWhile).getCondition() : null);
                    ProblemHighlightType highlightType = condition2 != null && SequencesKt.contains(PsiUtilsKt.getParentsWithSelf((PsiElement)expression2), (Object)condition2) ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                    this.$holder.registerProblem((PsiElement)expression2, "Equality check can be used instead of elvis", highlightType, new LocalQuickFix[]{new ReplaceWithEqualityCheckFix()});
                }
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NullableBooleanElvisInspection$ReplaceWithEqualityCheckFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class ReplaceWithEqualityCheckFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return "Replace with equality check";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            void $receiver$iv;
            Object object;
            void $receiver$iv2;
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtBinaryExpression)) {
                psiElement2 = null;
            }
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement2;
            if (ktBinaryExpression == null) {
                return;
            }
            KtBinaryExpression element2 = ktBinaryExpression;
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)element2)) {
                return;
            }
            if (Intrinsics.areEqual((Object)element2.getOperationToken(), (Object)((Object)KtTokens.ELVIS)) ^ true) {
                return;
            }
            KtExpression ktExpression = element2.getRight();
            if (!(ktExpression instanceof KtConstantExpression)) {
                ktExpression = null;
            }
            KtConstantExpression ktConstantExpression = (KtConstantExpression)ktExpression;
            if (ktConstantExpression == null) {
                return;
            }
            KtConstantExpression constPart = ktConstantExpression;
            KtExpression ktExpression2 = element2.getLeft();
            if (ktExpression2 == null) {
                return;
            }
            KtExpression exprPart = ktExpression2;
            if (KtPsiUtil.isTrueConstant(constPart)) {
                bl = true;
            } else if (KtPsiUtil.isFalseConstant(constPart)) {
                bl = false;
            } else {
                return;
            }
            boolean constValue = bl;
            PsiElement psiElement3 = (PsiElement)element2;
            PsiElement newElement$iv = (PsiElement)CreateByPatternKt.buildExpression(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)constPart, false, 2, null), (Function1<? super BuilderByPattern<KtExpression>, Unit>)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(exprPart, constValue){
                final /* synthetic */ KtExpression $exprPart;
                final /* synthetic */ boolean $constValue;

                public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    $receiver.appendExpression(this.$exprPart);
                    $receiver.appendFixedText(this.$constValue ? " != false" : " == true");
                }
                {
                    this.$exprPart = ktExpression;
                    this.$constValue = bl;
                    super(1);
                }
            }));
            PsiElement result$iv = $receiver$iv2.replace(newElement$iv);
            if (result$iv instanceof KtExpression) {
                object = result$iv;
            } else {
                PsiElement psiElement4 = result$iv;
                if (psiElement4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                object = ((KtParenthesizedExpression)psiElement4).getExpression();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
            }
            KtExpression equalityCheckExpression2 = (KtExpression)object;
            newElement$iv = (PsiElement)equalityCheckExpression2;
            boolean strict$iv = true;
            KtPrefixExpression ktPrefixExpression = (KtPrefixExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtPrefixExpression.class, (boolean)strict$iv);
            if (ktPrefixExpression == null) {
                return;
            }
            KtPrefixExpression prefixExpression = ktPrefixExpression;
            SimplifyNegatedBinaryExpressionIntention simplifier = new SimplifyNegatedBinaryExpressionIntention();
            if (simplifier.isApplicableTo(prefixExpression)) {
                simplifier.applyTo(prefixExpression, (Editor)null);
            }
        }
    }
}

