/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.idea.inspections.UnnecessaryVariableInspection$WhenMappings;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineValHandler;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnnecessaryVariableInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "InlineVariableFix", "idea"})
public final class UnnecessaryVariableInspection
extends AbstractKotlinInspection {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitProperty(@NotNull KtProperty property2) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                super.visitProperty(property2);
                PsiElement psiElement2 = property2.getNameIdentifier();
                if (psiElement2 == null) {
                    return;
                }
                PsiElement nameIdentifier = psiElement2;
                Companion.Status status2 = org.jetbrains.kotlin.idea.inspections.UnnecessaryVariableInspection$Companion.access$statusFor(UnnecessaryVariableInspection.Companion, property2);
                if (status2 == null) {
                    return;
                }
                Companion.Status status3 = status2;
                switch (UnnecessaryVariableInspection$WhenMappings.$EnumSwitchMapping$0[status3.ordinal()]) {
                    case 1: {
                        string = "Variable used only in following return and can be inlined";
                        break;
                    }
                    case 2: {
                        string = "Variable is an exact copy of another variable and can be inlined";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                this.$holder.registerProblem(nameIdentifier, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new InlineVariableFix()});
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnnecessaryVariableInspection$InlineVariableFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "startInWriteAction", "", "idea"})
    public static final class InlineVariableFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return "Inline variable";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public boolean startInWriteAction() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            boolean strict$iv = true;
            KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtProperty.class, (boolean)strict$iv);
            if (ktProperty == null) {
                return;
            }
            KtProperty property2 = ktProperty;
            new KotlinInlineValHandler().inlineElement(project, IntentionBasedInspectionKt.findExistingEditor(property2), property2);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnnecessaryVariableInspection$Companion;", "", "()V", "isActiveFor", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "statusFor", "Lorg/jetbrains/kotlin/idea/inspections/UnnecessaryVariableInspection$Companion$Status;", "Status", "idea"})
    public static final class Companion {
        private final Status statusFor(KtProperty property2) {
            BindingContext context;
            KtExpression returned;
            BindingContext context2;
            DeclarationDescriptor initializerDescriptor;
            KtElement ktElement = KtPsiUtil.getEnclosingElementForLocalDeclaration(property2);
            if (ktElement == null) {
                return null;
            }
            KtElement enclosingElement = ktElement;
            KtExpression ktExpression = property2.getInitializer();
            if (ktExpression == null) {
                return null;
            }
            KtExpression initializer2 = ktExpression;
            if (!property2.isVar() && initializer2 instanceof KtNameReferenceExpression && property2.getTypeReference() == null && (initializerDescriptor = (DeclarationDescriptor)(context2 = ResolutionUtils.analyze$default(property2, null, 1, null)).get(BindingContext.REFERENCE_TARGET, initializer2)) instanceof VariableDescriptor && !((VariableDescriptor)initializerDescriptor).isVar() && ((VariableDescriptor)initializerDescriptor).getContainingDeclaration() instanceof FunctionDescriptor && ReferencesSearch.search((PsiElement)property2, (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)enclosingElement))).findFirst() != null) {
                return Status.EXACT_COPY;
            }
            PsiElement nextStatement = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default(property2, false, 1, null);
            if (nextStatement instanceof KtReturnExpression && (returned = ((KtReturnExpression)nextStatement).getReturnedExpression()) instanceof KtNameReferenceExpression && Intrinsics.areEqual((Object)((DeclarationDescriptor)(context = ResolutionUtils.analyze$default((KtElement)nextStatement, null, 1, null)).get(BindingContext.REFERENCE_TARGET, returned)), (Object)context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2))) {
                return Status.RETURN_ONLY;
            }
            return null;
        }

        public final boolean isActiveFor(@NotNull KtProperty property2) {
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            return this.statusFor(property2) != null;
        }

        private Companion() {
        }

        @Nullable
        public static final /* synthetic */ Status access$statusFor(Companion $this, @NotNull KtProperty property2) {
            return $this.statusFor(property2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnnecessaryVariableInspection$Companion$Status;", "", "(Ljava/lang/String;I)V", "RETURN_ONLY", "EXACT_COPY", "idea"})
        private static final class Status
        extends Enum<Status> {
            public static final /* enum */ Status RETURN_ONLY;
            public static final /* enum */ Status EXACT_COPY;
            private static final /* synthetic */ Status[] $VALUES;

            static {
                Status[] statusArray = new Status[2];
                Status[] statusArray2 = statusArray;
                statusArray[0] = RETURN_ONLY = new Status();
                statusArray[1] = EXACT_COPY = new Status();
                $VALUES = statusArray;
            }

            public static Status[] values() {
                return (Status[])$VALUES.clone();
            }

            public static Status valueOf(String string) {
                return Enum.valueOf(Status.class, string);
            }
        }
    }
}

