/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.idea.inspections.UseExpressionBodyInspection;
import org.jetbrains.kotlin.idea.inspections.UseExpressionBodyInspection$statusFor$;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0011H\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0004J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\rH\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\rH\u0002J\f\u0010\u001a\u001a\u00020\u0019*\u00020\u0019H\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UseExpressionBodyInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "convertEmptyToUnit", "", "(Z)V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "isActiveFor", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "simplify", "", "deleteTypeHandler", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "canDeleteTypeRef", "statusFor", "Lorg/jetbrains/kotlin/idea/inspections/UseExpressionBodyInspection$Status;", "blockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "findValueStatement", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getValue", "toHighlight", "Lcom/intellij/psi/PsiElement;", "ConvertToExpressionBodyFix", "Status", "idea"})
public final class UseExpressionBodyInspection
extends AbstractKotlinInspection {
    private final boolean convertEmptyToUnit;

    public final boolean isActiveFor(@NotNull KtDeclarationWithBody declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        return this.statusFor(declaration2) != null;
    }

    /*
     * WARNING - void declaration
     */
    private final Status statusFor(KtDeclarationWithBody declaration2) {
        void result$iv$iv;
        if (declaration2 instanceof KtConstructor) {
            return null;
        }
        KtExpression ktExpression = this.findValueStatement(declaration2);
        if (ktExpression == null) {
            return null;
        }
        KtExpression valueStatement = ktExpression;
        KtExpression value2 = this.getValue(valueStatement);
        PsiElement $receiver$iv = (PsiElement)value2;
        Function1 predicate$iv = statusFor$$inlined$anyDescendantOfType$1.INSTANCE;
        PsiElement $receiver$iv$iv = $receiver$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $receiver$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }

            public void visitElement(PsiElement element2) {
                if (element2 instanceof KtReturnExpression && ((Boolean)this.$predicate.invoke((Object)element2)).booleanValue()) {
                    this.$result.element = element2;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element2;
                if (!(it instanceof KtFunctionLiteral) && !(it instanceof KtNamedFunction) && !(it instanceof KtPropertyAccessor)) {
                    super.visitElement(element2);
                }
            }
        });
        if ((PsiElement)result$iv$iv.element != null) {
            return null;
        }
        PsiElement toHighlight = this.toHighlight(valueStatement);
        return !(valueStatement instanceof KtReturnExpression) ? new Status(toHighlight, "block body", ProblemHighlightType.INFORMATION) : (((KtReturnExpression)valueStatement).getReturnedExpression() instanceof KtWhenExpression ? new Status(toHighlight, "'return when'", ProblemHighlightType.GENERIC_ERROR_OR_WARNING) : (IfThenUtilsKt.isOneLiner(valueStatement) ? new Status(toHighlight, "one-line return", ProblemHighlightType.GENERIC_ERROR_OR_WARNING) : new Status(toHighlight, "return", ProblemHighlightType.INFORMATION)));
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(this, holder, isOnTheFly){
            final /* synthetic */ UseExpressionBodyInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;

            /*
             * WARNING - void declaration
             */
            public void visitDeclaration(@NotNull KtDeclaration declaration2) {
                void highlightType;
                void suffix;
                void toHighlight;
                TextRange textRange;
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                super.visitDeclaration(declaration2);
                KtDeclaration ktDeclaration = declaration2;
                if (!(ktDeclaration instanceof KtDeclarationWithBody)) {
                    ktDeclaration = null;
                }
                if ((KtDeclarationWithBody)ktDeclaration == null) {
                    return;
                }
                Status status2 = UseExpressionBodyInspection.access$statusFor(this.this$0, (KtDeclarationWithBody)declaration2);
                if (status2 == null) {
                    return;
                }
                Status status3 = status2;
                PsiElement psiElement2 = status3.component1();
                String string = status3.component2();
                ProblemHighlightType problemHighlightType = status3.component3();
                status3 = null;
                ProblemDescriptor problemDescriptor = this.$holder.getManager().createProblemDescriptor((PsiElement)declaration2, (textRange = toHighlight) != null && (textRange = textRange.getTextRange()) != null ? textRange.shiftRight(-PsiUtilsKt.getStartOffset(declaration2)) : null, "Use expression body instead of " + (String)suffix, (ProblemHighlightType)highlightType, this.$isOnTheFly, new LocalQuickFix[]{this.this$0.new ConvertToExpressionBodyFix()});
                this.$holder.registerProblem(problemDescriptor);
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
                this.$isOnTheFly = $captured_local_variable$2;
            }
        };
    }

    private final KtExpression findValueStatement(@NotNull KtDeclarationWithBody $receiver) {
        KtBlockExpression ktBlockExpression = this.blockExpression($receiver);
        if (ktBlockExpression == null) {
            return null;
        }
        KtBlockExpression body2 = ktBlockExpression;
        return this.findValueStatement(body2);
    }

    private final KtBlockExpression blockExpression(@NotNull KtDeclarationWithBody $receiver) {
        KtBlockExpression ktBlockExpression;
        KtDeclarationWithBody ktDeclarationWithBody = $receiver;
        if (ktDeclarationWithBody instanceof KtFunctionLiteral) {
            ktBlockExpression = null;
        } else if (!$receiver.hasBlockBody()) {
            ktBlockExpression = null;
        } else {
            KtExpression ktExpression = $receiver.getBodyExpression();
            if (!(ktExpression instanceof KtBlockExpression)) {
                ktExpression = null;
            }
            ktBlockExpression = (KtBlockExpression)ktExpression;
        }
        return ktBlockExpression;
    }

    private final KtExpression findValueStatement(@NotNull KtBlockExpression $receiver) {
        KtExpression statement2;
        List<KtExpression> bodyStatements = $receiver.getStatements();
        if (bodyStatements.isEmpty()) {
            return this.convertEmptyToUnit ? KtPsiFactoryKt.KtPsiFactory$default((PsiElement)$receiver, false, 2, null).createExpression("Unit") : null;
        }
        KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull(bodyStatements);
        if (ktExpression == null) {
            return null;
        }
        KtExpression ktExpression2 = statement2 = ktExpression;
        if (ktExpression2 instanceof KtReturnExpression) {
            return statement2;
        }
        if (ktExpression2 instanceof KtDeclaration || ktExpression2 instanceof KtLoopExpression) {
            return null;
        }
        if (statement2 instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)statement2).getOperationToken())) {
            return null;
        }
        BindingContext context = ResolutionUtils.analyze$default(statement2, null, 1, null);
        KotlinType kotlinType = context.getType(statement2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType expressionType = kotlinType;
        boolean isUnit = KotlinBuiltIns.isUnit(expressionType);
        if (!isUnit && !KotlinBuiltIns.isNothing(expressionType)) {
            return null;
        }
        if (isUnit) {
            boolean bl;
            block11: {
                if (UtilsKt.hasResultingIfWithoutElse(statement2)) {
                    return null;
                }
                List<KtWhenExpression> resultingWhens = UtilsKt.resultingWhens(statement2);
                Iterable $receiver$iv = resultingWhens;
                for (Object element$iv : $receiver$iv) {
                    KtWhenExpression it = (KtWhenExpression)element$iv;
                    if (!(it.getElseExpression() == null && Intrinsics.areEqual((Object)((Boolean)context.get(BindingContext.EXHAUSTIVE_WHEN, it)), (Object)true) ^ true)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
            if (bl) {
                return null;
            }
        }
        return statement2;
    }

    private final KtExpression getValue(@NotNull KtExpression $receiver) {
        KtExpression ktExpression = $receiver;
        KtExpression ktExpression2 = ktExpression instanceof KtReturnExpression ? ((KtReturnExpression)$receiver).getReturnedExpression() : null;
        if (ktExpression2 == null) {
            ktExpression2 = $receiver;
        }
        return ktExpression2;
    }

    private final PsiElement toHighlight(@NotNull KtExpression $receiver) {
        Object object;
        KtExpression ktExpression = $receiver;
        if (ktExpression instanceof KtReturnExpression) {
            object = ((KtReturnExpression)$receiver).getReturnKeyword();
        } else if (ktExpression instanceof KtCallExpression) {
            object = (PsiElement)((KtCallExpression)$receiver).getCalleeExpression();
        } else if (ktExpression instanceof KtQualifiedExpression) {
            KtExpression ktExpression2 = ((KtQualifiedExpression)$receiver).getSelectorExpression();
            object = ktExpression2 != null ? this.toHighlight(ktExpression2) : null;
        } else {
            object = ktExpression instanceof KtObjectLiteralExpression ? ((KtObjectLiteralExpression)$receiver).getObjectDeclaration().getObjectKeyword() : null;
        }
        return object;
    }

    public final void simplify(@NotNull KtDeclarationWithBody declaration2, boolean canDeleteTypeRef) {
        Function1 deleteTypeHandler2;
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Function1 function1 = deleteTypeHandler2 = (Function1)simplify.deleteTypeHandler.1.INSTANCE;
        KtDeclarationWithBody ktDeclarationWithBody = declaration2;
        UseExpressionBodyInspection useExpressionBodyInspection = this;
        Function1 it = function1;
        Function1 function12 = canDeleteTypeRef ? function1 : null;
        useExpressionBodyInspection.simplify(ktDeclarationWithBody, (Function1<? super KtCallableDeclaration, Unit>)function12);
    }

    private final void simplify(KtDeclarationWithBody declaration2, Function1<? super KtCallableDeclaration, Unit> deleteTypeHandler2) {
        Editor editor;
        KtExpression newBody;
        Object object;
        KtExpression body2;
        KotlinType valueType;
        Collection collection;
        KtBlockExpression ktBlockExpression = this.blockExpression(declaration2);
        if (ktBlockExpression == null) {
            return;
        }
        KtBlockExpression block = ktBlockExpression;
        KtExpression ktExpression = this.findValueStatement(block);
        if (ktExpression == null) {
            return;
        }
        KtExpression valueStatement = ktExpression;
        KtExpression value2 = this.getValue(valueStatement);
        if (!declaration2.hasDeclaredReturnType() && declaration2 instanceof KtNamedFunction && !(collection = (Collection)block.getStatements()).isEmpty() && ((valueType = ResolutionUtils.analyze$default(value2, null, 1, null).getType(value2)) == null || !KotlinBuiltIns.isUnit(valueType))) {
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)((Object)declaration2);
            String string = KotlinBuiltIns.FQ_NAMES.unit.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinBuiltIns.FQ_NAMES.unit.asString()");
            PsiModificationUtilsKt.setType(ktCallableDeclaration, string, true);
        }
        KtExpression ktExpression2 = declaration2.getBodyExpression();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktExpression3 = body2 = ktExpression2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"body");
        CommentSaver commentSaver = new CommentSaver((PsiElement)ktExpression3, false, 2, null);
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default(declaration2, false, 2, null);
        declaration2.addBefore(factory2.createEQ(), (PsiElement)body2);
        PsiElement $receiver$iv = (PsiElement)body2;
        PsiElement result$iv = $receiver$iv.replace((PsiElement)value2);
        if (result$iv instanceof KtExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement2 = result$iv;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            object = ((KtParenthesizedExpression)psiElement2).getExpression();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        }
        KtExpression ktExpression4 = newBody = (KtExpression)object;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"newBody");
        CommentSaver.restore$default(commentSaver, (PsiElement)ktExpression4, false, 2, null);
        if (deleteTypeHandler2 != null && declaration2 instanceof KtCallableDeclaration && declaration2.hasDeclaredReturnType() && org.jetbrains.kotlin.idea.core.UtilsKt.canOmitDeclaredType((KtCallableDeclaration)((Object)declaration2), newBody, true)) {
            deleteTypeHandler2.invoke((Object)declaration2);
        }
        if ((editor = IntentionBasedInspectionKt.findExistingEditor(declaration2)) != null) {
            int startOffset = PsiUtilsKt.getStartOffset((PsiElement)newBody);
            Document document = editor.getDocument();
            int startLine = document.getLineNumber(startOffset);
            int rightMargin = editor.getSettings().getRightMargin(editor.getProject());
            if (document.getLineEndOffset(startLine) - document.getLineStartOffset(startLine) >= rightMargin) {
                declaration2.addBefore(factory2.createNewLine(), (PsiElement)newBody);
            }
        }
    }

    public UseExpressionBodyInspection(boolean convertEmptyToUnit) {
        this.convertEmptyToUnit = convertEmptyToUnit;
    }

    public UseExpressionBodyInspection() {
        this(true);
    }

    @Nullable
    public static final /* synthetic */ Status access$statusFor(UseExpressionBodyInspection $this, @NotNull KtDeclarationWithBody declaration2) {
        return $this.statusFor(declaration2);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UseExpressionBodyInspection$Status;", "", "toHighlight", "Lcom/intellij/psi/PsiElement;", "subject", "", "highlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;)V", "getHighlightType", "()Lcom/intellij/codeInspection/ProblemHighlightType;", "getSubject", "()Ljava/lang/String;", "getToHighlight", "()Lcom/intellij/psi/PsiElement;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "idea"})
    private static final class Status {
        @Nullable
        private final PsiElement toHighlight;
        @NotNull
        private final String subject;
        @NotNull
        private final ProblemHighlightType highlightType;

        @Nullable
        public final PsiElement getToHighlight() {
            return this.toHighlight;
        }

        @NotNull
        public final String getSubject() {
            return this.subject;
        }

        @NotNull
        public final ProblemHighlightType getHighlightType() {
            return this.highlightType;
        }

        public Status(@Nullable PsiElement toHighlight, @NotNull String subject, @NotNull ProblemHighlightType highlightType) {
            Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
            Intrinsics.checkParameterIsNotNull((Object)highlightType, (String)"highlightType");
            this.toHighlight = toHighlight;
            this.subject = subject;
            this.highlightType = highlightType;
        }

        @Nullable
        public final PsiElement component1() {
            return this.toHighlight;
        }

        @NotNull
        public final String component2() {
            return this.subject;
        }

        @NotNull
        public final ProblemHighlightType component3() {
            return this.highlightType;
        }

        @NotNull
        public final Status copy(@Nullable PsiElement toHighlight, @NotNull String subject, @NotNull ProblemHighlightType highlightType) {
            Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
            Intrinsics.checkParameterIsNotNull((Object)highlightType, (String)"highlightType");
            return new Status(toHighlight, subject, highlightType);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Status copy$default(Status status2, PsiElement psiElement2, String string, ProblemHighlightType problemHighlightType, int n, Object object) {
            if ((n & 1) != 0) {
                psiElement2 = status2.toHighlight;
            }
            if ((n & 2) != 0) {
                string = status2.subject;
            }
            if ((n & 4) != 0) {
                problemHighlightType = status2.highlightType;
            }
            return status2.copy(psiElement2, string, problemHighlightType);
        }

        public String toString() {
            return "Status(toHighlight=" + this.toHighlight + ", subject=" + this.subject + ", highlightType=" + this.highlightType + ")";
        }

        public int hashCode() {
            PsiElement psiElement2 = this.toHighlight;
            String string = this.subject;
            ProblemHighlightType problemHighlightType = this.highlightType;
            return ((psiElement2 != null ? psiElement2.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (problemHighlightType != null ? problemHighlightType.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Status)) break block3;
                    Status status2 = (Status)object;
                    if (!Intrinsics.areEqual((Object)this.toHighlight, (Object)status2.toHighlight) || !Intrinsics.areEqual((Object)this.subject, (Object)status2.subject) || !Intrinsics.areEqual((Object)this.highlightType, (Object)status2.highlightType)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UseExpressionBodyInspection$ConvertToExpressionBodyFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lorg/jetbrains/kotlin/idea/inspections/UseExpressionBodyInspection;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    public final class ConvertToExpressionBodyFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return "Convert to expression body";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtDeclarationWithBody)) {
                psiElement2 = null;
            }
            KtDeclarationWithBody ktDeclarationWithBody = (KtDeclarationWithBody)psiElement2;
            if (ktDeclarationWithBody == null) {
                return;
            }
            KtDeclarationWithBody declaration2 = ktDeclarationWithBody;
            UseExpressionBodyInspection.this.simplify(declaration2, (Function1<? super KtCallableDeclaration, Unit>)applyFix.1.INSTANCE);
        }
    }
}

