/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.ConvertBinaryExpressionWithDemorgansLawIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertBinaryExpressionWithDemorgansLawIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "splitBooleanSequence", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "idea"})
public final class ConvertBinaryExpressionWithDemorgansLawIntention
extends SelfTargetingOffsetIndependentIntention<KtBinaryExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Object object = SequencesKt.last((Sequence)SequencesKt.takeWhile(PsiUtilsKt.getParentsWithSelf((PsiElement)element2), (Function1)isApplicableTo.expr.1.INSTANCE));
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        KtBinaryExpression expr2 = (KtBinaryExpression)object;
        IElementType iElementType = expr2.getOperationToken();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.ANDAND))) {
            string = "Replace '&&' with '||'";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.OROR))) {
            string = "Replace '||' with '&&'";
        } else {
            return false;
        }
        this.setText(string);
        return this.splitBooleanSequence(expr2) != null;
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        this.applyTo(element2);
    }

    public final void applyTo(@NotNull KtBinaryExpression element2) {
        boolean negated;
        KtExpression ktExpression;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Object object = SequencesKt.last((Sequence)SequencesKt.takeWhile(PsiUtilsKt.getParentsWithSelf((PsiElement)element2), (Function1)applyTo.expr.1.INSTANCE));
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        KtBinaryExpression expr2 = (KtBinaryExpression)object;
        IElementType iElementType = expr2.getOperationToken();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.ANDAND))) {
            string = KtTokens.OROR.getValue();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.OROR))) {
            string = KtTokens.ANDAND.getValue();
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        String operatorText = string;
        List<KtExpression> list2 = this.splitBooleanSequence(expr2);
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        List operands = CollectionsKt.asReversed(list2);
        KtExpression newExpression2 = CreateByPatternKt.buildExpression(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expr2, false, 2, null), (Function1<? super BuilderByPattern<KtExpression>, Unit>)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(operands, operatorText){
            final /* synthetic */ List $operands;
            final /* synthetic */ String $operatorText;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                Collection<KtExpression> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Iterable iterable = this.$operands;
                BuilderByPattern<KtExpression> builderByPattern = $receiver;
                void var3_4 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    KtExpression ktExpression = (KtExpression)item$iv$iv;
                    collection = destination$iv$iv;
                    KtExpression ktExpression2 = UtilsKt.negate((KtExpression)it);
                    collection.add(ktExpression2);
                }
                collection = (List)destination$iv$iv;
                Iterable iterable2 = collection;
                String string = this.$operatorText;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"operatorText");
                builderByPattern.appendExpressions(iterable2, string);
            }
            {
                this.$operands = list2;
                this.$operatorText = string;
                super(1);
            }
        }));
        PsiElement psiElement2 = expr2.getParent().getParent();
        if (!(psiElement2 instanceof KtPrefixExpression)) {
            psiElement2 = null;
        }
        KtPrefixExpression grandParentPrefix = (KtPrefixExpression)psiElement2;
        boolean bl = expr2.getParent() instanceof KtParenthesizedExpression && Intrinsics.areEqual((Object)((ktExpression = grandParentPrefix) != null && (ktExpression = ((KtUnaryExpression)ktExpression).getOperationReference()) != null ? ktExpression.getReferencedNameElementType() : null), (Object)((Object)KtTokens.EXCL)) ? true : (negated = false);
        if (negated) {
            KtPrefixExpression ktPrefixExpression = grandParentPrefix;
            if (ktPrefixExpression != null) {
                ktPrefixExpression.replace((PsiElement)newExpression2);
            }
        } else {
            expr2.replace((PsiElement)UtilsKt.negate(newExpression2));
        }
    }

    private final List<KtExpression> splitBooleanSequence(KtBinaryExpression expression2) {
        IElementType operation;
        ArrayList<KtExpression> result2 = new ArrayList<KtExpression>();
        IElementType firstOperator = expression2.getOperationToken();
        KtExpression remainingExpression = expression2;
        while (!(!(remainingExpression instanceof KtBinaryExpression) || Intrinsics.areEqual((Object)(operation = ((KtBinaryExpression)remainingExpression).getOperationToken()), (Object)((Object)KtTokens.ANDAND)) ^ true && Intrinsics.areEqual((Object)operation, (Object)((Object)KtTokens.OROR)) ^ true)) {
            if (Intrinsics.areEqual((Object)operation, (Object)firstOperator) ^ true) {
                return null;
            }
            KtExpression ktExpression = ((KtBinaryExpression)remainingExpression).getRight();
            if (ktExpression == null) {
                return null;
            }
            result2.add(ktExpression);
            if (((KtBinaryExpression)remainingExpression).getLeft() != null) continue;
            return null;
        }
        result2.add(remainingExpression);
        return result2;
    }

    public ConvertBinaryExpressionWithDemorgansLawIntention() {
        super(KtBinaryExpression.class, "DeMorgan Law", null, 4, null);
    }
}

