/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ReplaceArrayEqualityOpWithArraysEqualsIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "idea"})
public final class ReplaceArrayEqualityOpWithArraysEqualsIntention
extends SelfTargetingOffsetIndependentIntention<KtBinaryExpression> {
    @Override
    public void applyTo(@NotNull KtBinaryExpression element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Project project = element2.getProject();
        KtExpression ktExpression = element2.getRight();
        if (ktExpression == null) {
            return;
        }
        KtExpression right = ktExpression;
        KtExpression ktExpression2 = element2.getLeft();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression left = ktExpression2;
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
        KtFile ktFile = element2.getContainingKtFile();
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)ResolutionUtils.resolveImportReference(ktFile, new FqName("java.util.Arrays")));
        if (declarationDescriptor != null) {
            DeclarationDescriptor declarationDescriptor2;
            DeclarationDescriptor it = declarationDescriptor2 = declarationDescriptor;
            ImportInsertHelper importInsertHelper = ImportInsertHelper.Companion.getInstance(project);
            KtFile ktFile2 = ktFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile2, (String)"ktFile");
            ImportInsertHelper.importDescriptor$default(importInsertHelper, ktFile2, it, false, 4, null);
        }
        KtExpression expression2 = factory2.createExpression("Arrays.equals(" + left.getText() + ", " + right.getText() + ')');
        element2.replace((PsiElement)expression2);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (Intrinsics.areEqual((Object)element2.getOperationToken(), (Object)((Object)KtTokens.EQEQ)) ^ true) {
            return false;
        }
        KtExpression ktExpression = element2.getRight();
        if (ktExpression == null) {
            return false;
        }
        KtExpression right = ktExpression;
        KtExpression ktExpression2 = element2.getLeft();
        if (ktExpression2 == null) {
            return false;
        }
        KtExpression left = ktExpression2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(right, ResolutionUtils.analyze$default(right, null, 1, null));
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> rightResolvedCall = resolvedCall2;
        if (!UtilsKt.resolvedToArrayType(rightResolvedCall)) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(left, ResolutionUtils.analyze$default(left, null, 1, null));
        if (resolvedCall3 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> leftResolvedCall = resolvedCall3;
        return UtilsKt.resolvedToArrayType(leftResolvedCall);
    }

    public ReplaceArrayEqualityOpWithArraysEqualsIntention() {
        super(KtBinaryExpression.class, "Replace '==' with 'Arrays.equals'", null, 4, null);
    }
}

