/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0002H$J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0004J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0004J\f\u0010\u0010\u001a\u00020\f*\u00020\u0002H\u0004J\u0014\u0010\u0011\u001a\u00020\f*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000eH\u0004\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ReplaceSubstringIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "text", "", "(Ljava/lang/String;)V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applicabilityRangeInner", "getTextRange", "isIndexOfCall", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expectedReceiver", "isFirstArgumentZero", "isMethodCall", "fqMethodName", "replaceWith", "", "pattern", "argument", "idea"})
public abstract class ReplaceSubstringIntention
extends SelfTargetingRangeIntention<KtDotQualifiedExpression> {
    @Nullable
    protected abstract TextRange applicabilityRangeInner(@NotNull KtDotQualifiedExpression var1);

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtDotQualifiedExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (IfThenUtilsKt.isStable$default(element2.getReceiverExpression(), null, 1, null) && this.isMethodCall(element2, "kotlin.text.substring")) {
            return this.applicabilityRangeInner(element2);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean isIndexOfCall(@Nullable KtExpression expression2, @NotNull KtExpression expectedReceiver) {
        Intrinsics.checkParameterIsNotNull((Object)expectedReceiver, (String)"expectedReceiver");
        if (!(expression2 instanceof KtDotQualifiedExpression)) return false;
        if (!this.isMethodCall((KtDotQualifiedExpression)expression2, "kotlin.text.indexOf")) return false;
        if (!IfThenUtilsKt.evaluatesTo(((KtDotQualifiedExpression)expression2).getReceiverExpression(), expectedReceiver)) return false;
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression((KtQualifiedExpression)expression2);
        if (ktCallExpression == null) {
            Intrinsics.throwNpe();
        }
        if (ktCallExpression.getValueArguments().size() != 1) return false;
        return true;
    }

    private final boolean isMethodCall(@NotNull KtDotQualifiedExpression $receiver, String fqMethodName) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = UtilsKt.toResolvedCall($receiver, BodyResolveMode.PARTIAL);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(resolvedCall3.getResultingDescriptor()).asString(), (Object)fqMethodName);
    }

    protected final boolean isFirstArgumentZero(@NotNull KtDotQualifiedExpression $receiver) {
        KotlinType constantType;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BindingContext bindingContext2 = ResolutionUtils.analyze$default($receiver, null, 1, null);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(UtilsKt.getCallExpression($receiver), bindingContext2);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        KtExpression ktExpression = resolvedCall3.getCall().getValueArguments().get(0).getArgumentExpression();
        if (!(ktExpression instanceof KtConstantExpression)) {
            ktExpression = null;
        }
        KtConstantExpression ktConstantExpression = (KtConstantExpression)ktExpression;
        if (ktConstantExpression == null) {
            return false;
        }
        KtConstantExpression expression2 = ktConstantExpression;
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext2);
        if (compileTimeConstant == null) {
            return false;
        }
        CompileTimeConstant<?> constant = compileTimeConstant;
        KotlinType kotlinType = bindingContext2.getType(expression2);
        if (kotlinType == null) {
            return false;
        }
        KotlinType kotlinType2 = constantType = kotlinType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"constantType");
        return Intrinsics.areEqual(constant.getValue(kotlinType2), (Object)0);
    }

    @Nullable
    protected final TextRange getTextRange(@NotNull KtDotQualifiedExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element2);
        return ktCallExpression != null ? ktCallExpression.getTextRange() : null;
    }

    protected final void replaceWith(@NotNull KtDotQualifiedExpression $receiver, @NotNull String pattern, @NotNull KtExpression argument2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)$receiver, false, 2, null);
        $receiver.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(psiFactory, pattern, new Object[]{$receiver.getReceiverExpression(), argument2}, false, 4, null));
    }

    public ReplaceSubstringIntention(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        super(KtDotQualifiedExpression.class, text2, null, 4, null);
    }
}

