/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.SwapBinaryExpressionIntention;
import org.jetbrains.kotlin.idea.util.PsiPrecedences;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J7\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0019\u0010\u000f\u001a\u0015\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0010\u00a2\u0006\u0002\b\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SwapBinaryExpressionIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "firstDescendantOfTighterPrecedence", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "precedence", "", "getChild", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "isApplicableTo", "", "caretOffset", "leftSubject", "rightSubject", "Companion", "idea"})
public final class SwapBinaryExpressionIntention
extends SelfTargetingIntention<KtBinaryExpression>
implements LowPriorityAction {
    private static final Set<KtSingleValueToken> SUPPORTED_OPERATIONS;
    private static final Set<String> SUPPORTED_OPERATION_NAMES;
    public static final Companion Companion;

    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtOperationReferenceExpression opRef = element2.getOperationReference();
        if (!opRef.getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        if (this.leftSubject(element2) == null || this.rightSubject(element2) == null) {
            return false;
        }
        IElementType operationToken = element2.getOperationToken();
        String operationTokenText = opRef.getText();
        if (CollectionsKt.contains((Iterable)SwapBinaryExpressionIntention.Companion.getSUPPORTED_OPERATIONS(), (Object)operationToken) || Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.IDENTIFIER)) && SwapBinaryExpressionIntention.Companion.getSUPPORTED_OPERATION_NAMES().contains(operationTokenText)) {
            this.setText("Flip '" + operationTokenText + '\'');
            return true;
        }
        return false;
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element2, @Nullable Editor editor) {
        String string;
        String operator;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        String string2 = element2.getOperationReference().getText();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        switch (operator = string2) {
            case ">": {
                string = "<";
                break;
            }
            case "<": {
                string = ">";
                break;
            }
            case "<=": {
                string = ">=";
                break;
            }
            case ">=": {
                string = "<=";
                break;
            }
            default: {
                string = operator;
            }
        }
        String convertedOperator = string;
        KtExpression ktExpression = this.leftSubject(element2);
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = this.rightSubject(element2);
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        KtExpression right = ktExpression2;
        KtExpression rightCopy = (KtExpression)PsiModificationUtilsKt.copied((PsiElement)right);
        KtExpression leftCopy = (KtExpression)PsiModificationUtilsKt.copied((PsiElement)left);
        left.replace((PsiElement)rightCopy);
        right.replace((PsiElement)leftCopy);
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element2, false, 2, null);
        String string3 = "$0 " + convertedOperator + " $1";
        Object[] objectArray = new Object[2];
        KtExpression ktExpression3 = element2.getLeft();
        if (ktExpression3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"element.left!!");
        objectArray[0] = ktExpression3;
        KtExpression ktExpression4 = element2.getRight();
        if (ktExpression4 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"element.right!!");
        objectArray[1] = ktExpression4;
        element2.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, string3, objectArray, false, 4, null));
    }

    private final KtExpression leftSubject(KtBinaryExpression element2) {
        return this.firstDescendantOfTighterPrecedence(element2.getLeft(), PsiPrecedences.INSTANCE.getPrecedence(element2), (Function1<? super KtBinaryExpression, ? extends KtExpression>)((Function1)leftSubject.1.INSTANCE));
    }

    private final KtExpression rightSubject(KtBinaryExpression element2) {
        return this.firstDescendantOfTighterPrecedence(element2.getRight(), PsiPrecedences.INSTANCE.getPrecedence(element2), (Function1<? super KtBinaryExpression, ? extends KtExpression>)((Function1)rightSubject.1.INSTANCE));
    }

    private final KtExpression firstDescendantOfTighterPrecedence(KtExpression expression2, int precedence, Function1<? super KtBinaryExpression, ? extends KtExpression> getChild) {
        int expressionPrecedence;
        if (expression2 instanceof KtBinaryExpression && !PsiPrecedences.INSTANCE.isTighter(expressionPrecedence = PsiPrecedences.INSTANCE.getPrecedence(expression2), precedence)) {
            return this.firstDescendantOfTighterPrecedence((KtExpression)getChild.invoke((Object)expression2), precedence, getChild);
        }
        return expression2;
    }

    public SwapBinaryExpressionIntention() {
        super(KtBinaryExpression.class, "Flip binary expression", null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_2;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Companion = new Companion(null);
        SUPPORTED_OPERATIONS = SetsKt.setOf((Object[])new KtSingleValueToken[]{KtTokens.PLUS, KtTokens.MUL, KtTokens.OROR, KtTokens.ANDAND, KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, KtTokens.GT, KtTokens.LT, KtTokens.GTEQ, KtTokens.LTEQ});
        Iterable iterable = $receiver$iv = (Iterable)SwapBinaryExpressionIntention.Companion.getSUPPORTED_OPERATIONS();
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            KtSingleValueToken it = (KtSingleValueToken)((Object)element$iv$iv);
            Name name2 = (Name)OperatorConventions.BINARY_OPERATION_NAMES.get((Object)it);
            String string2 = name2 != null ? name2.asString() : null;
            if (string2 == null) continue;
            String it$iv$iv = string = string2;
            destination$iv$iv.add(it$iv$iv);
        }
        SUPPORTED_OPERATION_NAMES = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((List)var2_2)), (Iterable)SetsKt.setOf((Object[])new String[]{"xor", "or", "and", "equals"}));
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SwapBinaryExpressionIntention$Companion;", "", "()V", "SUPPORTED_OPERATIONS", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "getSUPPORTED_OPERATIONS", "()Ljava/util/Set;", "SUPPORTED_OPERATION_NAMES", "", "getSUPPORTED_OPERATION_NAMES", "idea"})
    public static final class Companion {
        private final Set<KtSingleValueToken> getSUPPORTED_OPERATIONS() {
            return SUPPORTED_OPERATIONS;
        }

        private final Set<String> getSUPPORTED_OPERATION_NAMES() {
            return SUPPORTED_OPERATION_NAMES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

