/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/branchedTransformations/intentions/ElvisToIfThenIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
public final class ElvisToIfThenIntention
extends SelfTargetingRangeIntention<KtBinaryExpression>
implements LowPriorityAction {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtBinaryExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return Intrinsics.areEqual((Object)element2.getOperationToken(), (Object)((Object)KtTokens.ELVIS)) && element2.getLeft() != null && element2.getRight() != null ? element2.getOperationReference().getTextRange() : null;
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression = element2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression left = KtPsiUtil.safeDeparenthesize(ktExpression);
        KtExpression ktExpression2 = element2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        KtExpression right = KtPsiUtil.safeDeparenthesize(ktExpression2);
        boolean leftIsStable = IfThenUtilsKt.isStable$default(left, null, 1, null);
        KtExpression ktExpression3 = element2;
        KtExpression ktExpression4 = left;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"left");
        KtIfExpression ifStatement = IfThenUtilsKt.convertToIfNotNullExpression(ktExpression3, ktExpression4, left, right);
        if (!leftIsStable) {
            KtExpression ktExpression5 = ifStatement.getThen();
            if (ktExpression5 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression5, (String)"ifStatement.then!!");
            IfThenUtilsKt.introduceValueForCondition(ifStatement, ktExpression5, editor);
        }
    }

    public ElvisToIfThenIntention() {
        super(KtBinaryExpression.class, "Replace elvis expression with 'if' expression", null, 4, null);
    }
}

