/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\u0016\u0010\u0012\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0002J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddLoopLabelFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "loop", "jumpExpression", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "(Lorg/jetbrains/kotlin/psi/KtLoopExpression;Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;)V", "description", "", "existingLabelName", "getJumpExpression", "()Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "collectUsedLabels", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getFamilyName", "getText", "getUniqueLabelName", "existingNames", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Lcom/intellij/psi/PsiFile;", "Companion", "idea"})
public final class AddLoopLabelFix
extends KotlinQuickFixAction<KtLoopExpression> {
    private final String existingLabelName;
    private final String description;
    @NotNull
    private final KtExpressionWithLabel jumpExpression;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return this.description;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return super.isAvailable(project, editor, file2);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtLoopExpression ktLoopExpression = (KtLoopExpression)this.getElement();
        if (ktLoopExpression == null) {
            return;
        }
        KtLoopExpression element2 = ktLoopExpression;
        String string = this.existingLabelName;
        if (string == null) {
            string = this.getUniqueLabelName((Collection<String>)this.collectUsedLabels(element2));
        }
        String labelName = string;
        KtExpression jumpWithLabel = new KtPsiFactory(project, false, 2, null).createExpression(this.jumpExpression.getText() + "@" + labelName);
        this.jumpExpression.replace((PsiElement)jumpWithLabel);
        if (this.existingLabelName == null) {
            KtLabeledExpression labeledLoopExpression = new KtPsiFactory(project, false, 2, null).createLabeledExpression(labelName);
            KtExpression ktExpression = labeledLoopExpression.getBaseExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            ktExpression.replace((PsiElement)element2);
            element2.replace((PsiElement)labeledLoopExpression);
        }
    }

    private final Set<String> collectUsedLabels(KtElement element2) {
        HashSet<String> usedLabels = new HashSet<String>();
        element2.acceptChildren(new KtTreeVisitorVoid(usedLabels){
            final /* synthetic */ HashSet $usedLabels;

            public void visitLabeledExpression(@NotNull KtLabeledExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitLabeledExpression(expression2);
                String string = expression2.getLabelName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                this.$usedLabels.add(string);
            }
            {
                this.$usedLabels = $captured_local_variable$0;
            }
        });
        Sequence<PsiElement> $receiver$iv = PsiUtilsKt.getParents((PsiElement)element2);
        for (Object element$iv : $receiver$iv) {
            PsiElement it = (PsiElement)element$iv;
            if (!(it instanceof KtLabeledExpression)) continue;
            String string = ((KtLabeledExpression)it).getLabelName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            usedLabels.add(string);
        }
        return usedLabels;
    }

    private final String getUniqueLabelName(Collection<String> existingNames) {
        int index2 = 0;
        String result2 = "loop";
        while (existingNames.contains(result2)) {
            result2 = "loop" + ++index2;
        }
        return result2;
    }

    @NotNull
    public final KtExpressionWithLabel getJumpExpression() {
        return this.jumpExpression;
    }

    public AddLoopLabelFix(@NotNull KtLoopExpression loop, @NotNull KtExpressionWithLabel jumpExpression) {
        Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
        Intrinsics.checkParameterIsNotNull((Object)jumpExpression, (String)"jumpExpression");
        super((PsiElement)loop);
        this.jumpExpression = jumpExpression;
        PsiElement psiElement2 = loop.getParent();
        if (!(psiElement2 instanceof KtLabeledExpression)) {
            psiElement2 = null;
        }
        KtLabeledExpression ktLabeledExpression = (KtLabeledExpression)psiElement2;
        this.existingLabelName = ktLabeledExpression != null ? ktLabeledExpression.getLabelName() : null;
        this.description = this.existingLabelName != null ? "Add '@" + this.existingLabelName + "' to " + this.jumpExpression.getText() : "Add label to loop";
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddLoopLabelFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            PsiElement $receiver$iv;
            KtExpressionWithLabel element2;
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtExpressionWithLabel)) {
                psiElement2 = null;
            }
            boolean bl2 = bl = (element2 = (KtExpressionWithLabel)psiElement2) instanceof KtBreakExpression || element2 instanceof KtContinueExpression;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            KtExpressionWithLabel ktExpressionWithLabel = element2;
            if (!(ktExpressionWithLabel instanceof KtLabeledExpression)) {
                ktExpressionWithLabel = null;
            }
            KtLabeledExpression ktLabeledExpression = (KtLabeledExpression)ktExpressionWithLabel;
            boolean bl3 = bl = (ktLabeledExpression != null ? ktLabeledExpression.getLabelName() : null) == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            KtExpressionImpl ktExpressionImpl = element2;
            if (ktExpressionImpl == null || (ktExpressionImpl = (KtLoopExpression)PsiTreeUtil.getParentOfType((PsiElement)($receiver$iv = (PsiElement)ktExpressionImpl), KtLoopExpression.class, (boolean)true)) == null) {
                return null;
            }
            KtExpressionImpl loop = ktExpressionImpl;
            return new AddLoopLabelFix((KtLoopExpression)loop, element2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

