/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveSingleLambdaParameterFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "element", "(Lorg/jetbrains/kotlin/psi/KtParameter;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class RemoveSingleLambdaParameterFix
extends KotlinQuickFixAction<KtParameter> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return "Remove single lambda parameter declaration";
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtParameter ktParameter = (KtParameter)this.getElement();
        if (ktParameter == null) {
            return;
        }
        KtParameter element2 = ktParameter;
        PsiElement psiElement2 = element2.getParent();
        if (!(psiElement2 instanceof KtParameterList)) {
            psiElement2 = null;
        }
        KtParameterList ktParameterList = (KtParameterList)psiElement2;
        if (ktParameterList == null) {
            return;
        }
        KtParameterList parameterList2 = ktParameterList;
        KtDeclarationWithBody ktDeclarationWithBody = parameterList2.getOwnerFunction();
        if (ktDeclarationWithBody == null) {
            return;
        }
        KtDeclarationWithBody ownerFunction = ktDeclarationWithBody;
        ASTNode aSTNode = ownerFunction.getNode().findChildByType((IElementType)KtTokens.ARROW);
        if (aSTNode == null) {
            return;
        }
        ASTNode arrow = aSTNode;
        parameterList2.delete();
        ownerFunction.getNode().removeChild(arrow);
    }

    public RemoveSingleLambdaParameterFix(@NotNull KtParameter element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super((PsiElement)element2);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveSingleLambdaParameterFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtParameter)) {
                psiElement2 = null;
            }
            KtParameter ktParameter = (KtParameter)psiElement2;
            if (ktParameter == null) {
                return null;
            }
            KtParameter parameter = ktParameter;
            PsiElement psiElement3 = parameter.getParent();
            if (!(psiElement3 instanceof KtParameterList)) {
                psiElement3 = null;
            }
            KtParameterList ktParameterList = (KtParameterList)psiElement3;
            if (ktParameterList == null) {
                return null;
            }
            KtParameterList parameterList2 = ktParameterList;
            if (parameterList2.getParameters().size() != 1) {
                return null;
            }
            if (!(parameterList2.getParent().getParent() instanceof KtLambdaExpression)) {
                return null;
            }
            return new RemoveSingleLambdaParameterFix(parameter);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

