/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.fqName;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u001c\u0010\u0003\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u001a\u001a\u0010\u0003\u001a\u00020\u0004*\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0002\u001a&\u0010\u0003\u001a\u00020\u0004*\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"getKotlinFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lcom/intellij/psi/PsiElement;", "isImported", "", "importPath", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "skipAliasedImports", "imports", "", "excludedFqNames", "alreadyImported", "idea-analysis"})
public final class FqNameUtilKt {
    @Nullable
    public static final FqName getKotlinFqName(@NotNull PsiElement $receiver) {
        FqName fqName2;
        PsiNamedElement element2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiNamedElement psiNamedElement = element2 = LightClassUtilsKt.getNamedUnwrappedElement($receiver);
        if (psiNamedElement instanceof PsiPackage) {
            fqName2 = new FqName(((PsiPackage)element2).getQualifiedName());
        } else if (psiNamedElement instanceof PsiClass) {
            String string = ((PsiClass)element2).getQualifiedName();
            if (string != null) {
                String string2;
                String p1 = string2 = string;
                fqName2 = new FqName(p1);
            } else {
                fqName2 = null;
            }
        } else if (psiNamedElement instanceof PsiMember) {
            String string = element2.getName();
            if (string != null) {
                String string3;
                String prefix;
                String string4;
                String name2 = string4 = string;
                PsiClass psiClass2 = ((PsiMember)element2).getContainingClass();
                String string5 = prefix = psiClass2 != null ? psiClass2.getQualifiedName() : null;
                if (prefix != null) {
                    string3 = "" + prefix + '.' + name2;
                } else {
                    String string6 = name2;
                    string3 = string6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"name");
                }
                fqName2 = new FqName(string3);
            } else {
                fqName2 = null;
            }
        } else {
            fqName2 = psiNamedElement instanceof KtNamedDeclaration ? ((KtNamedDeclaration)element2).getFqName() : null;
        }
        return fqName2;
    }

    public static final boolean isImported(@NotNull FqName $receiver, @NotNull ImportPath importPath, boolean skipAliasedImports) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)importPath, (String)"importPath");
        return skipAliasedImports && importPath.hasAlias() ? false : (importPath.isAllUnder() && !$receiver.isRoot() ? Intrinsics.areEqual((Object)importPath.getFqName(), (Object)$receiver.parent()) : Intrinsics.areEqual((Object)importPath.getFqName(), (Object)$receiver));
    }

    public static /* bridge */ /* synthetic */ boolean isImported$default(FqName fqName2, ImportPath importPath, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return FqNameUtilKt.isImported(fqName2, importPath, bl);
    }

    public static final boolean isImported(@NotNull ImportPath $receiver, @NotNull ImportPath alreadyImported) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)alreadyImported, (String)"alreadyImported");
        return $receiver.isAllUnder() || $receiver.hasAlias() ? Intrinsics.areEqual((Object)$receiver, (Object)alreadyImported) : FqNameUtilKt.isImported$default($receiver.getFqName(), alreadyImported, false, 2, null);
    }

    private static final boolean isImported(@NotNull ImportPath $receiver, Iterable<ImportPath> imports) {
        boolean bl;
        block1: {
            Iterable<ImportPath> $receiver$iv = imports;
            for (ImportPath element$iv : $receiver$iv) {
                ImportPath it = element$iv;
                if (!FqNameUtilKt.isImported($receiver, it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isImported(@NotNull ImportPath $receiver, @NotNull Iterable<ImportPath> imports, @NotNull Iterable<FqName> excludedFqNames) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(imports, (String)"imports");
        Intrinsics.checkParameterIsNotNull(excludedFqNames, (String)"excludedFqNames");
        return FqNameUtilKt.isImported($receiver, imports) && ($receiver.isAllUnder() || CollectionsKt.contains(excludedFqNames, (Object)$receiver.getFqName()) ^ true);
    }
}

