/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.changePackage;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.changePackage.KotlinChangePackageRefactoring;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/changePackage/ChangePackageToMatchDirectoryIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "idea"})
public final class ChangePackageToMatchDirectoryIntention
extends SelfTargetingOffsetIndependentIntention<KtPackageDirective> {
    @Override
    public boolean isApplicableTo(@NotNull KtPackageDirective element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtFile file2 = element2.getContainingKtFile();
        if (KotlinRefactoringUtilKt.isInjectedFragment((PsiFile)file2) || PackageUtilsKt.packageMatchesDirectory(file2)) {
            return false;
        }
        FqName fqNameByDirectory = PackageUtilsKt.getFqNameByDirectory((PsiFile)file2);
        this.setText(!KotlinRefactoringUtilKt.hasIdentifiersOnly(fqNameByDirectory) ? "File package doesn't match directory (cannot fix)" : "Change file's package to '" + fqNameByDirectory.asString() + '\'');
        return true;
    }

    @Override
    public void applyTo(@NotNull KtPackageDirective element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtFile file2 = element2.getContainingKtFile();
        FqName newFqName = PackageUtilsKt.getFqNameByDirectory((PsiFile)file2);
        if (!KotlinRefactoringUtilKt.hasIdentifiersOnly(newFqName)) {
            return;
        }
        KtFile ktFile = file2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"file");
        new KotlinChangePackageRefactoring(ktFile).run(newFqName);
    }

    public ChangePackageToMatchDirectoryIntention() {
        super(KtPackageDirective.class, "", "Change file's package to match directory");
    }
}

