/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearchRequest;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticParameterRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "element", "Lorg/jetbrains/kotlin/psi/KtParameter;", "newName", "", "(Lorg/jetbrains/kotlin/psi/KtParameter;Ljava/lang/String;)V", "entityName", "getDialogDescription", "getDialogTitle", "isSelectedByDefault", "", "processHierarchy", "", "idea"})
public final class AutomaticParameterRenamer
extends AutomaticRenamer {
    private final void processHierarchy(KtParameter element2, String newName2) {
        KtDeclarationWithBody ktDeclarationWithBody = element2.getOwnerFunction();
        if (ktDeclarationWithBody == null) {
            return;
        }
        KtDeclarationWithBody function2 = ktDeclarationWithBody;
        PsiElement psiElement2 = function2;
        SearchScope searchScope2 = function2.getUseScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"function.useScope");
        for (PsiMethod overrider : OverridersSearchKt.searchOverriders(new HierarchySearchRequest(psiElement2, searchScope2, false, 4, null))) {
            PsiNamedElement parameter;
            PsiNamedElement psiNamedElement;
            KtParameter it;
            Object[] $receiver$iv;
            PsiNamedElement callable2;
            if (LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)overrider) == null) {
                continue;
            }
            if (!KotlinRefactoringUtilKt.canRefactor((PsiElement)callable2)) continue;
            Object object = callable2;
            if (object instanceof KtCallableDeclaration) {
                Object v3;
                block9: {
                    $receiver$iv = (Object[])((KtCallableDeclaration)callable2).getValueParameters();
                    for (Object element$iv : $receiver$iv) {
                        it = (KtParameter)element$iv;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)element2.getName())) continue;
                        v3 = element$iv;
                        break block9;
                    }
                    v3 = null;
                }
                psiNamedElement = v3;
            } else if (object instanceof PsiMethod) {
                Object v5;
                block10: {
                    $receiver$iv = ((PsiMethod)callable2).getParameterList().getParameters();
                    for (int i = 0; i < $receiver$iv.length; ++i) {
                        Object element$iv;
                        element$iv = $receiver$iv[i];
                        it = (PsiParameter)element$iv;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)element2.getName())) continue;
                        v5 = element$iv;
                        break block10;
                    }
                    v5 = null;
                }
                psiNamedElement = v5;
            } else {
                psiNamedElement = parameter = null;
            }
            if (parameter == null) continue;
            object = this.myElements;
            object.add(parameter);
        }
        this.suggestAllNames(element2.getName(), UtilsKt.quoteIfNeeded(newName2));
    }

    @NotNull
    public String getDialogTitle() {
        return "Rename Parameters";
    }

    @NotNull
    public String getDialogDescription() {
        return "Rename parameter in hierarchy to:";
    }

    @NotNull
    public String entityName() {
        return "Parameter";
    }

    public boolean isSelectedByDefault() {
        return true;
    }

    public AutomaticParameterRenamer(@NotNull KtParameter element2, @NotNull String newName2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)newName2, (String)"newName");
        this.processHierarchy(element2, newName2);
    }
}

