/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.spring.inspections;

import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.model.jam.stereotype.SpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.transaction.SpringTransactionalComponent;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.spring.SpringUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/spring/inspections/KotlinFinalClassOrFunSpringInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMessage", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "QuickFix", "kotlin-ultimate"})
public final class KotlinFinalClassOrFunSpringInspection
extends AbstractKotlinInspection {
    private final String getMessage(KtNamedDeclaration declaration2) {
        KtNamedDeclaration ktNamedDeclaration = declaration2;
        if (ktNamedDeclaration instanceof KtClassOrObject) {
            String string;
            KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)declaration2);
            if (ktLightClass == null) {
                return null;
            }
            KtLightClass lightClass2 = ktLightClass;
            if (SpringConfiguration.META.getJamElement((PsiModifierListOwner)lightClass2) != null) {
                string = "@Configuration";
            } else if (SpringComponent.META.getJamElement((PsiModifierListOwner)lightClass2) != null) {
                string = "@Component";
            } else if (SpringTransactionalComponent.META.getJamElement((PsiModifierListOwner)lightClass2) != null) {
                string = "@Transactional";
            } else {
                return null;
            }
            String annotation2 = string;
            return declaration2 instanceof KtClass ? "" + annotation2 + " class should be declared open" : "" + annotation2 + " should not be applied to object declaration ";
        }
        if (ktNamedDeclaration instanceof KtNamedFunction) {
            PsiMethod psiMethod2 = (PsiMethod)CollectionsKt.firstOrNull(LightClassUtilsKt.toLightMethods(declaration2));
            if (psiMethod2 == null) {
                return null;
            }
            PsiMethod lightMethod = psiMethod2;
            if (SpringUtilsKt.isAnnotatedWith((PsiModifierListOwner)lightMethod, "org.springframework.context.annotation.Bean")) {
                return "@Bean function should be declared open";
            }
            if (SpringUtilsKt.isAnnotatedWith((PsiModifierListOwner)lightMethod, "org.springframework.transaction.annotation.Transactional")) {
                return "@Transactional function should be declared open";
            }
        }
        return null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(this, holder){
            final /* synthetic */ KotlinFinalClassOrFunSpringInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            private final boolean isOpen(@NotNull KtNamedDeclaration $receiver) {
                MemberDescriptor descriptor2;
                DeclarationDescriptor declarationDescriptor;
                KtNamedDeclaration ktNamedDeclaration = $receiver;
                if (ktNamedDeclaration instanceof KtClass) {
                    if (PsiModificationUtilsKt.isInheritable((KtClass)$receiver)) {
                        return true;
                    }
                } else {
                    if (ktNamedDeclaration instanceof KtObjectDeclaration) {
                        return false;
                    }
                    if (ktNamedDeclaration instanceof KtNamedFunction) {
                        if (PsiModificationUtilsKt.isOverridable($receiver)) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                if (!((declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default($receiver, null, 1, null)) instanceof MemberDescriptor)) {
                    declarationDescriptor = null;
                }
                MemberDescriptor memberDescriptor = descriptor2 = (MemberDescriptor)declarationDescriptor;
                return Intrinsics.areEqual((Object)((Object)(memberDescriptor != null ? memberDescriptor.getModality() : null)), (Object)((Object)Modality.FINAL)) ^ true;
            }

            public void visitNamedDeclaration(@NotNull KtNamedDeclaration declaration2) {
                PsiElement psiElement2;
                LocalQuickFix[] fixes2;
                LocalQuickFix[] localQuickFixArray;
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                if (this.isOpen(declaration2)) {
                    return;
                }
                String string = KotlinFinalClassOrFunSpringInspection.access$getMessage(this.this$0, declaration2);
                if (string == null) {
                    return;
                }
                String message2 = string;
                if (!(declaration2 instanceof KtObjectDeclaration)) {
                    Object[] elements$iv = new QuickFix[]{new QuickFix<KtModifierListOwner>(declaration2)};
                    localQuickFixArray = (LocalQuickFix[])elements$iv;
                } else {
                    localQuickFixArray = fixes2 = LocalQuickFix.EMPTY_ARRAY;
                }
                if ((psiElement2 = declaration2.getNameIdentifier()) == null) {
                    psiElement2 = declaration2;
                }
                this.$holder.registerProblem(psiElement2, message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(fixes2, fixes2.length));
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    @Nullable
    public static final /* synthetic */ String access$getMessage(KotlinFinalClassOrFunSpringInspection $this, @NotNull KtNamedDeclaration declaration2) {
        return $this.getMessage(declaration2);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/spring/inspections/KotlinFinalClassOrFunSpringInspection$QuickFix;", "T", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;)V", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin-ultimate"})
    public static final class QuickFix<T extends KtModifierListOwner>
    implements LocalQuickFix {
        private final T element;

        @NotNull
        public String getName() {
            return "Make " + ElementDescriptionUtil.getElementDescription((PsiElement)((PsiElement)this.element), (ElementDescriptionLocation)((ElementDescriptionLocation)HighlightUsagesDescriptionLocation.INSTANCE)) + " open";
        }

        @NotNull
        public String getFamilyName() {
            return "Make declaration open";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
            KtNamedDeclaration ktNamedDeclaration;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)problemDescriptor, (String)"problemDescriptor");
            T t = this.element;
            if (!(t instanceof KtNamedDeclaration)) {
                t = null;
            }
            if ((ktNamedDeclaration = (KtNamedDeclaration)t) != null && (ktNamedDeclaration = KtPsiUtilKt.getContainingClassOrObject(ktNamedDeclaration)) != null) {
                ((KtModifierListOwnerStub)((Object)ktNamedDeclaration)).addModifier(KtTokens.OPEN_KEYWORD);
            }
            this.element.addModifier(KtTokens.OPEN_KEYWORD);
        }

        public QuickFix(@NotNull T element2) {
            Intrinsics.checkParameterIsNotNull(element2, (String)"element");
            this.element = element2;
        }
    }
}

