/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsDeclarationScope;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsScope;

public class JsCatchScope
extends JsDeclarationScope {
    private final JsName name;

    public JsCatchScope(JsScope parent2, @NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/js/backend/ast/JsCatchScope", "<init>"));
        }
        super(parent2, "Catch scope", true);
        this.name = new JsName(ident, false);
    }

    @Override
    @NotNull
    public JsName declareName(@NotNull String identifier2) {
        if (identifier2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "org/jetbrains/kotlin/js/backend/ast/JsCatchScope", "declareName"));
        }
        JsName jsName = this.getParent().declareName(identifier2);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsCatchScope", "declareName"));
        }
        return jsName;
    }

    @Override
    public boolean hasOwnName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/backend/ast/JsCatchScope", "hasOwnName"));
        }
        return this.findOwnName(name2) != null;
    }

    @NotNull
    public JsCatchScope copy() {
        JsCatchScope jsCatchScope = new JsCatchScope(this.getParent(), this.name.getIdent());
        if (jsCatchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsCatchScope", "copy"));
        }
        return jsCatchScope;
    }

    @Override
    protected JsName findOwnName(@NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/js/backend/ast/JsCatchScope", "findOwnName"));
        }
        return this.name.getIdent().equals(ident) ? this.name : null;
    }
}

