/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.SimpleDeclarationChecker;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsNameCharsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/SimpleDeclarationChecker;", "()V", "suggestion", "Lorg/jetbrains/kotlin/js/naming/NameSuggestion;", "getSuggestion", "()Lorg/jetbrains/kotlin/js/naming/NameSuggestion;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "js.frontend"})
public final class JsNameCharsChecker
implements SimpleDeclarationChecker {
    @NotNull
    private final NameSuggestion suggestion = new NameSuggestion();

    @NotNull
    public final NameSuggestion getSuggestion() {
        return this.suggestion;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        if (descriptor2 instanceof PropertyAccessorDescriptor && AnnotationsUtils.getJsName(descriptor2) == null) {
            return;
        }
        SuggestedName suggestedName = this.suggestion.suggest(descriptor2);
        if (suggestedName == null) {
            return;
        }
        SuggestedName suggestedName2 = suggestedName;
        if (suggestedName2.getStable()) {
            boolean bl;
            block5: {
                Iterable $receiver$iv = suggestedName2.getNames();
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    if (!(Intrinsics.areEqual((Object)NameSuggestion.Companion.sanitizeName(it), (Object)it) ^ true)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (bl) {
                diagnosticHolder.report(ErrorsJs.NAME_CONTAINS_ILLEGAL_CHARS.on(declaration2));
            }
        }
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        SimpleDeclarationChecker.DefaultImpls.check(this, declaration2, descriptor2, diagnosticHolder, bindingContext2, languageVersionSettings);
    }
}

