/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallChecker;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002JN\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fH\u0002J8\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ>\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010(\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010)\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J@\u00100\u001a\u0002012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00102\u001a\u00020-2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\b\b\u0002\u00104\u001a\u00020\fH\u0002J6\u00105\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ@\u00106\u001a\u0002012\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\fH\u0002J8\u00107\u001a\u0002012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J6\u00108\u001a\u0002012\u0006\u00109\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J8\u0010;\u001a\u0002012\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010<\u001a\u00020\u00152\u0006\u0010%\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J8\u0010=\u001a\u0002012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\f\u0010>\u001a\u00020\u0015*\u00020?H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;", "", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "fakeCallResolver", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "isOperatorProvideDelegateSupported", "", "()Z", "createConstraintSystemCompleter", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemCompleter;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "delegateExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "scopeForDelegate", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getGetSetValueMethod", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "propertyDescriptor", "delegateType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isGet", "isComplete", "getGetValueMethodReturnType", "byExpressionType", "initializerScope", "getProvideDelegateMethod", "delegateExpressionType", "getResolvedDelegateType", "renderCall", "", "call", "Lorg/jetbrains/kotlin/psi/Call;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "reportDelegateOperatorResolutionError", "", "delegateOperatorCall", "delegateOperatorResults", "operatorRequired", "resolveDelegateExpression", "resolveGetSetValueMethod", "resolveGetValueMethod", "resolvePropertyDelegate", "outerDataFlowInfo", "propertyHeaderScope", "resolveProvideDelegateMethod", "byExpression", "resolveSetValueMethod", "createExpressionForProperty", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "frontend"})
public final class DelegatedPropertyResolver {
    private final KotlinBuiltIns builtIns;
    private final FakeCallResolver fakeCallResolver;
    private final ExpressionTypingServices expressionTypingServices;
    private final LanguageVersionSettings languageVersionSettings;

    public final void resolvePropertyDelegate(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtProperty property2, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KtExpression delegateExpression, @NotNull LexicalScope propertyHeaderScope, @NotNull BindingTrace trace) {
        LexicalScope lexicalScope;
        KtPropertyAccessor setter;
        KtPropertyAccessor ktPropertyAccessor;
        KtPropertyAccessor getter;
        Intrinsics.checkParameterIsNotNull((Object)outerDataFlowInfo, (String)"outerDataFlowInfo");
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)delegateExpression, (String)"delegateExpression");
        Intrinsics.checkParameterIsNotNull((Object)propertyHeaderScope, (String)"propertyHeaderScope");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        KtPropertyAccessor ktPropertyAccessor2 = property2.getGetter();
        if (ktPropertyAccessor2 != null && (getter = (ktPropertyAccessor = ktPropertyAccessor2)).hasBody()) {
            trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on((KtPropertyAccessor)((PsiElement)getter)));
        }
        KtPropertyAccessor ktPropertyAccessor3 = property2.getSetter();
        if (ktPropertyAccessor3 != null && (setter = (ktPropertyAccessor = ktPropertyAccessor3)).hasBody()) {
            trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on((KtPropertyAccessor)((PsiElement)setter)));
        }
        if (variableDescriptor instanceof PropertyDescriptor) {
            LexicalScope lexicalScope2 = ScopeUtils.makeScopeForPropertyInitializer(propertyHeaderScope, (PropertyDescriptor)variableDescriptor);
            lexicalScope = lexicalScope2;
            Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope2, (String)"ScopeUtils.makeScopeForP\u2026cope, variableDescriptor)");
        } else {
            lexicalScope = propertyHeaderScope;
        }
        LexicalScope initializerScope = lexicalScope;
        KotlinType byExpressionType = this.resolveDelegateExpression(delegateExpression, property2, variableDescriptor, initializerScope, trace, outerDataFlowInfo);
        this.resolveProvideDelegateMethod(variableDescriptor, delegateExpression, byExpressionType, trace, initializerScope, outerDataFlowInfo);
        KotlinType delegateType = this.getResolvedDelegateType(variableDescriptor, delegateExpression, byExpressionType, trace);
        this.resolveGetValueMethod(variableDescriptor, delegateExpression, delegateType, trace, initializerScope, outerDataFlowInfo);
        if (property2.isVar()) {
            this.resolveSetValueMethod(variableDescriptor, delegateExpression, delegateType, trace, initializerScope, outerDataFlowInfo);
        }
    }

    private final KotlinType getResolvedDelegateType(VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression, KotlinType byExpressionType, BindingTrace trace) {
        ResolvedCall provideDelegateResolvedCall = (ResolvedCall)trace.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, variableDescriptor);
        if (provideDelegateResolvedCall != null) {
            KotlinType kotlinType = ((FunctionDescriptor)provideDelegateResolvedCall.getResultingDescriptor()).getReturnType();
            if (kotlinType == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No return type fore 'provideDelegate' of " + delegateExpression.getText())));
            }
            return kotlinType;
        }
        return byExpressionType;
    }

    @Nullable
    public final KotlinType getGetValueMethodReturnType(@NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KtExpression delegateExpression, @NotNull KotlinType byExpressionType, @NotNull BindingTrace trace, @NotNull LexicalScope initializerScope, @NotNull DataFlowInfo dataFlowInfo) {
        Intrinsics.checkParameterIsNotNull((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)delegateExpression, (String)"delegateExpression");
        Intrinsics.checkParameterIsNotNull((Object)byExpressionType, (String)"byExpressionType");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)initializerScope, (String)"initializerScope");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
        this.resolveProvideDelegateMethod(variableDescriptor, delegateExpression, byExpressionType, trace, initializerScope, dataFlowInfo);
        KotlinType delegateType = this.getResolvedDelegateType(variableDescriptor, delegateExpression, byExpressionType, trace);
        this.resolveGetSetValueMethod(variableDescriptor, delegateExpression, delegateType, trace, initializerScope, dataFlowInfo, true);
        ResolvedCall resolvedCall2 = (ResolvedCall)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, variableDescriptor.getGetter());
        return resolvedCall2 != null ? ((FunctionDescriptor)resolvedCall2.getResultingDescriptor()).getReturnType() : null;
    }

    private final boolean isOperatorProvideDelegateSupported() {
        return this.languageVersionSettings.supportsFeature(LanguageFeature.OperatorProvideDelegate);
    }

    private final void resolveGetValueMethod(VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression, KotlinType delegateType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo) {
        KotlinType returnType2 = this.getGetValueMethodReturnType(variableDescriptor, delegateExpression, delegateType, trace, initializerScope, dataFlowInfo);
        KotlinType propertyType = variableDescriptor.getType();
        if (!(propertyType instanceof DeferredType) && returnType2 != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(returnType2, propertyType)) {
            Call call2 = (Call)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, variableDescriptor.getGetter());
            if (call2 == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Call should exists for " + variableDescriptor.getGetter())));
            }
            Call call3 = call2;
            PsiElement psiElement2 = (PsiElement)delegateExpression;
            Call call4 = call3;
            Intrinsics.checkExpressionValueIsNotNull((Object)call4, (String)"call");
            BindingContext bindingContext2 = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
            trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_RETURN_TYPE_MISMATCH.on((KtExpression)psiElement2, this.renderCall(call4, bindingContext2), variableDescriptor.getType(), returnType2));
        }
    }

    private final void resolveSetValueMethod(VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression, KotlinType delegateType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo) {
        this.resolveGetSetValueMethod(variableDescriptor, delegateExpression, delegateType, trace, initializerScope, dataFlowInfo, false);
    }

    private final KtExpression createExpressionForProperty(@NotNull KtPsiFactory $receiver) {
        return $receiver.createExpression("null as " + KotlinBuiltIns.FQ_NAMES.kProperty.asSingleFqName().asString() + "<*>");
    }

    private final void resolveGetSetValueMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression, KotlinType delegateType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo, boolean isGet) {
        KtPropertyDelegate delegate2;
        PsiElement declaration2;
        VariableAccessorDescriptor variableAccessorDescriptor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        if (variableAccessorDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Delegated property should have getter/setter " + propertyDescriptor + ' ' + delegateExpression.getText())));
        }
        VariableAccessorDescriptor accessor = variableAccessorDescriptor;
        if (trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor) != null) {
            return;
        }
        OverloadResolutionResults<FunctionDescriptor> functionResults = this.getGetSetValueMethod(propertyDescriptor, delegateExpression, delegateType, trace, initializerScope, dataFlowInfo, isGet, true);
        if (!functionResults.isSuccess()) {
            Call call2;
            Call call3 = (Call)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor);
            if (call3 == null) {
                throw (Throwable)((Object)new AssertionError((Object)"'getDelegatedPropertyConventionMethod' didn't record a call"));
            }
            Call call4 = call2 = call3;
            Intrinsics.checkExpressionValueIsNotNull((Object)call4, (String)"call");
            DelegatedPropertyResolver.reportDelegateOperatorResolutionError$default(this, trace, call4, functionResults, delegateExpression, delegateType, false, 32, null);
            return;
        }
        FunctionDescriptor resultingDescriptor = functionResults.getResultingDescriptor();
        ResolvedCall<FunctionDescriptor> resultingCall = functionResults.getResultingCall();
        if (!resultingDescriptor.isOperator() && (declaration2 = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor)) instanceof KtProperty && (delegate2 = ((KtProperty)declaration2).getDelegate()) != null) {
            PsiElement byKeyword;
            PsiElement psiElement2 = byKeyword = delegate2.getByKeywordNode().getPsi();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"byKeyword");
            FunctionDescriptor functionDescriptor2 = resultingDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"resultingDescriptor");
            OperatorCallChecker.Companion.report(psiElement2, functionDescriptor2, trace);
        }
        trace.record(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, accessor, resultingCall);
    }

    private final void reportDelegateOperatorResolutionError(BindingTrace trace, Call delegateOperatorCall, OverloadResolutionResults<FunctionDescriptor> delegateOperatorResults, KtExpression delegateExpression, KotlinType delegateType, boolean operatorRequired) {
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
        String expectedFunction = this.renderCall(delegateOperatorCall, bindingContext2);
        if (delegateOperatorResults.isSingleResult() || delegateOperatorResults.isIncomplete() || Intrinsics.areEqual((Object)((Object)delegateOperatorResults.getResultCode()), (Object)((Object)OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES))) {
            trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE.on((KtExpression)((PsiElement)delegateExpression), expectedFunction, delegateOperatorResults.getResultingCalls()));
        } else if (delegateOperatorResults.isAmbiguity()) {
            trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY.on((KtExpression)((PsiElement)delegateExpression), expectedFunction, delegateOperatorResults.getResultingCalls()));
        } else if (operatorRequired) {
            trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.on((KtExpression)((PsiElement)delegateExpression), expectedFunction, delegateType));
        }
    }

    static /* bridge */ /* synthetic */ void reportDelegateOperatorResolutionError$default(DelegatedPropertyResolver delegatedPropertyResolver, BindingTrace bindingTrace, Call call2, OverloadResolutionResults overloadResolutionResults, KtExpression ktExpression, KotlinType kotlinType, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        delegatedPropertyResolver.reportDelegateOperatorResolutionError(bindingTrace, call2, overloadResolutionResults, ktExpression, kotlinType, bl);
    }

    private final void resolveProvideDelegateMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression byExpression, KotlinType byExpressionType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo) {
        if (!this.isOperatorProvideDelegateSupported()) {
            return;
        }
        if (trace.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_CALL, propertyDescriptor) != null) {
            return;
        }
        OverloadResolutionResults<FunctionDescriptor> provideDelegateResults = this.getProvideDelegateMethod(propertyDescriptor, byExpression, byExpressionType, trace, initializerScope, dataFlowInfo);
        if (!provideDelegateResults.isSuccess()) {
            Call call2;
            Call call3 = (Call)trace.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_CALL, propertyDescriptor);
            if (call3 == null) {
                throw (Throwable)((Object)new AssertionError((Object)"'getDelegatedPropertyConventionMethod' didn't record a call"));
            }
            Call call4 = call2 = call3;
            Intrinsics.checkExpressionValueIsNotNull((Object)call4, (String)"call");
            this.reportDelegateOperatorResolutionError(trace, call4, provideDelegateResults, byExpression, byExpressionType, false);
            return;
        }
        FunctionDescriptor resultingDescriptor = provideDelegateResults.getResultingDescriptor();
        if (!resultingDescriptor.isOperator()) {
            return;
        }
        ResolvedCall<FunctionDescriptor> resultingCall = provideDelegateResults.getResultingCall();
        trace.record(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor, resultingCall);
    }

    private final OverloadResolutionResults<FunctionDescriptor> getGetSetValueMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression, KotlinType delegateType, BindingTrace trace, LexicalScope scopeForDelegate, DataFlowInfo dataFlowInfo, boolean isGet, boolean isComplete) {
        KotlinType kotlinType;
        LexicalScope delegateFunctionsScope = ScopeUtils.makeScopeForDelegateConventionFunctions(scopeForDelegate, propertyDescriptor);
        VariableAccessorDescriptor variableAccessorDescriptor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        if (variableAccessorDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Delegated property should have getter/setter " + propertyDescriptor + ' ' + delegateExpression.getText())));
        }
        VariableAccessorDescriptor accessor = variableAccessorDescriptor;
        if (isComplete && isGet && !(propertyDescriptor.getType() instanceof DeferredType)) {
            KotlinType kotlinType2 = propertyDescriptor.getType();
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"propertyDescriptor.type");
        } else {
            SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"TypeUtils.NO_EXPECTED_TYPE");
            kotlinType = simpleType2;
        }
        KotlinType expectedType = kotlinType;
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, delegateFunctionsScope, dataFlowInfo, expectedType);
        boolean hasThis = propertyDescriptor.getExtensionReceiverParameter() != null || propertyDescriptor.getDispatchReceiverParameter() != null;
        ArrayList arguments2 = Lists.newArrayList();
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)delegateExpression, false);
        arguments2.add(psiFactory.createExpression(hasThis ? "this" : "null"));
        arguments2.add(this.createExpressionForProperty(psiFactory));
        if (!isGet) {
            KtExpression ktExpression = ExpressionTypingUtils.createFakeExpressionOfType(delegateExpression.getProject(), trace, "fakeArgument" + arguments2.size(), propertyDescriptor.getType());
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
            }
            KtReferenceExpression fakeArgument = (KtReferenceExpression)ktExpression;
            arguments2.add(fakeArgument);
            List<ValueParameterDescriptor> valueParameters = accessor.getValueParameters();
            trace.record(BindingContext.REFERENCE_TARGET, fakeArgument, valueParameters.get(0));
        }
        Name functionName2 = isGet ? OperatorNameConventions.GET_VALUE : OperatorNameConventions.SET_VALUE;
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(delegateExpression, delegateType, bindingContext2);
        ReceiverValue receiverValue = receiver;
        ExpressionTypingContext expressionTypingContext = context;
        Intrinsics.checkExpressionValueIsNotNull((Object)expressionTypingContext, (String)"context");
        ResolutionContext resolutionContext = expressionTypingContext;
        ArrayList arrayList = arguments2;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"arguments");
        Pair resolutionResult = FakeCallResolver.makeAndResolveFakeCallInContext$default(this.fakeCallResolver, receiverValue, resolutionContext, arrayList, functionName2, delegateExpression, null, 32, null);
        trace.record(BindingContext.DELEGATED_PROPERTY_CALL, accessor, resolutionResult.getFirst());
        return (OverloadResolutionResults)resolutionResult.getSecond();
    }

    /*
     * WARNING - void declaration
     */
    private final OverloadResolutionResults<FunctionDescriptor> getProvideDelegateMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression, KotlinType delegateExpressionType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo) {
        void provideDelegateResults;
        void provideDelegateCall;
        KtPsiFactory ktPsiFactory;
        SimpleType expectedType = TypeUtils.NO_EXPECTED_TYPE;
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, initializerScope, dataFlowInfo, expectedType);
        boolean propertyHasReceiver = propertyDescriptor.getDispatchReceiverParameter() != null;
        KtPsiFactory $receiver = ktPsiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)delegateExpression, false);
        List arguments2 = CollectionsKt.listOf((Object[])new KtExpression[]{$receiver.createExpression(propertyHasReceiver ? "this" : "null"), this.createExpressionForProperty($receiver)});
        Name functionName2 = OperatorNameConventions.PROVIDE_DELEGATE;
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(delegateExpression, delegateExpressionType, bindingContext2);
        ReceiverValue receiverValue = receiver;
        ExpressionTypingContext expressionTypingContext = context;
        Intrinsics.checkExpressionValueIsNotNull((Object)expressionTypingContext, (String)"context");
        Pair pair2 = FakeCallResolver.makeAndResolveFakeCallInContext$default(this.fakeCallResolver, receiverValue, expressionTypingContext, arguments2, functionName2, delegateExpression, null, 32, null);
        Call $i$a$1$run = (Call)pair2.component1();
        OverloadResolutionResults overloadResolutionResults = (OverloadResolutionResults)pair2.component2();
        pair2 = null;
        trace.record(BindingContext.PROVIDE_DELEGATE_CALL, propertyDescriptor, provideDelegateCall);
        return provideDelegateResults;
    }

    private final String renderCall(Call call2, BindingContext context) {
        KtExpression ktExpression = call2.getCalleeExpression();
        if (ktExpression == null) {
            throw (Throwable)((Object)new AssertionError((Object)"CalleeExpression should exists for fake call of convention method"));
        }
        KtExpression calleeExpression2 = ktExpression;
        Function1 function1 = (Function1)new Function1<ValueArgument, String>(context){
            final /* synthetic */ BindingContext $context;

            @NotNull
            public final String invoke(ValueArgument argument2) {
                KotlinType type2;
                KtExpression ktExpression = argument2.getArgumentExpression();
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                KotlinType kotlinType = this.$context.getType(ktExpression);
                if (kotlinType == null) {
                    Intrinsics.throwNpe();
                }
                KotlinType kotlinType2 = type2 = kotlinType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type");
                return DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(kotlinType2);
            }
            {
                this.$context = bindingContext2;
                super(1);
            }
        };
        CharSequence charSequence = null;
        int n = 0;
        CharSequence charSequence2 = ", ";
        CharSequence charSequence3 = ")";
        CharSequence charSequence4 = "" + calleeExpression2.getText() + '(';
        return CollectionsKt.joinToString$default((Iterable)call2.getValueArguments(), (CharSequence)charSequence2, (CharSequence)charSequence4, (CharSequence)charSequence3, (int)n, charSequence, (Function1)function1, (int)24, null);
    }

    @NotNull
    public final KotlinType resolveDelegateExpression(@NotNull KtExpression delegateExpression, @NotNull KtProperty property2, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull LexicalScope scopeForDelegate, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        Intrinsics.checkParameterIsNotNull((Object)delegateExpression, (String)"delegateExpression");
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)scopeForDelegate, (String)"scopeForDelegate");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
        TemporaryBindingTrace traceToResolveDelegatedProperty = TemporaryBindingTrace.create(trace, "Trace to resolve delegated property");
        KtExpression calleeExpression2 = CallUtilKt.getCalleeExpressionIfAny(delegateExpression);
        ConstraintSystemCompleter completer = this.createConstraintSystemCompleter(property2, variableDescriptor, delegateExpression, scopeForDelegate, trace, dataFlowInfo);
        KtExpression ktExpression = calleeExpression2;
        if (ktExpression != null) {
            KtExpression ktExpression2;
            KtExpression it = ktExpression2 = ktExpression;
            WritableSlice<KtElement, ConstraintSystemCompleter> writableSlice = BindingContext.CONSTRAINT_SYSTEM_COMPLETER;
            Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"CONSTRAINT_SYSTEM_COMPLETER");
            traceToResolveDelegatedProperty.record(writableSlice, it, completer);
        }
        KotlinType delegateType = this.expressionTypingServices.safeGetType(scopeForDelegate, delegateExpression, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, traceToResolveDelegatedProperty);
        traceToResolveDelegatedProperty.commit(resolveDelegateExpression.2.INSTANCE, true);
        KotlinType kotlinType = delegateType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"delegateType");
        return kotlinType;
    }

    private final ConstraintSystemCompleter createConstraintSystemCompleter(KtProperty property2, VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression, LexicalScope scopeForDelegate, BindingTrace trace, DataFlowInfo dataFlowInfo) {
        KotlinType kotlinType;
        if (property2.getTypeReference() != null) {
            KotlinType kotlinType2 = variableDescriptor.getType();
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"variableDescriptor.type");
        } else {
            SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"NO_EXPECTED_TYPE");
            kotlinType = simpleType2;
        }
        KotlinType expectedType = kotlinType;
        return new ConstraintSystemCompleter(this, trace, variableDescriptor, delegateExpression, scopeForDelegate, dataFlowInfo, expectedType){
            final /* synthetic */ DelegatedPropertyResolver this$0;
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ VariableDescriptorWithAccessors $variableDescriptor;
            final /* synthetic */ KtExpression $delegateExpression;
            final /* synthetic */ LexicalScope $scopeForDelegate;
            final /* synthetic */ DataFlowInfo $dataFlowInfo;
            final /* synthetic */ KotlinType $expectedType;

            public void completeConstraintSystem(@NotNull ConstraintSystem.Builder constraintSystem, @NotNull ResolvedCall<?> resolvedCall2) {
                FunctionDescriptor setValueDescriptor;
                List<ValueParameterDescriptor> setValueParameters;
                Intrinsics.checkParameterIsNotNull((Object)constraintSystem, (String)"constraintSystem");
                Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
                KotlinType kotlinType = resolvedCall2.getCandidateDescriptor().getReturnType();
                if (kotlinType == null) {
                    return;
                }
                KotlinType returnType2 = kotlinType;
                TypeSubstitutor typeSubstitutor2 = constraintSystem.getTypeVariableSubstitutors().get(TypeVariableKt.toHandle(resolvedCall2.getCall()));
                if (typeSubstitutor2 == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("No substitutor in the system for call: " + resolvedCall2.getCall())));
                }
                TypeSubstitutor typeVariableSubstitutor = typeSubstitutor2;
                TemporaryBindingTrace traceToResolveConventionMethods = TemporaryBindingTrace.create(this.$trace, "Trace to resolve delegated property convention methods");
                KotlinType kotlinType2 = returnType2;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"returnType");
                TemporaryBindingTrace temporaryBindingTrace = traceToResolveConventionMethods;
                Intrinsics.checkExpressionValueIsNotNull((Object)temporaryBindingTrace, (String)"traceToResolveConventionMethods");
                KotlinType delegateType = this.getDelegateType(kotlinType2, constraintSystem, typeVariableSubstitutor, temporaryBindingTrace);
                OverloadResolutionResults getValueResults = DelegatedPropertyResolver.access$getGetSetValueMethod(this.this$0, this.$variableDescriptor, this.$delegateExpression, delegateType, traceToResolveConventionMethods, this.$scopeForDelegate, this.$dataFlowInfo, true, false);
                if (this.conventionMethodFound(getValueResults)) {
                    KotlinType returnTypeInSystem;
                    FunctionDescriptor getValueDescriptor = (FunctionDescriptor)getValueResults.getResultingDescriptor();
                    KotlinType getValueReturnType = getValueDescriptor.getReturnType();
                    if (getValueReturnType != null && !TypeUtils.noExpectedType(this.$expectedType) && (returnTypeInSystem = typeVariableSubstitutor.substitute(getValueReturnType, Variance.INVARIANT)) != null) {
                        constraintSystem.addSubtypeConstraint(returnTypeInSystem, this.$expectedType, ConstraintPositionKind.FROM_COMPLETER.position());
                    }
                    FunctionDescriptor functionDescriptor2 = getValueDescriptor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"getValueDescriptor");
                    createConstraintSystemCompleter.1.addConstraintForThisValue$default(this, constraintSystem, typeVariableSubstitutor, functionDescriptor2, false, 8, null);
                }
                if (!this.$variableDescriptor.isVar()) {
                    return;
                }
                if (this.$variableDescriptor.getReturnType() instanceof DeferredType) {
                    return;
                }
                OverloadResolutionResults setValueResults = DelegatedPropertyResolver.access$getGetSetValueMethod(this.this$0, this.$variableDescriptor, this.$delegateExpression, delegateType, traceToResolveConventionMethods, this.$scopeForDelegate, this.$dataFlowInfo, false, false);
                if (this.conventionMethodFound(setValueResults) && (setValueParameters = (setValueDescriptor = (FunctionDescriptor)setValueResults.getResultingDescriptor()).getValueParameters()).size() == 3) {
                    if (!TypeUtils.noExpectedType(this.$expectedType)) {
                        KotlinType thisParameterType = setValueParameters.get(2).getType();
                        KotlinType substitutedThisParameterType = typeVariableSubstitutor.substitute(thisParameterType, Variance.INVARIANT);
                        constraintSystem.addSubtypeConstraint(this.$expectedType, substitutedThisParameterType, ConstraintPositionKind.FROM_COMPLETER.position());
                    }
                    FunctionDescriptor functionDescriptor3 = setValueDescriptor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor3, (String)"setValueDescriptor");
                    createConstraintSystemCompleter.1.addConstraintForThisValue$default(this, constraintSystem, typeVariableSubstitutor, functionDescriptor3, false, 8, null);
                }
            }

            private final KotlinType getDelegateType(KotlinType byExpressionType, ConstraintSystem.Builder constraintSystem, TypeSubstitutor typeVariableSubstitutor, TemporaryBindingTrace traceToResolveConventionMethods) {
                OverloadResolutionResults provideDelegateResults;
                if (DelegatedPropertyResolver.access$isOperatorProvideDelegateSupported$p(this.this$0) && this.conventionMethodFound(provideDelegateResults = DelegatedPropertyResolver.access$getProvideDelegateMethod(this.this$0, this.$variableDescriptor, this.$delegateExpression, byExpressionType, traceToResolveConventionMethods, this.$scopeForDelegate, this.$dataFlowInfo))) {
                    FunctionDescriptor provideDelegateDescriptor = (FunctionDescriptor)provideDelegateResults.getResultingDescriptor();
                    KotlinType provideDelegateReturnType = provideDelegateDescriptor.getReturnType();
                    if (provideDelegateDescriptor.isOperator()) {
                        FunctionDescriptor functionDescriptor2 = provideDelegateDescriptor;
                        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"provideDelegateDescriptor");
                        this.addConstraintForThisValue(constraintSystem, typeVariableSubstitutor, functionDescriptor2, true);
                        KotlinType kotlinType = provideDelegateReturnType;
                        if (kotlinType == null) {
                            throw (Throwable)((Object)new AssertionError((Object)("No return type fore 'provideDelegate' of " + this.$delegateExpression.getText())));
                        }
                        return kotlinType;
                    }
                }
                return byExpressionType;
            }

            private final boolean conventionMethodFound(OverloadResolutionResults<FunctionDescriptor> results2) {
                return results2.isSuccess() || results2.isSingleResult() && Intrinsics.areEqual((Object)((Object)results2.getResultCode()), (Object)((Object)OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH));
            }

            private final void addConstraintForThisValue(ConstraintSystem.Builder constraintSystem, TypeSubstitutor typeVariableSubstitutor, FunctionDescriptor resultingDescriptor, boolean dispatchReceiverOnly) {
                Annotated annotated;
                Annotated annotated2;
                ReceiverParameterDescriptor extensionReceiver = this.$variableDescriptor.getExtensionReceiverParameter();
                ReceiverParameterDescriptor dispatchReceiver = this.$variableDescriptor.getDispatchReceiverParameter();
                if (dispatchReceiverOnly) {
                    ReceiverParameterDescriptor receiverParameterDescriptor = dispatchReceiver;
                    annotated2 = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
                } else {
                    annotated2 = extensionReceiver;
                    if (annotated2 == null || (annotated2 = annotated2.getType()) == null) {
                        ReceiverParameterDescriptor receiverParameterDescriptor = dispatchReceiver;
                        annotated2 = annotated = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
                    }
                }
                if (annotated2 == null) {
                    SimpleType simpleType2 = DelegatedPropertyResolver.access$getBuiltIns$p(this.this$0).getNullableNothingType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.nullableNothingType");
                    annotated = simpleType2;
                }
                Annotated typeOfThis = annotated;
                List<ValueParameterDescriptor> valueParameters = resultingDescriptor.getValueParameters();
                if (valueParameters.isEmpty()) {
                    return;
                }
                ValueParameterDescriptor valueParameterForThis = valueParameters.get(0);
                constraintSystem.addSubtypeConstraint((KotlinType)typeOfThis, typeVariableSubstitutor.substitute(valueParameterForThis.getType(), Variance.INVARIANT), ConstraintPositionKind.FROM_COMPLETER.position());
            }

            static /* bridge */ /* synthetic */ void addConstraintForThisValue$default(createConstraintSystemCompleter.1 var0, ConstraintSystem.Builder builder, TypeSubstitutor typeSubstitutor2, FunctionDescriptor functionDescriptor2, boolean bl, int n, Object object) {
                if ((n & 8) != 0) {
                    bl = false;
                }
                var0.addConstraintForThisValue(builder, typeSubstitutor2, functionDescriptor2, bl);
            }
            {
                this.this$0 = $outer;
                this.$trace = $captured_local_variable$1;
                this.$variableDescriptor = $captured_local_variable$2;
                this.$delegateExpression = $captured_local_variable$3;
                this.$scopeForDelegate = $captured_local_variable$4;
                this.$dataFlowInfo = $captured_local_variable$5;
                this.$expectedType = $captured_local_variable$6;
            }
        };
    }

    public DelegatedPropertyResolver(@NotNull KotlinBuiltIns builtIns, @NotNull FakeCallResolver fakeCallResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        Intrinsics.checkParameterIsNotNull((Object)fakeCallResolver, (String)"fakeCallResolver");
        Intrinsics.checkParameterIsNotNull((Object)expressionTypingServices, (String)"expressionTypingServices");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.builtIns = builtIns;
        this.fakeCallResolver = fakeCallResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.languageVersionSettings = languageVersionSettings;
    }

    @NotNull
    public static final /* synthetic */ OverloadResolutionResults access$getGetSetValueMethod(DelegatedPropertyResolver $this, @NotNull VariableDescriptorWithAccessors propertyDescriptor, @NotNull KtExpression delegateExpression, @NotNull KotlinType delegateType, @NotNull BindingTrace trace, @NotNull LexicalScope scopeForDelegate, @NotNull DataFlowInfo dataFlowInfo, boolean isGet, boolean isComplete) {
        return $this.getGetSetValueMethod(propertyDescriptor, delegateExpression, delegateType, trace, scopeForDelegate, dataFlowInfo, isGet, isComplete);
    }

    public static final /* synthetic */ boolean access$isOperatorProvideDelegateSupported$p(DelegatedPropertyResolver $this) {
        return $this.isOperatorProvideDelegateSupported();
    }

    @NotNull
    public static final /* synthetic */ OverloadResolutionResults access$getProvideDelegateMethod(DelegatedPropertyResolver $this, @NotNull VariableDescriptorWithAccessors propertyDescriptor, @NotNull KtExpression delegateExpression, @NotNull KotlinType delegateExpressionType, @NotNull BindingTrace trace, @NotNull LexicalScope initializerScope, @NotNull DataFlowInfo dataFlowInfo) {
        return $this.getProvideDelegateMethod(propertyDescriptor, delegateExpression, delegateExpressionType, trace, initializerScope, dataFlowInfo);
    }

    @NotNull
    public static final /* synthetic */ KotlinBuiltIns access$getBuiltIns$p(DelegatedPropertyResolver $this) {
        return $this.builtIns;
    }
}

