/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/FileClassAnnotationsChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "()V", "ALWAYS_APPLICABLE", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "Lkotlin/collections/HashSet;", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "frontend.java"})
public final class FileClassAnnotationsChecker
implements AdditionalAnnotationChecker {
    private static final HashSet<FqName> ALWAYS_APPLICABLE;
    public static final FileClassAnnotationsChecker INSTANCE;

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries2, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace) {
        boolean bl;
        ClassDescriptor classDescriptor;
        ArrayList<Pair> fileAnnotationsToCheck;
        block7: {
            Intrinsics.checkParameterIsNotNull(entries2, (String)"entries");
            Intrinsics.checkParameterIsNotNull(actualTargets, (String)"actualTargets");
            Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
            fileAnnotationsToCheck = new ArrayList<Pair>();
            for (KtAnnotationEntry pair2 : entries2) {
                AnnotationDescriptor descriptor2;
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = pair2.getUseSiteTarget();
                if (Intrinsics.areEqual((Object)((Object)(ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null)), (Object)((Object)AnnotationUseSiteTarget.FILE)) ^ true) continue;
                if ((AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, pair2) == null) {
                    continue;
                }
                if (TypeUtils.getClassDescriptor(descriptor2.getType()) == null) {
                    continue;
                }
                ClassDescriptor classDescriptor2 = classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"classDescriptor");
                Set<KotlinTarget> applicableTargets = AnnotationChecker.Companion.applicableTargetSet(classDescriptor2);
                if (applicableTargets == null || !applicableTargets.contains((Object)KotlinTarget.FILE)) continue;
                fileAnnotationsToCheck.add(new Pair((Object)pair2, (Object)classDescriptor));
            }
            Iterable iterable = fileAnnotationsToCheck;
            for (KtAnnotationEntry element$iv : iterable) {
                Pair it = (Pair)element$iv;
                ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptorWithTypeParameters)it.getSecond());
                if (!Intrinsics.areEqual((Object)(classId != null ? classId.asSingleFqName() : null), (Object)JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS())) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (!bl) {
            return;
        }
        for (Pair pair2 : fileAnnotationsToCheck) {
            FqName classFqName;
            KtAnnotationEntry entry = (KtAnnotationEntry)pair2.component1();
            classDescriptor = (ClassDescriptor)pair2.component2();
            ClassId classId = DescriptorUtilsKt.getClassId(classDescriptor);
            if (classId == null) {
                Intrinsics.throwNpe();
            }
            if (ALWAYS_APPLICABLE.contains(classFqName = classId.asSingleFqName()) || !(Intrinsics.areEqual((Object)((Object)DescriptorUtilsKt.getAnnotationRetention(classDescriptor)), (Object)((Object)KotlinRetention.SOURCE)) ^ true)) continue;
            trace.report(ErrorsJvm.ANNOTATION_IS_NOT_APPLICABLE_TO_MULTIFILE_CLASSES.on((KtAnnotationEntry)((PsiElement)entry), classFqName));
        }
    }

    private FileClassAnnotationsChecker() {
        INSTANCE = this;
        ALWAYS_APPLICABLE = SetsKt.hashSetOf((Object[])new FqName[]{JvmFileClassUtil.INSTANCE.getJVM_NAME(), JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS()});
    }

    static {
        new FileClassAnnotationsChecker();
    }
}

