/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.NavigateToTestDataAction;
import org.jetbrains.idea.devkit.testAssistant.TestDataRelatedItem;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class TestDataAsRelatedFileProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/devkit/testAssistant/TestDataAsRelatedFileProvider", "getItems"));
        }
        Editor editor = (Editor)context.getData(CommonDataKeys.EDITOR);
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        PsiElement element = (PsiElement)context.getData(CommonDataKeys.PSI_ELEMENT);
        if (editor == null || element == null || project == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataAsRelatedFileProvider", "getItems"));
            }
            return list;
        }
        PsiMethod method = (PsiMethod)UastContextKt.getUastParentOfType((PsiElement)element, UMethod.class);
        if (method == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataAsRelatedFileProvider", "getItems"));
            }
            return list;
        }
        List<String> testDataFiles = NavigateToTestDataAction.findTestDataFiles(context);
        if (testDataFiles == null || testDataFiles.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataAsRelatedFileProvider", "getItems"));
            }
            return list;
        }
        List<TestDataRelatedItem> list = Collections.singletonList(new TestDataRelatedItem(method, editor, testDataFiles));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataAsRelatedFileProvider", "getItems"));
        }
        return list;
    }
}

