/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Comparator;
import org.gradle.api.Action;
import org.gradle.api.attributes.CompatibilityCheckDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOrderedCompatibilityRule<T>
implements Action<CompatibilityCheckDetails<T>> {
    private final Comparator<? super T> comparator;
    private final boolean reverse;

    public DefaultOrderedCompatibilityRule(Comparator<? super T> comparator, boolean reverse) {
        this.comparator = comparator;
        this.reverse = reverse;
    }

    public void execute(CompatibilityCheckDetails<T> details) {
        T consumerValue = details.getConsumerValue();
        T producerValue = details.getProducerValue();
        int cmp = this.comparator.compare(consumerValue, producerValue);
        if (this.reverse) {
            cmp = -cmp;
        }
        if (cmp >= 0) {
            details.compatible();
        } else {
            details.incompatible();
        }
    }
}

