/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.uiBinder.mapping.UiBinderMappingService;
import com.intellij.gwt.uiBinder.references.GwtUiFieldFromHandlerReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GwtUiHandlerErrorsInspection
extends BaseGwtInspection {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/inspections/GwtUiHandlerErrorsInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtUiHandlerErrorsInspection", "checkClass"));
        }
        GwtFacet gwtFacet = GwtUiHandlerErrorsInspection.getFacet((PsiElement)aClass);
        if (gwtFacet == null) {
            return null;
        }
        SmartList problems = new SmartList();
        for (PsiMethod method : aClass.getMethods()) {
            PsiTypeParameter[] typeParameters;
            PsiClass gwtEventClass;
            PsiAnnotation annotation = method.getModifierList().findAnnotation("com.google.gwt.uibinder.client.UiHandler");
            if (annotation == null) continue;
            GwtUiHandlerErrorsInspection.checkReferencesToUiFields(annotation, manager, isOnTheFly, (List<ProblemDescriptor>)problems);
            String methodDescription = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            if (method.hasModifierProperty("private")) {
                LocalQuickFix fix = IntentionManager.getInstance().convertToFix((IntentionAction)QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)method, "private", false, false));
                problems.add(manager.createProblemDescriptor(GwtUiHandlerErrorsInspection.getElementToHighlight(method), "'@UiHandler '" + methodDescription + "' should not be 'private'", fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                continue;
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1) {
                UiBinderMappingService mappingService = UiBinderMappingService.getInstance(gwtFacet.getModule());
                if (mappingService.isUiRendererComponent(aClass)) {
                    if (parameters.length == 0) {
                        problems.add(manager.createProblemDescriptor(GwtUiHandlerErrorsInspection.getElementToHighlight(method), "@UiHandler '" + methodDescription + "' must have at least one parameter defined", isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                        continue;
                    }
                } else {
                    problems.add(manager.createProblemDescriptor(GwtUiHandlerErrorsInspection.getElementToHighlight(method), "@UiHandler '" + methodDescription + "' must have a single event parameter defined", isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                    continue;
                }
            }
            if ((gwtEventClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("com.google.gwt.event.shared.GwtEvent", method.getResolveScope())) == null || (typeParameters = gwtEventClass.getTypeParameters()).length != 1) continue;
            PsiParameter parameter = parameters[0];
            PsiType type = parameter.getType();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
            PsiClassType gwtEventType = elementFactory.createType(gwtEventClass);
            if (!TypeConversionUtil.isAssignable((PsiType)gwtEventType, (PsiType)type)) {
                problems.add(manager.createProblemDescriptor((PsiElement)parameter, "Parameter '" + parameter.getName() + "' is not an event (subclass of GwtEvent)", isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                continue;
            }
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)gwtEventClass, (PsiClassType)((PsiClassType)type));
            PsiType handlerType = substitutor.substitute(typeParameters[0]);
            if (handlerType == null || !(handlerType instanceof PsiClassType)) {
                problems.add(manager.createProblemDescriptor(GwtUiHandlerErrorsInspection.getElementToHighlight(method), "Cannot get EventHandler type for '" + type.getCanonicalText() + "'", isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                continue;
            }
            PsiClass handlerClass = ((PsiClassType)handlerType).resolve();
            if (handlerClass == null || handlerClass instanceof PsiTypeParameter) {
                problems.add(manager.createProblemDescriptor(GwtUiHandlerErrorsInspection.getElementToHighlight(method), "Cannot get EventHandler type for '" + type.getCanonicalText() + "'", isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                continue;
            }
            PsiMethod[] handlerMethods = handlerClass.getMethods();
            if (handlerMethods.length != 1) {
                String message = handlerMethods.length > 1 ? "has more than one method defined" : "has no methods";
                problems.add(manager.createProblemDescriptor(GwtUiHandlerErrorsInspection.getElementToHighlight(method), "Handler class '" + handlerClass.getQualifiedName() + "' " + message, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                continue;
            }
            PsiParameter[] handlerMethodParameters = handlerMethods[0].getParameterList().getParameters();
            if (handlerMethodParameters.length != 1 || !TypeConversionUtil.erasure((PsiType)handlerMethodParameters[0].getType()).equals(TypeConversionUtil.erasure((PsiType)type))) {
                String handlerMethodInfo = PsiFormatUtil.formatMethod((PsiMethod)handlerMethods[0], (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)1, (int)4096, (int)0);
                String currentMethodInfo = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)1, (int)4096, (int)0);
                problems.add(manager.createProblemDescriptor(GwtUiHandlerErrorsInspection.getElementToHighlight(method), "Handler method '" + handlerMethodInfo + "' signature does not match '" + currentMethodInfo + "' signature", isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                continue;
            }
            PsiClassType handlerRegistration = elementFactory.createTypeByFQClassName("com.google.gwt.event.shared.HandlerRegistration", method.getResolveScope());
            for (GwtUiFieldFromHandlerReference reference : GwtUiHandlerErrorsInspection.collectFieldReferences(annotation)) {
                PsiField field;
                PsiType fieldType;
                PsiElement resolved = reference.resolve();
                if (!(resolved instanceof PsiField) || !((fieldType = (field = (PsiField)resolved).getType()) instanceof PsiClassType)) continue;
                List<String> addHandlerMethods = GwtUiHandlerErrorsInspection.findAddHandlerMethods((PsiClassType)fieldType, handlerType, (PsiType)handlerRegistration);
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)reference.getElement();
                if (addHandlerMethods.isEmpty()) {
                    problems.add(manager.createProblemDescriptor((PsiElement)literalExpression, GwtUiHandlerErrorsInspection.getReferenceRange(literalExpression), "Field '" + field.getName() + "' does not have 'addHandler' method for '" + handlerType.getCanonicalText() + "'", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
                    continue;
                }
                if (addHandlerMethods.size() < 2) continue;
                String method1 = addHandlerMethods.get(0);
                String method2 = addHandlerMethods.get(1);
                problems.add(manager.createProblemDescriptor((PsiElement)literalExpression, GwtUiHandlerErrorsInspection.getReferenceRange(literalExpression), "Handler '" + method.getName() + "' cannot be registered: methods '" + method1 + "' and '" + method2 + "' are ambiguous", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
            }
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    public static List<String> findAddHandlerMethods(@NotNull PsiClassType fieldType, @NotNull PsiType handlerType, @NotNull PsiType handlerRegistration) {
        if (fieldType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldType", "com/intellij/gwt/inspections/GwtUiHandlerErrorsInspection", "findAddHandlerMethods"));
        }
        if (handlerType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlerType", "com/intellij/gwt/inspections/GwtUiHandlerErrorsInspection", "findAddHandlerMethods"));
        }
        if (handlerRegistration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlerRegistration", "com/intellij/gwt/inspections/GwtUiHandlerErrorsInspection", "findAddHandlerMethods"));
        }
        PsiClassType.ClassResolveResult resolveResult = fieldType.resolveGenerics();
        PsiClass fieldClass = resolveResult.getElement();
        if (fieldClass == null) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        HashSet<MethodSignature> signatures = new HashSet<MethodSignature>();
        for (Pair pair : fieldClass.getAllMethodsAndTheirSubstitutors()) {
            PsiMethod method = (PsiMethod)pair.getFirst();
            MethodSignature signature = method.getSignature(MethodSignatureUtil.combineSubstitutors((PsiSubstitutor)((PsiSubstitutor)pair.second), (PsiSubstitutor)resolveResult.getSubstitutor()));
            if (!signatures.add(signature)) continue;
            PsiType[] parameters = signature.getParameterTypes();
            if (!handlerRegistration.equals(method.getReturnType()) || parameters.length != 1 || !handlerType.equals(parameters[0])) continue;
            result.add(PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2));
        }
        return result;
    }

    private static List<GwtUiFieldFromHandlerReference> collectFieldReferences(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/gwt/inspections/GwtUiHandlerErrorsInspection", "collectFieldReferences"));
        }
        SmartList result = new SmartList();
        annotation.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((List)result){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                PsiReference[] references;
                for (PsiReference reference : references = expression.getReferences()) {
                    if (!(reference instanceof GwtUiFieldFromHandlerReference)) continue;
                    this.val$result.add((GwtUiFieldFromHandlerReference)reference);
                }
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitExpression((PsiExpression)expression);
            }
        });
        return result;
    }

    private static void checkReferencesToUiFields(@NotNull PsiAnnotation annotation, InspectionManager manager, boolean onTheFly, List<ProblemDescriptor> problems) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/gwt/inspections/GwtUiHandlerErrorsInspection", "checkReferencesToUiFields"));
        }
        for (GwtUiFieldFromHandlerReference reference : GwtUiHandlerErrorsInspection.collectFieldReferences(annotation)) {
            if (reference.resolve() != null) continue;
            PsiLiteralExpression expression = (PsiLiteralExpression)reference.getElement();
            TextRange range = GwtUiHandlerErrorsInspection.getReferenceRange(expression);
            problems.add(manager.createProblemDescriptor((PsiElement)expression, range, "Cannot resolve '" + expression.getValue() + "' field", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly, new LocalQuickFix[0]));
        }
    }

    private static TextRange getReferenceRange(PsiLiteralExpression expression) {
        String text = expression.getText();
        int start = text.indexOf(34);
        int end = text.lastIndexOf(34);
        if (start != -1 && end != -1) {
            return new TextRange(start + 1, end);
        }
        return new TextRange(0, expression.getTextLength());
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("@UiHandler Errors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtUiHandlerErrorsInspection", "getDisplayName"));
        }
        return "@UiHandler Errors";
    }

    @NotNull
    public String getShortName() {
        if ("GwtUiHandlerErrors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtUiHandlerErrorsInspection", "getShortName"));
        }
        return "GwtUiHandlerErrors";
    }
}

