/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.make.report;

import com.intellij.gwt.make.GwtCompilerPaths;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompileReportsHistory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.make.report.CompileReportsHistory");
    private final ProjectCompileReports myReports;
    private final Project myProject;

    public static CompileReportsHistory getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/make/report/CompileReportsHistory", "getInstance"));
        }
        return (CompileReportsHistory)ServiceManager.getService((Project)project, CompileReportsHistory.class);
    }

    CompileReportsHistory(Project project) {
        this.myProject = project;
        this.myReports = CompileReportsHistory.loadReports(project);
    }

    private static ProjectCompileReports loadReports(Project project) {
        File reportsFile = GwtCompilerPaths.getCompileReportInfo(project);
        try {
            if (reportsFile.exists()) {
                return (ProjectCompileReports)XmlSerializer.deserialize((Element)JDOMUtil.load((File)reportsFile), ProjectCompileReports.class);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        return new ProjectCompileReports();
    }

    @Nullable
    public synchronized GwtModuleCompileReport getCompileReport(String gwtModuleName) {
        return this.myReports.myReportGenerationTimes.get(gwtModuleName);
    }

    public synchronized void updateReport(String gwtModuleName, long generationTime, String path) {
        this.myReports.myReportGenerationTimes.put(gwtModuleName, new GwtModuleCompileReport(generationTime, path));
        this.save();
    }

    private void save() {
        Element root = XmlSerializer.serialize((Object)this.myReports);
        try {
            JDOMUtil.write((Parent)root, (File)GwtCompilerPaths.getCompileReportInfo(this.myProject), (String)SystemProperties.getLineSeparator());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @Tag(value="compile-report")
    public static class GwtModuleCompileReport {
        private long myGenerationTime;
        private String myPath;

        public GwtModuleCompileReport() {
        }

        public GwtModuleCompileReport(long generationTime, String path) {
            this.myGenerationTime = generationTime;
            this.myPath = path;
        }

        @Tag(value="generation-time")
        public long getGenerationTime() {
            return this.myGenerationTime;
        }

        public void setGenerationTime(long generationTime) {
            this.myGenerationTime = generationTime;
        }

        @Tag(value="path")
        public String getPath() {
            return this.myPath;
        }

        public void setPath(String path) {
            this.myPath = path;
        }
    }

    public static class ProjectCompileReports {
        @Tag(value="generated-reports")
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, entryTagName="gwt-module", keyAttributeName="name")
        public Map<String, GwtModuleCompileReport> myReportGenerationTimes = new HashMap<String, GwtModuleCompileReport>();
    }
}

