/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.refactorings;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.JavaFindUsagesHandler;
import com.intellij.find.findUsages.JavaFindUsagesHandlerFactory;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class GwtFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/refactorings/GwtFindUsagesHandlerFactory", "canFindUsages"));
        }
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)element;
        if (RemoteServiceUtil.findSynchronousMethod(method) != null) {
            return true;
        }
        Collection supers = DeepestSuperMethodsSearch.search((PsiMethod)method).findAll();
        for (PsiMethod superMethod : supers) {
            if (RemoteServiceUtil.findSynchronousMethod(superMethod) == null) continue;
            return true;
        }
        return false;
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/refactorings/GwtFindUsagesHandlerFactory", "createFindUsagesHandler"));
        }
        JavaFindUsagesHandlerFactory factory = JavaFindUsagesHandlerFactory.getInstance((Project)element.getProject());
        return new JavaFindUsagesHandler((PsiElement)((PsiMethod)element), factory){

            @NotNull
            public PsiElement[] getSecondaryElements() {
                PsiElement element = this.getPsiElement();
                if (element instanceof PsiMethod) {
                    Object[] methods;
                    for (PsiMethod psiMethod : methods = SuperMethodWarningUtil.checkSuperMethods((PsiMethod)((PsiMethod)element), (String)JavaFindUsagesHandler.ACTION_STRING)) {
                        PsiMethod syncMethod = RemoteServiceUtil.findSynchronousMethod(psiMethod);
                        if (syncMethod == null) continue;
                        methods = (PsiMethod[])ArrayUtil.append((Object[])methods, (Object)syncMethod);
                        break;
                    }
                    if (methods.length > 0) {
                        if (methods == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/refactorings/GwtFindUsagesHandlerFactory$1", "getSecondaryElements"));
                        }
                        return methods;
                    }
                }
                PsiElement[] psiElementArray = super.getSecondaryElements();
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/refactorings/GwtFindUsagesHandlerFactory$1", "getSecondaryElements"));
                }
                return psiElementArray;
            }
        };
    }
}

