/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run.remoteUi;

import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ModuleLogComponent
implements Disposable {
    private JPanel myMainPanel;
    private ComboBox myModuleCombobox;
    private JPanel myConsolePanel;
    private Map<String, ConsoleView> myConsoleViews;
    private String myLastSelectedModule;
    private Project myProject;

    public ModuleLogComponent(Project project) {
        this.$$$setupUI$$$();
        this.myConsoleViews = new HashMap<String, ConsoleView>();
        this.myProject = project;
        this.myModuleCombobox.setMinimumAndPreferredWidth(300);
        this.myModuleCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModuleLogComponent.this.updateConsole();
            }
        });
    }

    private void updateConsole() {
        String module = (String)this.myModuleCombobox.getSelectedItem();
        if (module == null || module.equals(this.myLastSelectedModule)) {
            return;
        }
        ((CardLayout)this.myConsolePanel.getLayout()).show(this.myConsolePanel, module);
        this.myConsolePanel.revalidate();
        this.myConsolePanel.repaint();
        this.myLastSelectedModule = module;
    }

    public ConsoleView getOrCreateModuleConsole(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/gwt/run/remoteUi/ModuleLogComponent", "getOrCreateModuleConsole"));
        }
        ConsoleView view = this.myConsoleViews.get(moduleName);
        if (view == null) {
            view = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject).getConsole();
            this.myConsoleViews.put(moduleName, view);
            this.myModuleCombobox.addItem((Object)moduleName);
            this.myConsolePanel.add(moduleName, view.getComponent());
            if (this.myModuleCombobox.getItemCount() == 1) {
                this.myModuleCombobox.setSelectedIndex(0);
            }
        }
        return view;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void dispose() {
        for (ConsoleView view : this.myConsoleViews.values()) {
            Disposer.dispose((Disposable)view);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        ComboBox comboBox;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, "North");
        JLabel jLabel = new JLabel();
        jLabel.setText("Module:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleCombobox = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myConsolePanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

