/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.superSource;

import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.psi.GwtSourcePathsRefresherProjectComponent;
import com.intellij.gwt.superSource.GwtSuperSourceClassCache;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.impl.GwtSourcePath;

public class GwtSuperSourceClassCacheImpl
extends GwtSuperSourceClassCache {
    private final Project myProject;
    private final Map<String, Boolean> myCachedSuperSourceClasses = ContainerUtil.newConcurrentMap();

    public GwtSuperSourceClassCacheImpl(Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public List<PsiClass> findClassesByQualifiedName(@NotNull String qualifiedName, @NotNull VirtualFile root) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/gwt/superSource/GwtSuperSourceClassCacheImpl", "findClassesByQualifiedName"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/gwt/superSource/GwtSuperSourceClassCacheImpl", "findClassesByQualifiedName"));
        }
        SmartList result = new SmartList();
        SmartList innerClassNames = new SmartList();
        String currentName = qualifiedName;
        do {
            PsiFile psiFile;
            VirtualFile file;
            if ((file = root.findFileByRelativePath(currentName.replace('.', '/') + ".java")) != null && (psiFile = this.getCachedPsiFile(file)) instanceof PsiJavaFile) {
                for (PsiClass aClass : ((PsiJavaFile)psiFile).getClasses()) {
                    if (!currentName.equals(aClass.getQualifiedName())) continue;
                    ContainerUtil.addIfNotNull((Collection)result, (Object)GwtSuperSourceClassCacheImpl.findInnerClass(aClass, (List<String>)innerClassNames));
                }
            }
            innerClassNames.add(StringUtil.getShortName((String)currentName));
        } while ((currentName = StringUtil.getPackageName((String)currentName)).length() > 0);
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/superSource/GwtSuperSourceClassCacheImpl", "findClassesByQualifiedName"));
        }
        return smartList;
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(VirtualFile file) {
        return PsiManager.getInstance((Project)this.myProject).findFile(file);
    }

    @Override
    public boolean containsJreEmulationClass(@NotNull List<GwtModule> gwtModules, @NotNull String className) {
        if (gwtModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtModules", "com/intellij/gwt/superSource/GwtSuperSourceClassCacheImpl", "containsJreEmulationClass"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/gwt/superSource/GwtSuperSourceClassCacheImpl", "containsJreEmulationClass"));
        }
        Boolean result = this.myCachedSuperSourceClasses.get(className);
        if (result != null) {
            return result;
        }
        result = Boolean.FALSE;
        GwtSourcePathsRefresherProjectComponent sourcePathsRefresher = GwtSourcePathsRefresherProjectComponent.getInstance(this.myProject);
        for (GwtSourcePath superSourcePath : sourcePathsRefresher.getSuperSourcePaths(gwtModules)) {
            String filePath;
            PsiClass psiClass;
            VirtualFile superSourceRoot = LocalFileSystem.getInstance().findFileByPath(superSourcePath.myFullPath);
            if (superSourceRoot == null || (psiClass = (PsiClass)ContainerUtil.getFirstItem(this.findClassesByQualifiedName(className, superSourceRoot))) == null || !sourcePathsRefresher.isIncluded(filePath = psiClass.getContainingFile().getVirtualFile().getPath(), superSourcePath)) continue;
            result = Boolean.TRUE;
            break;
        }
        this.myCachedSuperSourceClasses.put(className, result);
        return result;
    }

    @Override
    public void invalidateSuperSourceCache() {
        this.myCachedSuperSourceClasses.clear();
    }
}

