/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GwtXmlAttributeDescriptorBase
extends BasicXmlAttributeDescriptor {
    private static final String[] BOOLEAN_VALUES = new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};
    private final String[] myValues;
    private final boolean myRequired;

    public GwtXmlAttributeDescriptorBase(@Nullable PsiType type, boolean required) {
        if (TypeConversionUtil.isBooleanType((PsiType)type)) {
            this.myValues = BOOLEAN_VALUES;
        } else if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            if (psiClass != null && psiClass.isEnum()) {
                ArrayList<String> values = new ArrayList<String>();
                for (PsiField field : psiClass.getFields()) {
                    if (!(field instanceof PsiEnumConstant)) continue;
                    values.add(field.getName());
                }
                this.myValues = ArrayUtil.toStringArray(values);
            } else {
                this.myValues = ArrayUtil.EMPTY_STRING_ARRAY;
            }
        } else {
            this.myValues = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        this.myRequired = required;
    }

    public boolean isRequired() {
        return this.myRequired;
    }

    public boolean isFixed() {
        return false;
    }

    public boolean hasIdType() {
        return false;
    }

    public boolean hasIdRefType() {
        return false;
    }

    public String getDefaultValue() {
        return null;
    }

    public String[] getEnumeratedValues() {
        return this.myValues;
    }

    public void init(PsiElement element) {
    }

    @NotNull
    public Object[] getDependences() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/GwtXmlAttributeDescriptorBase", "getDependences"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isEnumerated() {
        return this.myValues.length > 0;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }
}

