/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.references;

import com.intellij.gwt.uiBinder.declarations.UiXmlDeclarationsManager;
import com.intellij.gwt.uiBinder.declarations.UiXmlVariableDeclaration;
import com.intellij.gwt.uiBinder.references.UiXmlElementReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiXmlVariableReference
extends PsiReferenceBase<XmlAttributeValue>
implements UiXmlElementReference {
    public UiXmlVariableReference(@NotNull XmlAttributeValue element, TextRange range) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/uiBinder/references/UiXmlVariableReference", "<init>"));
        }
        super((PsiElement)element, range, true);
    }

    public XmlTag resolve() {
        UiXmlVariableDeclaration element = this.findDeclaration();
        return element != null ? element.getTag() : null;
    }

    @Nullable
    public UiXmlVariableDeclaration findDeclaration() {
        PsiFile file = ((XmlAttributeValue)this.myElement).getContainingFile();
        if (file instanceof XmlFile) {
            return UiXmlDeclarationsManager.findDeclaration((XmlFile)file, this.getValue());
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        PsiFile file = ((XmlAttributeValue)this.myElement).getContainingFile();
        if (file instanceof XmlFile) {
            ArrayList<String> fields = new ArrayList<String>();
            for (UiXmlVariableDeclaration element : UiXmlDeclarationsManager.getDeclarations((XmlFile)file)) {
                fields.add(element.getVariableName());
            }
            Object[] objectArray = ArrayUtil.toStringArray(fields);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/references/UiXmlVariableReference", "getVariants"));
            }
            return objectArray;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/references/UiXmlVariableReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public PsiType resolveVariableType() {
        UiXmlVariableDeclaration declaration = this.findDeclaration();
        return declaration != null ? declaration.resolveType() : null;
    }
}

