/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.codeInsight.editorActions.enter.EnterInStringLiteralHandler;
import com.intellij.javascript.JSQuoteHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JSEnterInStringLiteralHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/JSEnterInStringLiteralHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/JSEnterInStringLiteralHandler", "preprocessEnter"));
        }
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsetRef", "com/intellij/javascript/JSEnterInStringLiteralHandler", "preprocessEnter"));
        }
        if (caretAdvanceRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvanceRef", "com/intellij/javascript/JSEnterInStringLiteralHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/javascript/JSEnterInStringLiteralHandler", "preprocessEnter"));
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        int caretAdvance = (Integer)caretAdvanceRef.get();
        PsiElement psiAtOffset = file.findElementAt(caretOffset);
        if (psiAtOffset != null && psiAtOffset.getTextOffset() < caretOffset) {
            JSQuoteHandler quoteHandler;
            Document document = editor.getDocument();
            String text = document.getText();
            ASTNode token = psiAtOffset.getNode();
            QuoteHandler fileTypeQuoteHandler = TypedHandler.getQuoteHandler((PsiFile)psiAtOffset.getContainingFile(), (Editor)editor);
            JSQuoteHandler jSQuoteHandler = quoteHandler = fileTypeQuoteHandler instanceof JSQuoteHandler ? (JSQuoteHandler)fileTypeQuoteHandler : null;
            if (quoteHandler != null && JSTokenTypes.LITERALS.contains(token.getElementType())) {
                char c;
                boolean enterAfterSlashAndBeforeQuote;
                TextRange range = token.getTextRange();
                String tokenText = token.getText();
                boolean bl = enterAfterSlashAndBeforeQuote = caretOffset >= 1 && caretOffset < text.length() && text.charAt(caretOffset - 1) == '\\' && ((c = text.charAt(caretOffset)) == '\"' || c == '\'');
                if (enterAfterSlashAndBeforeQuote) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                if (tokenText.indexOf(10) == -1) {
                    return new EnterInStringLiteralHandler(){

                        protected JavaLikeQuoteHandler getJavaLikeQuoteHandler(Editor editor, PsiElement psiAtOffset) {
                            return new JSQuoteHandler(){

                                @Override
                                public TokenSet getConcatenatableStringTokenTypes() {
                                    return JSTokenTypes.STRING_LITERALS;
                                }

                                @Override
                                public String getStringConcatenationOperatorRepresentation() {
                                    return "+";
                                }
                            };
                        }
                    }.preprocessEnter(file, editor, caretOffsetRef, caretAdvanceRef, dataContext, originalHandler);
                }
                char literalStart = tokenText.charAt(0);
                StringLiteralLexer lexer = new StringLiteralLexer(literalStart, token.getElementType());
                lexer.start((CharSequence)text, range.getStartOffset(), range.getEndOffset());
                while (lexer.getTokenType() != null) {
                    if (lexer.getTokenStart() < caretOffset && caretOffset < lexer.getTokenEnd()) {
                        if (!StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(lexer.getTokenType())) break;
                        caretOffset = lexer.getTokenEnd();
                        break;
                    }
                    lexer.advance();
                }
                boolean atNewLine = document.getCharsSequence().charAt(caretOffset) == '\n';
                document.insertString(caretOffset, (CharSequence)"\\");
                if (atNewLine) {
                    caretAdvance = 1;
                } else {
                    ++caretOffset;
                }
                caretOffsetRef.set((Object)caretOffset);
                caretAdvanceRef.set((Object)caretAdvance);
                return EnterHandlerDelegate.Result.DefaultForceIndent;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }
}

