/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.jest.scope.JestScopeView;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestRunConfigurationEditor
extends SettingsEditor<JestRunConfiguration> {
    private final Project myProject;
    private final TextFieldWithHistoryWithBrowseButton myConfigPathTextFieldWithBrowseButton;
    private final NodeJsInterpreterField myInterpreterField;
    private final NodePackageField myJestPackageField;
    private final TextFieldWithBrowseButton myWorkingDirComponent;
    private final RawCommandLineEditor myJestOptionsEditor;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final Map<JestScopeKind, JRadioButton> myRadioButtonMap;
    private final Map<JestScopeKind, JestScopeView> myScopeKindViewMap;
    private final JPanel mySelectedScopeKindPanel;
    private final JPanel myPanel;
    private final int myLongestLabelWidth;

    public JestRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/jest/JestRunConfigurationEditor", "<init>"));
        }
        this.myRadioButtonMap = ContainerUtil.newHashMap();
        this.myScopeKindViewMap = ContainerUtil.newHashMap();
        this.myLongestLabelWidth = new JLabel((String)"Environment variables:").getPreferredSize().width;
        this.myProject = project;
        this.myConfigPathTextFieldWithBrowseButton = JestRunConfigurationEditor.createConfigurationFileTextField(project);
        this.myInterpreterField = new NodeJsInterpreterField(project, false);
        this.myJestPackageField = new NodePackageField(project, JestUtil.RUNNER_PACKAGES, this.myInterpreterField::getInterpreter);
        this.myWorkingDirComponent = JestRunConfigurationEditor.createWorkingDirComponent(project);
        this.myJestOptionsEditor = new RawCommandLineEditor();
        this.myJestOptionsEditor.setDialogCaption("Jest Options");
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        JPanel scopeKindPanel = this.createScopeKindRadioButtonPanel();
        this.mySelectedScopeKindPanel = new JPanel(new BorderLayout());
        this.myPanel = new FormBuilder().setAlignLabelOnRight(false).addLabeledComponent("&Configuration file:", (JComponent)this.myConfigPathTextFieldWithBrowseButton).addSeparator(8).addLabeledComponent("Node &interpreter:", (JComponent)((Object)this.myInterpreterField), 8).addLabeledComponent("&Jest package:", (JComponent)((Object)this.myJestPackageField)).addLabeledComponent("&Working directory:", (JComponent)this.myWorkingDirComponent).addLabeledComponent("Jest &options:", (JComponent)this.myJestOptionsEditor).addLabeledComponent("&Environment variables:", (JComponent)this.myEnvVarsComponent).addSeparator(8).addComponent((JComponent)scopeKindPanel).addComponent((JComponent)this.mySelectedScopeKindPanel).getPanel();
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createConfigurationFileTextField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/jest/JestRunConfigurationEditor", "createConfigurationFileTextField"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        final TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent();
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setMinimumAndPreferredWidth(0);
        SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/jest/JestRunConfigurationEditor", "lambda$createConfigurationFileTextField$1"));
            }
            List<VirtualFile> newFiles = JestUtil.listPossibleConfigFilesInProject(project);
            List newFilePaths = ContainerUtil.map(newFiles, file -> FileUtil.toSystemDependentName((String)file.getPath()));
            Collections.sort(newFilePaths);
            return newFilePaths;
        });
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithHistoryWithBrowseButton)textFieldWithHistoryWithBrowseButton, (String)"Select Jest Configuration File", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        textFieldWithHistory.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){
            private String myLastAddedText;

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                String currentText = textFieldWithHistory.getText();
                if (currentText == null || currentText.equals(this.myLastAddedText)) {
                    return;
                }
                List oldHistory = textFieldWithHistory.getHistory();
                HashSet<String> newHistory = new HashSet<String>(oldHistory);
                newHistory.remove(this.myLastAddedText);
                this.myLastAddedText = null;
                if (!oldHistory.contains(currentText)) {
                    newHistory.add(currentText);
                    this.myLastAddedText = currentText;
                }
                ArrayList result = new ArrayList(newHistory);
                Collections.sort(result);
                if (!result.equals(oldHistory)) {
                    textFieldWithHistory.setHistory(result);
                    textFieldWithHistory.setSelectedItem((Object)currentText);
                }
            }
        });
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton2 = textFieldWithHistoryWithBrowseButton;
        if (textFieldWithHistoryWithBrowseButton2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunConfigurationEditor", "createConfigurationFileTextField"));
        }
        return textFieldWithHistoryWithBrowseButton2;
    }

    @NotNull
    private static TextFieldWithBrowseButton createWorkingDirComponent(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/jest/JestRunConfigurationEditor", "createWorkingDirComponent"));
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (String)"Select Working Directory", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunConfigurationEditor", "createWorkingDirComponent"));
        }
        return textFieldWithBrowseButton2;
    }

    @NotNull
    private JPanel createScopeKindRadioButtonPanel() {
        JPanel testKindPanel = new JPanel(new FlowLayout(1, JBUI.scale((int)40), 0));
        testKindPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)10, (int)0, (int)0));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (final JestScopeKind scopeKind : JestScopeKind.values()) {
            JRadioButton radioButton = new JRadioButton(UIUtil.removeMnemonic((String)scopeKind.getName()));
            int index = UIUtil.getDisplayMnemonicIndex((String)scopeKind.getName());
            if (index != -1) {
                radioButton.setMnemonic(scopeKind.getName().charAt(index + 1));
                radioButton.setDisplayedMnemonicIndex(index);
            }
            radioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JestRunConfigurationEditor.this.setScopeKind(scopeKind);
                }
            });
            this.myRadioButtonMap.put(scopeKind, radioButton);
            testKindPanel.add(radioButton);
            buttonGroup.add(radioButton);
        }
        JPanel jPanel = testKindPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunConfigurationEditor", "createScopeKindRadioButtonPanel"));
        }
        return jPanel;
    }

    private void setScopeKind(@NotNull JestScopeKind scopeKind) {
        if (scopeKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeKind", "com/intellij/javascript/jest/JestRunConfigurationEditor", "setScopeKind"));
        }
        JestScopeKind selectedScopeKind = this.getScopeKind();
        if (selectedScopeKind != scopeKind) {
            JRadioButton radioButton = this.myRadioButtonMap.get((Object)scopeKind);
            radioButton.setSelected(true);
        }
        JestScopeView view = this.getScopeKindView(scopeKind);
        JestRunConfigurationEditor.setCenterBorderLayoutComponent(this.mySelectedScopeKindPanel, view.getComponent());
    }

    @NotNull
    private JestScopeView getScopeKindView(@NotNull JestScopeKind scopeKind) {
        if (scopeKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeKind", "com/intellij/javascript/jest/JestRunConfigurationEditor", "getScopeKindView"));
        }
        JestScopeView view = this.myScopeKindViewMap.get((Object)scopeKind);
        if (view == null) {
            view = scopeKind.createView(this.myProject);
            this.myScopeKindViewMap.put(scopeKind, view);
            JComponent component = view.getComponent();
            if (component.getLayout() instanceof GridBagLayout) {
                component.add(Box.createHorizontalStrut(this.myLongestLabelWidth), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insets((int)0, (int)0, (int)0, (int)10), 0, 0));
            }
        }
        JestScopeView jestScopeView = view;
        if (jestScopeView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunConfigurationEditor", "getScopeKindView"));
        }
        return jestScopeView;
    }

    private static void setCenterBorderLayoutComponent(@NotNull JPanel panel, @NotNull Component child) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/javascript/jest/JestRunConfigurationEditor", "setCenterBorderLayoutComponent"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/javascript/jest/JestRunConfigurationEditor", "setCenterBorderLayoutComponent"));
        }
        Component prevChild = ((BorderLayout)panel.getLayout()).getLayoutComponent("Center");
        if (prevChild != null) {
            panel.remove(prevChild);
        }
        panel.add(child, "Center");
        panel.revalidate();
        panel.repaint();
    }

    @Nullable
    private JestScopeKind getScopeKind() {
        for (Map.Entry<JestScopeKind, JRadioButton> entry : this.myRadioButtonMap.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            return entry.getKey();
        }
        return null;
    }

    protected void resetEditorFrom(@NotNull JestRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/javascript/jest/JestRunConfigurationEditor", "resetEditorFrom"));
        }
        JestRunSettings runSettings = runConfiguration.getRunSettings();
        this.myConfigPathTextFieldWithBrowseButton.setTextAndAddToHistory(runSettings.getConfigFileSystemDependentPath());
        this.myInterpreterField.setInterpreterRef(runSettings.getInterpreterRef());
        NodeJsInterpreter interpreter = runSettings.getInterpreterRef().resolve(this.myProject);
        NodePackage pkg = JestUtil.getJestPackage(this.myProject, interpreter);
        this.myJestPackageField.setSelected(pkg);
        this.myWorkingDirComponent.setText(runSettings.getWorkingDirSystemDependentPath());
        this.myJestOptionsEditor.setText(runSettings.getJestOptions());
        this.myEnvVarsComponent.setData(runSettings.getEnvData());
        this.setScopeKind(runSettings.getScopeKind());
        JestScopeView view = this.getScopeKindView(runSettings.getScopeKind());
        view.resetFrom(runSettings);
        this.updatePreferredWidth();
    }

    private void updatePreferredWidth() {
        DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)this.myPanel);
        if (dialogWrapper instanceof SingleConfigurableEditor) {
            this.myInterpreterField.setPreferredWidthToFitText();
            this.myJestPackageField.setPreferredWidthToFitText();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myConfigPathTextFieldWithBrowseButton);
            ApplicationManager.getApplication().invokeLater(() -> SwingHelper.adjustDialogSizeToFitPreferredSize((DialogWrapper)dialogWrapper), ModalityState.stateForComponent((Component)this.myPanel));
        }
    }

    protected void applyEditorTo(@NotNull JestRunConfiguration runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/javascript/jest/JestRunConfigurationEditor", "applyEditorTo"));
        }
        JestRunSettings.Builder builder = JestRunSettings.builder();
        builder.setConfigFilePath(this.myConfigPathTextFieldWithBrowseButton.getText());
        JestUtil.setJestPackage(this.myProject, this.myJestPackageField.getSelected());
        builder.setInterpreterRef(this.myInterpreterField.getInterpreterRef());
        builder.setWorkingDir(this.myWorkingDirComponent.getText());
        builder.setJestOptions(this.myJestOptionsEditor.getText());
        builder.setEnvData(this.myEnvVarsComponent.getData());
        JestScopeKind scopeKind = this.getScopeKind();
        if (scopeKind != null) {
            builder.setScopeKind(scopeKind);
            JestScopeView view = this.getScopeKindView(scopeKind);
            view.applyTo(builder);
        }
        runConfiguration.setRunSettings(builder.build());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }
}

