/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.google.common.base.Function;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeJSRemoteSdkCredentials;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentialsProducer;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.text.SemVer;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeJSRemoteInterpreterManager {
    public static final ExtensionPointName<NodeJSRemoteInterpreterManager> EP_NAME = ExtensionPointName.create((String)"JavaScript.remoteInterpreterManager");
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.remote.NodeJSRemoteInterpreterManager");

    @Nullable
    public static NodeJSRemoteInterpreterManager getInstance() {
        NodeJSRemoteInterpreterManager[] extensions = (NodeJSRemoteInterpreterManager[])EP_NAME.getExtensions();
        if (extensions.length == 0) {
            return null;
        }
        if (extensions.length > 1) {
            LOG.warn("Too many Node.js remote interpreter managers registered (" + Arrays.asList(extensions) + ")");
        }
        return extensions[0];
    }

    @Nullable
    public static NodeJSRemoteInterpreterManager getInstanceOrPrompt(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/javascript/nodejs/NodeJSRemoteInterpreterManager", "getInstanceOrPrompt"));
        }
        NodeJSRemoteInterpreterManager instance = NodeJSRemoteInterpreterManager.getInstance();
        if (instance == null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (title == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/javascript/nodejs/NodeJSRemoteInterpreterManager", "lambda$getInstanceOrPrompt$0"));
                }
                Messages.showErrorDialog((String)NodeJSRemoteInterpreterManager.noRemoteNodeInterpreterPluginMessage(), (String)title);
            }, ModalityState.any());
            return null;
        }
        return instance;
    }

    @NotNull
    public static String noRemoteNodeInterpreterPluginMessage() {
        String pathToPluginsPage = ShowSettingsUtil.getSettingsMenuName() + " | Plugins";
        String string = JSBundle.message((String)"node.js.remote.interpreters.plugin.missing", (Object[])new Object[]{pathToPluginsPage});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeJSRemoteInterpreterManager", "noRemoteNodeInterpreterPluginMessage"));
        }
        return string;
    }

    public abstract RemoteSdkCredentialsProducer<NodeJSRemoteSdkCredentials> getRemoteSdkCredentialsProducer(Function<RemoteCredentials, NodeJSRemoteSdkCredentials> var1, RemoteConnectionCredentialsWrapper var2);

    @Nullable
    public abstract String createRemoteInterpreter(Project var1);

    public abstract List<String> getRemoteInterpreters();

    public abstract List<Pair<String, SemVer>> getRemoteInterpretersWithVersions();

    @NotNull
    public abstract SemVer getNodeVersionCached(@NotNull String var1);

    public abstract SemVer getNodeVersion(@Nullable Project var1, NodeJSRemoteSdkCredentials var2) throws RemoteSdkException, InterruptedException;

    @NotNull
    public abstract NodeJSRemoteSdkCredentials getCredentialsById(@NotNull String var1) throws RemoteSdkException, InterruptedException;

    @NotNull
    public abstract RemoteSdkAdditionalData getRemoteSdkAdditionalData(Project var1, @NotNull String var2) throws ExecutionException;

    @NotNull
    public abstract OSProcessHandler createProcessHandler(@NotNull Project var1, @NotNull GeneralCommandLine var2, @NotNull String var3, int var4, int var5) throws InterruptedException, RemoteSdkException;

    @NotNull
    public abstract OSProcessHandler createProcessHandler(@NotNull Project var1, @NotNull GeneralCommandLine var2, @NotNull String var3, @NotNull List<Integer> var4) throws InterruptedException, RemoteSdkException;

    @NotNull
    public abstract PathMappingSettings setupMappings(@NotNull Project var1, @NotNull RemoteSdkAdditionalData var2) throws ExecutionException;

    @NotNull
    public abstract NodeFileTransfer getFileTransfer(@NotNull Project var1, @NotNull RemoteSdkAdditionalData var2) throws ExecutionException;

    public abstract String chooseRemoteFile(Project var1, @NotNull String var2, boolean var3) throws InterruptedException, ExecutionException;

    public abstract String chooseRemoteFile(Project var1, @NotNull RemoteSdkAdditionalData var2, boolean var3) throws ExecutionException, InterruptedException;

    public abstract void deleteRemoteInterpreter(String var1);

    public abstract String editRemoteInterpreter(Project var1, String var2);

    public abstract Pair<TextFieldWithBrowseButton, Consumer<NodeJsInterpreter>> createRemoteMappingsField(@NotNull Project var1, @NotNull Disposable var2, @NotNull Consumer<String> var3);
}

