/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class NodeModuleSearchUtil {
    private static final String NODE_MODULES = "node_modules";
    public static final String[] FILE_EXTENSIONS_IN_ORDER = new String[]{".coffee", ".d.ts", ".ts", ".js", ".jsx", ".json", ".node"};
    private static final Key<Pair<String, Long>> REDIRECT_PATHS_CACHE = Key.create((String)"Node.JS.Module.Redirect.Path");

    private NodeModuleSearchUtil() {
    }

    public static void findModulesWithName(@NotNull List<CompletionModuleInfo> modules, @NotNull String moduleName, @Nullable VirtualFile requester, @Nullable NodeSettings nodeSettings, boolean includeGloballyInstalled) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithName"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithName"));
        }
        if (requester != null) {
            NodeModuleSearchUtil.findModulesWithNameFromNodeModulesDir(modules, requester, moduleName);
        }
        if (nodeSettings != null) {
            VirtualFile globalNodeModulesDir;
            NodeModuleSearchUtil.findModulesWithNameInGlobalFolders(modules, moduleName, nodeSettings.getGlobalFolders());
            if (includeGloballyInstalled && (globalNodeModulesDir = nodeSettings.getGlobalNodeModulesVirtualDir()) != null) {
                NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, globalNodeModulesDir, ModuleType.GLOBAL_FOLDER, moduleName);
            }
        }
    }

    public static void findModulesWithName(@NotNull List<CompletionModuleInfo> modules, @NotNull String moduleName, @Nullable VirtualFile requester, boolean includeGloballyInstalled, @Nullable NodeJsInterpreter interpreter) {
        VirtualFile globalNodeModulesDir;
        NodeJsLocalInterpreter local;
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithName"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithName"));
        }
        if (requester != null) {
            NodeModuleSearchUtil.findModulesWithNameFromNodeModulesDir(modules, requester, moduleName);
        }
        if ((local = NodeJsLocalInterpreter.tryCast(interpreter)) != null && includeGloballyInstalled && (globalNodeModulesDir = local.getGlobalNodeModulesVirtualDir()) != null) {
            NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, globalNodeModulesDir, ModuleType.GLOBAL_FOLDER, moduleName);
        }
    }

    public static void findModulesByNameInContentRoots(@NotNull List<CompletionModuleInfo> modules, @NotNull String moduleName, @NotNull Project project, boolean includeNodeModulesOfSecondLevel, @Nullable NodeJsInterpreter interpreter, boolean includeGloballyInstalled) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesByNameInContentRoots"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesByNameInContentRoots"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesByNameInContentRoots"));
        }
        ReadAction.run(() -> {
            VirtualFile globalNodeModulesDir;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$findModulesByNameInContentRoots$0"));
            }
            if (modules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$findModulesByNameInContentRoots$0"));
            }
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$findModulesByNameInContentRoots$0"));
            }
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                    VirtualFile nodeModulesDir = contentRoot.findChild(NODE_MODULES);
                    if (!NodeModuleSearchUtil.isDirectory(nodeModulesDir)) continue;
                    if (includeNodeModulesOfSecondLevel) {
                        NodeModuleSearchUtil.findModulesByNameInNodeModulesOfFirstAndSecondsLevels(modules, nodeModulesDir, moduleName);
                        continue;
                    }
                    NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, nodeModulesDir, ModuleType.NODE_MODULES_DIR, moduleName);
                }
            }
            NodeJsLocalInterpreter local = NodeJsLocalInterpreter.tryCast(interpreter);
            if (local != null && includeGloballyInstalled && (globalNodeModulesDir = local.getGlobalNodeModulesVirtualDir()) != null) {
                NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, globalNodeModulesDir, ModuleType.GLOBAL_FOLDER, moduleName);
            }
        });
    }

    private static void findModulesWithNameFromNodeModulesDir(@NotNull List<CompletionModuleInfo> modules, @NotNull VirtualFile requester, @NotNull String moduleName) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithNameFromNodeModulesDir"));
        }
        if (requester == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requester", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithNameFromNodeModulesDir"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithNameFromNodeModulesDir"));
        }
        NodeModuleSearchUtil.processUpNodeModulesDirs(null, requester, (Processor<VirtualFile>)((Processor)nodeModulesDir -> {
            if (modules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$findModulesWithNameFromNodeModulesDir$1"));
            }
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$findModulesWithNameFromNodeModulesDir$1"));
            }
            NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, nodeModulesDir, ModuleType.NODE_MODULES_DIR, moduleName);
            return true;
        }));
    }

    private static void findModulesWithNameInGlobalFolders(@NotNull List<CompletionModuleInfo> modules, @NotNull String moduleName, @NotNull List<VirtualFile> globalFolders) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithNameInGlobalFolders"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithNameInGlobalFolders"));
        }
        if (globalFolders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalFolders", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithNameInGlobalFolders"));
        }
        for (VirtualFile dir : globalFolders) {
            if (!dir.isValid() || !dir.isDirectory()) continue;
            NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, dir, ModuleType.GLOBAL_FOLDER, moduleName);
        }
    }

    private static void findModulesByNameInNodeModulesOfFirstAndSecondsLevels(@NotNull List<CompletionModuleInfo> modules, @NotNull VirtualFile firstLevelNodeModulesDir, @NotNull String moduleName) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesByNameInNodeModulesOfFirstAndSecondsLevels"));
        }
        if (firstLevelNodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstLevelNodeModulesDir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesByNameInNodeModulesOfFirstAndSecondsLevels"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesByNameInNodeModulesOfFirstAndSecondsLevels"));
        }
        for (VirtualFile moduleDir : firstLevelNodeModulesDir.getChildren()) {
            VirtualFile secondLevelModuleDir;
            VirtualFile secondLevelNodeModulesDir;
            if (!moduleDir.isDirectory()) continue;
            String name = moduleDir.getName();
            if (moduleName.equals(name) && NodeModuleSearchUtil.canLoadDirectory(moduleDir)) {
                modules.add(new CompletionModuleInfo(name, moduleDir, ModuleType.NODE_MODULES_DIR));
            }
            if (!NodeModuleSearchUtil.isDirectory(secondLevelNodeModulesDir = moduleDir.findChild(NODE_MODULES)) || !NodeModuleSearchUtil.isDirectory(secondLevelModuleDir = secondLevelNodeModulesDir.findChild(moduleName)) || !NodeModuleSearchUtil.canLoadDirectory(secondLevelModuleDir)) continue;
            modules.add(new CompletionModuleInfo(name, secondLevelModuleDir, ModuleType.NODE_MODULES_DIR));
        }
    }

    public static boolean findModuleWithNameInDirectory(@NotNull List<CompletionModuleInfo> modules, @NotNull VirtualFile dir, @NotNull ModuleType moduleType, @NotNull String moduleName) {
        boolean ok;
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModuleWithNameInDirectory"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModuleWithNameInDirectory"));
        }
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModuleWithNameInDirectory"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModuleWithNameInDirectory"));
        }
        VirtualFile child = dir.findFileByRelativePath(moduleName);
        if (child == null && dir instanceof NewVirtualFile && ApplicationManager.getApplication().isDispatchThread()) {
            child = ((NewVirtualFile)dir).refreshAndFindChild(moduleName);
        }
        if (child != null && (ok = NodeModuleSearchUtil.canLoad(child))) {
            String name = child.isDirectory() ? child.getName() : child.getNameWithoutExtension();
            modules.add(new CompletionModuleInfo(name, child, moduleType));
            return true;
        }
        return false;
    }

    @NotNull
    public static Collection<CompletionModuleInfo> collectVisibleNodeModules(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull Project project, @Nullable VirtualFile requester, @Nullable NodeSettings nodeSettings) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectVisibleNodeModules"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectVisibleNodeModules"));
        }
        if (requester != null) {
            NodeModuleSearchUtil.collectModulesFromNodeModulesDir(modules, project, requester);
        }
        if (requester != null) {
            NodeModuleSearchUtil.collectModulesFromResourceRoots(modules, project, requester);
        }
        if (nodeSettings != null) {
            NodeModuleSearchUtil.collectModulesFromGlobalFolders(modules, nodeSettings.getGlobalFolders());
        }
        Collection<CompletionModuleInfo> collection = modules.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectVisibleNodeModules"));
        }
        return collection;
    }

    private static void collectModulesFromResourceRoots(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull Project project, @Nullable VirtualFile requester) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesFromResourceRoots"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesFromResourceRoots"));
        }
        WebResourcesPathsConfiguration pathsConfiguration = WebResourcesPathsConfiguration.getInstance((Project)project);
        if (pathsConfiguration != null) {
            List directories = pathsConfiguration.getResourceDirectories();
            NodeModuleSearchUtil.collectModulesInDirectories(directories, modules, ModuleType.RESOURCE_ROOT);
        }
        if (requester != null) {
            List<VirtualFile> resourceRoots = NodeModuleSearchUtil.getJavaResourceRoots(project, requester);
            NodeModuleSearchUtil.collectModulesInDirectories(resourceRoots, modules, ModuleType.RESOURCE_ROOT);
        }
    }

    private static void collectModulesFromNodeModulesDir(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull Project project, @NotNull VirtualFile requester) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesFromNodeModulesDir"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesFromNodeModulesDir"));
        }
        if (requester == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requester", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesFromNodeModulesDir"));
        }
        NodeModuleSearchUtil.processUpNodeModulesDirs(project, requester, (Processor<VirtualFile>)((Processor)nodeModulesDir -> {
            if (modules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$collectModulesFromNodeModulesDir$2"));
            }
            NodeModuleSearchUtil.collectModulesInDirectory(nodeModulesDir, modules, ModuleType.NODE_MODULES_DIR);
            return true;
        }));
    }

    private static void collectModulesFromGlobalFolders(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull List<VirtualFile> globalFolders) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesFromGlobalFolders"));
        }
        if (globalFolders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalFolders", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesFromGlobalFolders"));
        }
        for (VirtualFile dir : globalFolders) {
            if (!dir.isValid() || !dir.isDirectory()) continue;
            NodeModuleSearchUtil.collectModulesInDirectory(dir, modules, ModuleType.GLOBAL_FOLDER);
        }
    }

    private static void collectModulesInDirectories(@NotNull List<VirtualFile> directories, @NotNull Map<String, CompletionModuleInfo> modules, @NotNull ModuleType moduleType) {
        if (directories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesInDirectories"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesInDirectories"));
        }
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesInDirectories"));
        }
        for (VirtualFile directory : directories) {
            if (!directory.isDirectory() || !directory.isValid()) continue;
            NodeModuleSearchUtil.collectModulesInDirectory(directory, modules, moduleType);
        }
    }

    private static void collectModulesInDirectory(@NotNull VirtualFile dir, @NotNull Map<String, CompletionModuleInfo> modules, @NotNull ModuleType moduleType) {
        VirtualFile[] children;
        PackageJsonData data;
        Set<String> dependencies;
        VirtualFile packageJson;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesInDirectory"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesInDirectory"));
        }
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesInDirectory"));
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(dir) && (packageJson = NodeModuleUtil.findPackageJsonByNodeModules(dir)) != null && packageJson.isValid() && !(dependencies = (data = PackageJsonUtil.getOrCreateData(packageJson)).getAllDependencies()).isEmpty()) {
            for (String dependency : dependencies) {
                VirtualFile moduleDir = dir.findFileByRelativePath(dependency);
                if (moduleDir == null || !moduleDir.isDirectory() || !moduleDir.isValid() || modules.containsKey(dependency)) continue;
                modules.put(dependency, new CompletionModuleInfo(dependency, moduleDir, moduleType));
            }
            return;
        }
        for (VirtualFile child : children = VfsUtil.getChildren((VirtualFile)dir)) {
            String moduleName;
            String childName = child.getName();
            if (NodeModuleSearchUtil.isScopeName(child)) {
                for (VirtualFile grandChild : child.getChildren()) {
                    String moduleName2;
                    if (!NodeModuleSearchUtil.canLoad(grandChild) || modules.containsKey(moduleName2 = childName + "/" + NodeModuleSearchUtil.getModuleName(grandChild))) continue;
                    modules.put(moduleName2, new CompletionModuleInfo(moduleName2, grandChild, moduleType));
                }
                continue;
            }
            if (!NodeModuleSearchUtil.canLoad(child) || modules.containsKey(moduleName = NodeModuleSearchUtil.getModuleName(child))) continue;
            modules.put(moduleName, new CompletionModuleInfo(moduleName, child, moduleType));
        }
    }

    private static String getModuleName(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "getModuleName"));
        }
        return fileOrDir.isDirectory() ? fileOrDir.getName() : fileOrDir.getNameWithoutExtension();
    }

    private static boolean canLoad(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "canLoad"));
        }
        if (fileOrDir.isDirectory()) {
            return NodeModuleSearchUtil.canLoadDirectory(fileOrDir);
        }
        return NodeModuleSearchUtil.canLoadFile(fileOrDir);
    }

    public static boolean canLoadFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "canLoadFile"));
        }
        String ext = file.getExtension();
        if (ext == null) {
            return false;
        }
        for (String expectedExt : FILE_EXTENSIONS_IN_ORDER) {
            if (!expectedExt.endsWith(ext) || ext.length() + 1 != expectedExt.length()) continue;
            return true;
        }
        return false;
    }

    public static boolean canLoadDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "canLoadDirectory"));
        }
        VirtualFile packageJson = dir.findChild("package.json");
        if (NodeModuleSearchUtil.isFile(packageJson)) {
            return true;
        }
        for (String ext : FILE_EXTENSIONS_IN_ORDER) {
            VirtualFile child = dir.findChild("index" + ext);
            if (!NodeModuleSearchUtil.isFile(child)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ResolvedModuleInfo resolveModule(@NotNull String requiredModuleName, @Nullable VirtualFile requester, @Nullable NodeSettings nodeSettings, @NotNull List<VirtualFile> nodePathFolders, boolean respectResourceRoots, @Nullable Project project) {
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModule"));
        }
        if (nodePathFolders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePathFolders", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModule"));
        }
        ResolvedModuleInfo info = null;
        if (requester != null) {
            info = NodeModuleSearchUtil.resolveModuleFromNodeModulesDir(requester, requiredModuleName, NodeModuleDirectorySearchProcessor.PROCESSOR);
        }
        if (info == null && respectResourceRoots && project != null) {
            info = NodeModuleSearchUtil.resolveModuleFromResourceRoots(project, requiredModuleName, requester);
        }
        if (info == null) {
            info = NodeModuleSearchUtil.resolveModuleFromGlobalFolders(requiredModuleName, nodePathFolders);
        }
        if (info == null && nodeSettings != null) {
            info = NodeModuleSearchUtil.resolveModuleFromGlobalFolders(requiredModuleName, nodeSettings.getGlobalFolders());
        }
        return info;
    }

    @Nullable
    public static ResolvedModuleInfo resolveModuleFromNodeModulesDir(@NotNull VirtualFile requester, @NotNull String requiredModuleName, @NotNull NodeModuleDirectorySearchProcessor processor) {
        if (requester == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requester", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleFromNodeModulesDir"));
        }
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleFromNodeModulesDir"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleFromNodeModulesDir"));
        }
        Ref resolveRef = Ref.create();
        NodeModuleSearchUtil.processUpNodeModulesDirs(null, requester, (Processor<VirtualFile>)((Processor)nodeModulesDir -> {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$resolveModuleFromNodeModulesDir$3"));
            }
            if (requiredModuleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$resolveModuleFromNodeModulesDir$3"));
            }
            ResolvedModuleInfo info = processor.doResolveModule(null, ModuleType.NODE_MODULES_DIR, (VirtualFile)nodeModulesDir, requiredModuleName, true, true);
            if (info != null) {
                resolveRef.set((Object)info);
                return false;
            }
            return true;
        }));
        return (ResolvedModuleInfo)resolveRef.get();
    }

    @Nullable
    private static ResolvedModuleInfo resolveModuleFromResourceRoots(@NotNull Project project, @NotNull String requiredModuleName, @Nullable VirtualFile requester) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleFromResourceRoots"));
        }
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleFromResourceRoots"));
        }
        WebResourcesPathsConfiguration pathsConfiguration = WebResourcesPathsConfiguration.getInstance((Project)project);
        ResolvedModuleInfo info = null;
        if (pathsConfiguration != null) {
            List directories = pathsConfiguration.getResourceDirectories();
            info = NodeModuleSearchUtil.resolveModuleInResourceRoots(requiredModuleName, directories);
        }
        if (info == null && requester != null) {
            List<VirtualFile> resourceRoots = NodeModuleSearchUtil.getJavaResourceRoots(project, requester);
            info = NodeModuleSearchUtil.resolveModuleInResourceRoots(requiredModuleName, resourceRoots);
        }
        return info;
    }

    @NotNull
    private static List<VirtualFile> getJavaResourceRoots(@NotNull Project project, @NotNull VirtualFile requester) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "getJavaResourceRoots"));
        }
        if (requester == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requester", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "getJavaResourceRoots"));
        }
        if (!PlatformUtils.isIdeaUltimate()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "getJavaResourceRoots"));
            }
            return list;
        }
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
        Module module = index.getModuleForFile(requester, false);
        if (module == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "getJavaResourceRoots"));
            }
            return list;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        List list = moduleRootManager.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "getJavaResourceRoots"));
        }
        return list;
    }

    @Nullable
    private static ResolvedModuleInfo resolveModuleInResourceRoots(@NotNull String requiredModuleName, @NotNull List<VirtualFile> resourceRoots) {
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleInResourceRoots"));
        }
        if (resourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceRoots", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleInResourceRoots"));
        }
        if (resourceRoots.isEmpty()) {
            return null;
        }
        for (VirtualFile rootDir : resourceRoots) {
            ResolvedModuleInfo info = NodeModuleSearchUtil.doResolveModule(null, ModuleType.RESOURCE_ROOT, rootDir, requiredModuleName, true, true);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private static void processUpNodeModulesDirs(@Nullable Project project, @NotNull VirtualFile requester, @NotNull Processor<VirtualFile> nodeModulesDirProcessor) {
        boolean continueIteration;
        VirtualFile nodeModulesDir;
        ProjectFileIndex index;
        if (requester == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requester", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "processUpNodeModulesDirs"));
        }
        if (nodeModulesDirProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDirProcessor", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "processUpNodeModulesDirs"));
        }
        VirtualFile dir = requester;
        if (!dir.isDirectory()) {
            dir = requester.getParent();
        }
        ProjectFileIndex projectFileIndex = index = project == null ? null : ProjectFileIndex.getInstance((Project)project);
        while (!(dir == null || index != null && index.getContentRootForFile(dir, false) == null || (nodeModulesDir = dir.findChild(NODE_MODULES)) != null && nodeModulesDir.isDirectory() && nodeModulesDir.isValid() && !(continueIteration = nodeModulesDirProcessor.process((Object)nodeModulesDir)))) {
            dir = dir.getParent();
        }
    }

    @Nullable
    private static ResolvedModuleInfo resolveModuleFromGlobalFolders(@NotNull String requiredModuleName, @NotNull List<VirtualFile> globalFolders) {
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleFromGlobalFolders"));
        }
        if (globalFolders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalFolders", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleFromGlobalFolders"));
        }
        for (VirtualFile dir : globalFolders) {
            ResolvedModuleInfo info;
            if (!dir.isValid() || !dir.isDirectory() || (info = NodeModuleSearchUtil.doResolveModule(null, ModuleType.GLOBAL_FOLDER, dir, requiredModuleName, true, true)) == null) continue;
            return info;
        }
        return null;
    }

    @Nullable
    public static ResolvedModuleInfo resolveModuleByExactPath(@NotNull VirtualFile baseDir, @NotNull String requiredModuleName) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleByExactPath"));
        }
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleByExactPath"));
        }
        return NodeModuleSearchUtil.doResolveModule(null, ModuleType.EXACT_PATH, baseDir, requiredModuleName, true, true);
    }

    @Nullable
    private static ResolvedModuleInfo doResolveModule(@Nullable VirtualFile moduleSourceRoot, @NotNull ModuleType type, @NotNull VirtualFile baseDir, @NotNull String requiredModuleName, boolean resolveDirectory, boolean respectPackageJson) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "doResolveModule"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "doResolveModule"));
        }
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "doResolveModule"));
        }
        return NodeModuleDirectorySearchProcessor.PROCESSOR.doResolveModule(moduleSourceRoot, type, baseDir, requiredModuleName, resolveDirectory, respectPackageJson);
    }

    @NotNull
    public static Pair<Boolean, ModuleMainFiles> findMainModuleInPackage(@NotNull VirtualFile dir) {
        VirtualFile candidate;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findMainModuleInPackage"));
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(dir);
        if (packageJson != null) {
            PackageJsonData data = PackageJsonUtil.getOrCreateData(packageJson);
            VirtualFile mainModule = NodeModuleSearchUtil.findMainModuleByPath(dir, data.getMain());
            VirtualFile mainJsNextModule = NodeModuleSearchUtil.findMainModuleByPath(dir, data.getJsNextMain());
            if (mainModule != null || mainJsNextModule != null) {
                Pair pair = Pair.create((Object)true, (Object)new ModuleMainFiles(mainModule, mainJsNextModule));
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findMainModuleInPackage"));
                }
                return pair;
            }
        }
        if ((candidate = dir.findChild("index.js")) == null) {
            candidate = dir.findChild("index.node");
        }
        Pair pair = Pair.create((Object)false, (Object)new ModuleMainFiles(candidate, candidate));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findMainModuleInPackage"));
        }
        return pair;
    }

    @Nullable
    public static VirtualFile findMainModuleByPath(@NotNull VirtualFile dir, @Nullable String main) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findMainModuleByPath"));
        }
        if (main != null) {
            String[] parts = (main = main.startsWith("./") ? main.substring(2) : main).split("/");
            VirtualFile file = VfsUtil.findRelativeFile((VirtualFile)dir, (String[])parts);
            if (file == null && parts.length > 0 && !parts[parts.length - 1].contains(".")) {
                String withoutExtension = parts[parts.length - 1];
                parts[parts.length - 1] = withoutExtension + ".js";
                file = VfsUtil.findRelativeFile((VirtualFile)dir, (String[])parts);
                if (file == null) {
                    parts[parts.length - 1] = withoutExtension + ".node";
                    file = VfsUtil.findRelativeFile((VirtualFile)dir, (String[])parts);
                }
            }
            return file;
        }
        return null;
    }

    public static String getRedirectPathForModule(@NotNull Project project, @NotNull VirtualFile mainModule) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "getRedirectPathForModule"));
        }
        if (mainModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainModule", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "getRedirectPathForModule"));
        }
        Pair value = (Pair)mainModule.getUserData(REDIRECT_PATHS_CACHE);
        if (value != null && ((Long)value.second).longValue() != mainModule.getModificationCount()) {
            value = null;
        }
        if (value == null) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(mainModule);
            if (psiFile == null) {
                return null;
            }
            String path = CommonJSUtil.getNodeJsRedirectPath(psiFile);
            value = Pair.create((Object)path, (Object)mainModule.getModificationCount());
            mainModule.putUserData(REDIRECT_PATHS_CACHE, (Object)value);
        }
        return (String)value.first;
    }

    @Contract(value="null -> false", pure=true)
    static boolean isFile(@Nullable VirtualFile file) {
        return file != null && file.isValid() && !file.isDirectory();
    }

    @Contract(value="null -> false", pure=true)
    private static boolean isDirectory(@Nullable VirtualFile dir) {
        return dir != null && dir.isValid() && dir.isDirectory();
    }

    @Nullable
    public static VirtualFile findAncestorNodeModulesDir(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findAncestorNodeModulesDir"));
        }
        for (VirtualFile f = fileOrDir.getParent(); f != null; f = f.getParent()) {
            if (!StringUtil.equals((CharSequence)NODE_MODULES, (CharSequence)f.getNameSequence())) continue;
            return f;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findDependencyRoot(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findDependencyRoot"));
        }
        VirtualFile scope = fileOrDir;
        VirtualFile pkg = fileOrDir;
        while (scope != null) {
            VirtualFile parent = scope.getParent();
            if (parent != null && parent.isDirectory() && StringUtil.equals((CharSequence)NODE_MODULES, (CharSequence)parent.getNameSequence())) {
                return NodeModuleSearchUtil.isScopeName(scope) ? pkg : scope;
            }
            pkg = scope;
            scope = parent;
        }
        return null;
    }

    public static boolean isScopeName(@Nullable VirtualFile dir) {
        return dir != null && StringUtil.startsWith((CharSequence)dir.getNameSequence(), (CharSequence)"@");
    }

    public static boolean isFileModuleRequired(@NotNull String requiredModuleName) {
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "isFileModuleRequired"));
        }
        return requiredModuleName.startsWith("/") || requiredModuleName.startsWith("./") || requiredModuleName.startsWith("../");
    }

    public static class ModuleMainFiles {
        @Nullable
        private final VirtualFile myMain;
        @Nullable
        private final VirtualFile myJsNextMain;

        public ModuleMainFiles(@Nullable VirtualFile jsNextMain, @Nullable VirtualFile main) {
            this.myMain = main;
            this.myJsNextMain = jsNextMain;
        }

        @Nullable
        public VirtualFile getMain() {
            return this.myMain;
        }

        @Nullable
        public VirtualFile getJsNextMain() {
            return this.myJsNextMain;
        }

        public boolean isEmpty() {
            return this.myMain == null && this.myJsNextMain == null;
        }
    }
}

