/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PackageJsonField {
    dependencies,
    devDependencies,
    optionalDependencies;

    private final String myName = this.name();

    public String getName() {
        return this.myName;
    }

    @Nullable
    public static PackageJsonField findDependencyByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/nodejs/PackageJsonField", "findDependencyByName"));
        }
        if (dependencies.getName().equals(name)) {
            return dependencies;
        }
        if (devDependencies.getName().equals(name)) {
            return devDependencies;
        }
        if (optionalDependencies.getName().equals(name)) {
            return optionalDependencies;
        }
        return null;
    }
}

